import { Component, OnInit, OnDestroy } from '@angular/core';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { Input, Output, EventEmitter } from '@angular/core';
import { CoreSession } from '../../../core/core.session';
import { ItemService } from '../../../shared/services/data-definition/product/item.service';
import { GeneralFilter } from '../../../shared/models/general/generalFilter.model';
import { IDateTimePickerProperties } from '../../../shared/models/dateTimeModel/date-time-properties.interface';
import { DateTimeModel } from '../../../shared/models/dateTimeModel/date-time.model';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../shared/models/constants/constant-configuration';
import { DatePipe } from '@angular/common';
import { Observable } from 'rxjs';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { TranslateService } from '@ngx-translate/core';
import { MasterDataService } from '../../master-data-definition/master-data.service';
import { HttpErrorResponse } from '@angular/common/http';
import { IncidentService } from '../incident.service';
import { RecallService } from '../recall.service';
import { IncidentStatusEnum } from '../../../shared/models/enums/incident-status-enum';




@Component({
  selector: 'app-incidents-entry',
  templateUrl: './incidents-entry.component.html',
  styleUrls: ['./incidents-entry.component.css'],
  providers: [DatePipe]
})
export class IncidentsEntryComponent implements OnInit {
  @Input() saveEvent: Observable<void>;
  @Input() currentIncident: any = null;
  @Input() isEditMode: boolean = false;
  saveBtnSubscription: any;
  @Output() onSavingIncidentEvent = new EventEmitter();
  batchNumber: string = '';
  expiryDate: DateTimeModel = new DateTimeModel();
  itemsDataSource: any[] = [];
  noteString: string;
  tabsIndex = {
    definitionData: 0
  }
  incidentEntryForm: FormGroup;
  showDefinitionData: boolean = false;
  isItemsLoading = false;
  navLinks: any[];

  itemFilter: GeneralFilter = {
    packId: -1,
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: 15
    }
  };

  expiryDateProperties: IDateTimePickerProperties = {
    label: 'Desc_ExpiryDate',
    formControlName: 'expiryDate',
    isCalendarOnly: true
  };

  currentIncidentItem: any;

  constructor(private coreSession: CoreSession,
    private itemService: ItemService,
    private sessionData: SessionDataProvider,
    private translateService: TranslateService,
    private masterDataService: MasterDataService,
    private incidentService: IncidentService,
    private datepipe: DatePipe) { }

  ngOnInit() {
    this.subscribeSaveClick();
    // this.prepareNavigation();
    // this.navLinks[0].isActive = true;
    this.showEntrySection(this.tabsIndex.definitionData);
    // this.populateAllItemsList(-1);
    if (this.isEditMode) {
      this.coreSession.SetTitle('Edit Recall Task');
      this.getIncidentDataOnEdit();
    } else {
      this.coreSession.SetTitle('Add Recall Task');
      this.currentIncident = {
        incidentId: -1,
        isNew: true,
        incidentName: null,
        itemId: null,
        batchNumber: null,
        notes: null,
        expiryDate: null,
        status: IncidentStatusEnum.Pending,
      }
    }
    this.initIncidentForm();
  }

  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_Incident_Definition',
        index: this.tabsIndex.definitionData,

      }
    ];
  }

  showEntrySection(selectedIndex: number) {
    // this.navLinks.forEach(a => a.isActive = false);
    // this.navLinks[selectedIndex].isActive = true;
    if (selectedIndex == null) {
      selectedIndex = 0;
    }
    if (selectedIndex == 0) {
      this.showDefinitionData = true;
    } else {
      this.showDefinitionData = false;
    }
  }

  initIncidentForm() {
    this.incidentEntryForm = new FormGroup({
      incidentName: new FormControl(null, Validators.required),
      Note: new FormControl(null, Validators.required),
      itemId: new FormControl(null, Validators.required),
      expiryDate: new FormControl(null),
      batchNumber: new FormControl(' '),
    });
  }
  get itemIdControl() {
    return this.incidentEntryForm.get('itemId');
  }
  getIncidentDataOnEdit() {
    this.coreSession.ModalLoading.Show();
    this.incidentService.getIncidentData(this.currentIncident.incidentId).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.currentIncident = response.data;
        this.fillEditEntryForm();
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });

  }

  // fetchMoreItemsFromServer(term) {
  //   this.itemFilter.customListFilter.searchFilter = term;
  //   this.populateAllItemsList(-1);
  // }

  // not implemented anymore.
  //   populateAllItemsList(packId: number) {
  //     this.itemFilter.packId = packId;
  //     this.itemFilter.customListFilter.page = this.itemsDataSource.length;
  //     this.isItemsLoading = true;
  //   Item-level selection
  //      this.itemService.getItemsListSharedTable(this.itemFilter).subscribe(response => {
  //       if (response != undefined && response.data != undefined) {
  //         this.itemsDataSource = this.itemsDataSource.concat(
  //           response.data.data);
  //       }
  //       this.isItemsLoading = false;
  //      });
  //   }


  onItemDataChanged($event) {
    if ($event) {
      this.currentIncidentItem = $event;
    } else {
      this.currentIncidentItem = undefined;
    }
  }

  onExpiryDateSelected(date) {
    // fill batch by default?
    if (date && date != null) {
      this.batchNumber = null;
      this.expiryDate = date;
      let batchNumberFormat = this.sessionData.getConfigurationValue(ConstantConfigurations.BatchNumberFormat);
      if (batchNumberFormat && batchNumberFormat != '' && batchNumberFormat != "No Format" && batchNumberFormat != "NoFormat") {
        if (this.expiryDate && this.expiryDate.date) {
          this.batchNumber = this.datepipe.transform(this.expiryDate.date, batchNumberFormat);
        } else {
          this.batchNumber = '';
        }
      } else {
        this.batchNumber = this.datepipe.transform(this.expiryDate.date, this.coreSession.BatchNoFormat);
      }
    }
    this.incidentEntryForm.get('batchNumber').setValue(this.batchNumber);
  }

  subscribeSaveClick() {
    this.saveBtnSubscription = this.saveEvent.subscribe(() => {
      this.onAddEditIncident();
    });
  }
  onAddEditIncident() {
    this.coreSession.markFormGroupTouched(this.incidentEntryForm);
    if (this.incidentEntryForm.invalid) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }

    // Fill Incident Object
    this.fillcurrentIncident();
    // Check if Incident Code is unique
    // let codeFilter = {
    //   tableName: 'Incidents',
    //   columnName: 'incidentName',
    //   insertedValue: this.currentIncident.incidentName,
    //   excludedString: ' And IncidentId != ' + this.currentIncident.incidentId,
    // }
    if (this.currentIncident != null && this.currentIncident.incidentName != null) {
      this.coreSession.ModalLoading.Show();
      this.saveIncidentToDB();
      // this.masterDataService.checkIfUniqueValue(codeFilter).subscribe( response => {
      //   this.coreSession.ModalLoading.Hide();
      //   if (response.status != null && response.status >= 0) {
      //     if (!response.data) {
      //       this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueCode));
      //     }
      //     else {
      //       this.saveIncidentToDB();
      //     }
      //   } else {
      //     this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      //   }
      // } , (error: HttpErrorResponse) => {
      //   this.coreSession.ModalLoading.Hide();
      //   this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      // });
    }
  }

  fillcurrentIncident() {
    if (!this.isEditMode) {
      this.currentIncident.incidentId = -1;
      this.currentIncident.isNew = true;
      this.currentIncident.incidentName = this.incidentEntryForm.get('incidentName').value;
      this.currentIncident.itemId = this.currentIncidentItem.itemId;
      if (this.incidentEntryForm.get('batchNumber').value != null && this.incidentEntryForm.get('batchNumber').value != " " && this.incidentEntryForm.get('batchNumber').value) {
        this.currentIncident.batchNumber = this.incidentEntryForm.get('batchNumber').value
      } else { this.currentIncident.batchNumber = this.coreSession.DefaultBatchNumber; }
      this.currentIncident.notes = this.incidentEntryForm.get('Note').value;
      this.currentIncident.status = IncidentStatusEnum.Pending;
      if (this.incidentEntryForm.get('expiryDate').value != null && this.incidentEntryForm.get('expiryDate').value != "" && this.incidentEntryForm.get('expiryDate').value) {
        this.currentIncident.expiryDate = this.incidentEntryForm.get('expiryDate').value;
      } else { this.currentIncident.expiryDate = this.coreSession.DefaultExpiryDate(); }
    }
    else {
      this.currentIncident.isNew = false;
      this.currentIncident.incidentName = this.incidentEntryForm.get('incidentName').value;
      this.currentIncident.itemId = this.incidentEntryForm.get('itemId').value;
      if (this.incidentEntryForm.get('batchNumber').value != null && this.incidentEntryForm.get('batchNumber').value != " " && this.incidentEntryForm.get('batchNumber').value) {
        this.currentIncident.batchNumber = this.incidentEntryForm.get('batchNumber').value
      } else { this.currentIncident.batchNumber = this.coreSession.DefaultBatchNumber; }
      this.currentIncident.notes = this.incidentEntryForm.get('Note').value;
      if (this.incidentEntryForm.get('expiryDate').value != null && this.incidentEntryForm.get('expiryDate').value != "" && this.incidentEntryForm.get('expiryDate').value) {
        this.currentIncident.expiryDate = this.incidentEntryForm.get('expiryDate').value;
      } else { this.currentIncident.expiryDate = this.coreSession.DefaultExpiryDate() }
    }
  }

  saveIncidentToDB() {
    this.coreSession.ModalLoading.Show();
    this.incidentService.saveIncident(this.currentIncident).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
        this.onSavingIncidentEvent.emit();
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
  }

  fillEditEntryForm() {
    var batchNum: string;
    var expDate;
    if (this.currentIncident.expiryDate === "1989-12-31T00:00:00") {
      expDate = null;
    } else {
      expDate = this.currentIncident.expiryDate;
    }
    if (this.currentIncident.batchNumber === this.coreSession.DefaultBatchNumber) {
      batchNum = ' ';
    } else {
      batchNum = this.currentIncident.batchNumber;
    }

    this.incidentEntryForm = new FormGroup({
      incidentName: new FormControl(this.currentIncident.incidentName, Validators.required),
      Note: new FormControl(this.currentIncident.notes, Validators.required),
      itemId: new FormControl(this.currentIncident.itemId, Validators.required),
      expiryDate: new FormControl(expDate),
      batchNumber: new FormControl(batchNum),
    });
  }

  ngOnDestroy() {
    this.currentIncidentItem = null;
    this.saveBtnSubscription.unsubscribe();
  }

}
