import { Component, OnInit } from '@angular/core';
import { SessionDataProvider } from '../../../core/session-data-provider.service';

@Component({
  selector: 'app-recall-main',
  templateUrl: './recall-main.component.html',
  styleUrls: ['./recall-main.component.css']
})
export class RecallMainComponent implements OnInit {

  navLinks: any[];
  hideTabs: boolean = false;
  indexCounter: number = -1;

  constructor(
    private sessionDataProvider: SessionDataProvider) {
  }

  ngOnInit() {
    this.prepareNavigation();
    this.navLinks[0].isActive = true;
  }
  prepareNavigation() {
    this.navLinks = [];
    for (let menu of this.sessionDataProvider.allMenusAvailable) {
      if (menu.parentMenuId === '1100') {
        this.indexCounter = this.indexCounter + 1
        let newName = {
          label: menu.menuName,
          link: menu.url,
          isActive: false,
          index: this.indexCounter
        };
        this.navLinks.push(newName);
      }
    }
  }
}
