import { RouterModule, Routes } from '@angular/router';
import { NgModule } from '@angular/core';
import { AuthGuard } from '../../core/auth/auth.gurad';
import { ConstantURLs } from '../../shared/models/constants/constant-URL';
import { RecallMainComponent } from './recall-main/recall-main.component';
import { RecallListComponent } from './recall-list/recall-list.component';
import { RecallSubTasksListComponent } from './recall-sub-tasks-list/recall-sub-tasks-list.component';
import { IncidentsListComponent } from './incidents-list/incidents-list.component';

const recallRouting: Routes = [
    {
      path: '',
      canActivate: [AuthGuard],
      component: RecallMainComponent,
      children: [
        {
          path: ConstantURLs.recallsListURL,
          canActivate: [AuthGuard],
          component: RecallListComponent
        },
        {
          path: ConstantURLs.recallsSubTasksListURL,
          canActivate: [AuthGuard],
          component: RecallSubTasksListComponent
        },
        {
          path: ConstantURLs.incidentsListURL,
          canActivate: [AuthGuard],
          component: IncidentsListComponent
        },
        { path: '', redirectTo: '/' + ConstantURLs.recallsMainURL + '/' + ConstantURLs.recallsListURL , pathMatch: 'full' }
      ]
    }
  ];
  @NgModule({
    imports: [RouterModule.forChild(recallRouting)],
    exports: [RouterModule]
  })
  export class RecallRoutingModule {}
