import { Injectable, Inject } from '@angular/core';

import 'rxjs/add/operator/map';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { CoreSession } from '../../core/core.session';
import { ResponseModel } from '../../shared/models/api-models/api-models';
import { WarehouseTransaction } from '../../shared/models/warehouse-transactions/warehouse-transaction.model';
@Injectable({
  providedIn: 'root'
})
export class RecallSubTasksService {

  httpOptions;
  private url = '';
  constructor(private http: HttpClient,
    @Inject('BASE_URL') baseUrl: string,
    private coreSession: CoreSession) {
    this.url = baseUrl + 'RecallSubTasks';
    this.httpOptions = {
      headers: new HttpHeaders({
        'Content-Type': 'application/json'
      })
    };
  }

  getRecallTasksList() {
    const urlValue: string = this.url + '/GetRecallTasksList';
    return this.http.get<ResponseModel>(urlValue).map(response => {
      return response.data;
    });
  }
  getRecallSubListSharedTable(filter: any) {
    const urlValue: string = this.url + '/GetRecallSubListSharedTable';
    return this.http.post(urlValue, JSON.stringify(filter), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  getRecallSubTaskDataToExecute(subTask: any) {
    const urlValue: string = this.url + '/GetRecallSubTaskDataToExecute';
    return this.http.post(urlValue, JSON.stringify(subTask), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  executeWHRecallSubTask(warehouseTransaction: WarehouseTransaction) {
    const urlValue: string = this.url + '/ExecuteWHRecallSubTask';
    return this.http
      .post<ResponseModel>(urlValue, warehouseTransaction)
      .map(response => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }
  dispatchRecallOrder(order: any) {
    const urlValue = this.url + "/DispatchRecallOrder";
    return this.http.post<ResponseModel>(urlValue, order).map(response => {
      return response;
    });
  }

}
