import { RecallMainComponent } from "./recall-main/recall-main.component";
import { RecallListComponent } from "./recall-list/recall-list.component";
import { RecallEntryComponent } from "./recall-entry/recall-entry.component";
import { NgModule } from "@angular/core";
import { CommonModule } from "@angular/common";
import { ReactiveFormsModule, FormsModule } from "@angular/forms";
import { SharedModule } from "../../shared/shared.module";
import { OwlDateTimeModule, OwlNativeDateTimeModule } from "ng-pick-datetime";
import { TranslateModule } from "@ngx-translate/core";
import { NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { NgSelectModule } from "@ng-select/ng-select";
import { RecallRoutingModule } from "./recall-routing.module";
import { NgMultiSelectDropDownModule } from "ng-multiselect-dropdown";
import { RecallSubTasksListComponent } from "./recall-sub-tasks-list/recall-sub-tasks-list.component";
import { RecallSubTaskExecutionComponent } from "./recall-sub-task-execution/recall-sub-task-execution.component";
import { GaugeChartModule } from "angular-gauge-chart";
import { IncidentsListComponent } from "./incidents-list/incidents-list.component";
import { IncidentsEntryComponent } from "./incidents-entry/incidents-entry.component";
import { NgOptionHighlightModule } from "@ng-select/ng-option-highlight";

@NgModule({
  declarations: [
    RecallMainComponent,
    RecallListComponent,
    RecallEntryComponent,
    RecallSubTasksListComponent,
    RecallSubTaskExecutionComponent,
    IncidentsListComponent,
    IncidentsEntryComponent,
  ],
  imports: [
    CommonModule,
    ReactiveFormsModule,
    FormsModule,
    RecallRoutingModule,
    SharedModule,
    OwlDateTimeModule,
    OwlNativeDateTimeModule,
    NgbModule,
    TranslateModule.forChild(),
    NgSelectModule,
    NgMultiSelectDropDownModule,
    GaugeChartModule,
    NgOptionHighlightModule,
  ],
  providers: [],
})
export class RecallModule {}
