import { Injectable, Inject } from '@angular/core';

import 'rxjs/add/operator/map';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { CoreSession } from '../../core/core.session';
import { ResponseModel } from '../../shared/models/api-models/api-models';
import { WarehouseTransaction } from '../../shared/models/warehouse-transactions/warehouse-transaction.model';
@Injectable({
  providedIn: 'root'
})
export class RecallService {

  httpOptions;
  private url = '';
  constructor(private http: HttpClient,
    @Inject('BASE_URL') baseUrl: string,
    private coreSession: CoreSession) {
    this.url = baseUrl + 'Recall';
    this.httpOptions = {
      headers: new HttpHeaders({
        'Content-Type': 'application/json'
      })
    };
  }
  getRecallStatuses() {
    const urlValue: string = this.url + '/GetRecallStatusList';
    return this.http.get<ResponseModel>(urlValue).map(response => {
      return response.data;
    });
  }
  getRecallMisMatchReasonList() {
    const urlValue: string = this.url + '/GetRecallMisMatchReasonList';
    return this.http.get<ResponseModel>(urlValue).map(response => {
      return response.data;
    });
  }
  getAllPartyList() {
    const urlValue: string = this.url + '/GetAllPartyList';
    return this.http.get<ResponseModel>(urlValue).map(response => {
      return response.data;
    });
  }
  getFilteredItems(filter: any) {
    const urlValue: string = this.url + '/GetFilteredItems';
    return this.http.post(urlValue, JSON.stringify(filter), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  saveRecallTask(recallObject: any) {
    const urlValue: string = this.url + '/InsertRecallTask';
    return this.http.post(urlValue, JSON.stringify(recallObject), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  getRecallListSharedTable(filter: any) {
    const urlValue: string = this.url + '/GetRecallListSharedTable';
    return this.http.post(urlValue, JSON.stringify(filter), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  getRecallData(recall) {
    const urlValue = this.url + '/GetRecallData';
    return this.http
      .post<ResponseModel>(urlValue, recall)
      .map(response => {
        return response;
      });
  }
  updateRecallTaskStatus(recall) {
    const urlValue: string = this.url + '/UpdateRecallTaskStatus';
    return this.http.post(urlValue, recall).map(
      (response) => {
        let result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  prepareApproveConfirmation(recall) {
    const urlValue: string = this.url + '/PrepareToConfirmConfirmation';
    return this.http.post(urlValue, recall).map(
      (response) => {
        let result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  approveRecallTask(recall) {
    const urlValue: string = this.url + '/ApproveRecallTask';
    return this.http.post(urlValue, recall).map(
      (response) => {
        let result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  closeRecallTask(recallObject) {
    const urlValue: string = this.url + '/CloseRecallTask';
    return this.http.post(urlValue, JSON.stringify(recallObject), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  checkIfAllRecallSubTasksExecuted(recall) {
    const urlValue: string = this.url + '/CheckIfAllRecallSubTasksCompleted';
    return this.http.post(urlValue, recall).map(
      (response) => {
        let result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }

  // getRecallTasksList() {
  //   const urlValue: string = this.url + '/GetRecallTasksList';
  //   return this.http.get<ResponseModel>(urlValue).map(response => {
  //     return response.data;
  //   });
  // }
  // getRecallSubListSharedTable(filter: any) {
  //   const urlValue: string = this.url + '/GetRecallSubListSharedTable';
  //   return this.http.post(urlValue, JSON.stringify(filter), this.httpOptions).map(
  //     (response) => {
  //       const result = new ResponseModel();
  //       result.data = response['data'];
  //       result.message = response['message'];
  //       result.status = response['status'];
  //       return result;
  //     }
  //   );
  // }
  // getRecallSubTaskDataToExecute(subTask: any) {
  //   const urlValue: string = this.url + '/GetRecallSubTaskDataToExecute';
  //   return this.http.post(urlValue, JSON.stringify(subTask), this.httpOptions).map(
  //     (response) => {
  //       const result = new ResponseModel();
  //       result.data = response['data'];
  //       result.message = response['message'];
  //       result.status = response['status'];
  //       return result;
  //     }
  //   );
  // }
  // executeWHRecallSubTask(warehouseTransaction: WarehouseTransaction) {
  //   const urlValue: string = this.url + '/ExecuteWHRecallSubTask';
  //   return this.http
  //     .post<ResponseModel>(urlValue, warehouseTransaction)
  //     .map(response => {
  //       const res = new ResponseModel();
  //       res.data = response['data'];
  //       res.message = response['message'];
  //       res.status = response['status'];
  //       return res;
  //     });
  // }
  // dispatchRecallOrder(order: any) {
  //   const urlValue = this.url + "/DispatchRecallOrder";
  //   return this.http.post<ResponseModel>(urlValue, order).map(response => {
  //     return response;
  //   });
  // }

  // getIncidentListSharedTable(filter: any) {
  //   const urlValue: string = this.url + '/GetIncidentListSharedTable';
  //   return this.http.post(urlValue, JSON.stringify(filter), this.httpOptions).map(
  //     (response) => {
  //       const result = new ResponseModel();
  //       result.data = response['data'];
  //       result.message = response['message'];
  //       result.status = response['status'];
  //       return result;
  //     }
  //   );
  // }

  // saveIncident(incidentObj: any) {
  //   const urlValue: string = this.url + '/SaveIncident';
  //   return this.http.post(urlValue, JSON.stringify(incidentObj), this.httpOptions).map(
  //     (response) => {
  //       const result = new ResponseModel();
  //       result.data = response['data'];
  //       result.message = response['message'];
  //       result.status = response['status'];
  //       return result;
  //     }
  //   );
  // }

  // getIncidentData(incidentId: any) {
  //   const urlValue = this.url + '/GetIncidentData';
  //   return this.http.post<ResponseModel>(urlValue, incidentId).map(response => {
  //     const res = new ResponseModel();
  //     res.data = response["data"];
  //     res.message = response["message"];
  //     res.status = response["status"];
  //     return res;
  //   });
  // }

  // updateIncidentStatus(incident) {
  //   const urlValue: string = this.url + '/UpdateIncidentStatus';
  //   return this.http.post(urlValue, incident).map(
  //     (response) => {
  //       let result = new ResponseModel();
  //       result.data = response['data'];
  //       result.message = response['message'];
  //       result.status = response['status'];
  //       return result;
  //     }
  //   );
  // }

}
