import { Component, OnInit, ViewChild } from '@angular/core';
import { SharedTableResult } from '../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../shared/models/shared-table/table-properties.interface';
import { CoreSession } from '../../../core/core.session';
import { RowOperation } from '../../../shared/models/enums/shared-table-operation.enum';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { SerialsService } from '../../../shared/components/Serials/serials.service';
import { DialogMode } from '../../../shared/models/enums/dialog-mode.enum';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { DateTimeModel } from '../../../shared/models/dateTimeModel/date-time.model';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../shared/models/constants/constant-configuration';
import { DatePipe } from '@angular/common';
import { IDateTimePickerProperties } from '../../../shared/models/dateTimeModel/date-time-properties.interface';
import { HttpErrorResponse } from '@angular/common/http';
import { SerialOperationService } from '../../serial-operation/serial-operation.service';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { DialogResult } from '../../../shared/models/enums/dialog-result.enum';
import { IOperationSummary } from '../../../shared/models/operation-summary/operation-summary-interface';
import { FormProcessMode } from '../../../shared/models/enums/form-process-mode.enum';
import { SSCCGenerationService } from '../../../shared/components/ssccGeneration/sscc-generation.service';
import * as cloneDeep from "lodash/cloneDeep";

@Component({
  selector: 'app-tracking-report-list',
  templateUrl: './tracking-report-list.component.html',
  styleUrls: ['./tracking-report-list.component.css'],
  providers: [DatePipe]
})
export class TrackingReportListComponent implements OnInit {
  tableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: false,
    isOnline: false,
    showSearchBtn: true,
    isMultiSelection: false,
    openFilterDirectly: false,
    rowOperations: [{
      operation: RowOperation.View,
      title: 'Desc_Serials',
      icon: 'fa fa-barcode',
      color: '#f1685e',
      showWhenKeyValueTrue: true,
      showHideOptionPerLine: true,
      controlKeyName: "hasSerialNumber"
    }],
    multiSelectionOperations: [
    ],
    columns: [
      {
        title: 'Desc_Item',
        key: 'itemCodeName',
        isSortable: false,
        width: "20%"
      },
      {
        title: 'Desc_UOM',
        key: 'uom',
        isSortable: false,
        width: "14%"
      },
      {
        title: 'Desc_BatchNo',
        key: 'batchNo',
        isSortable: false,
        width: "16%"

      },
      {
        title: 'Desc_ExpiryDate',
        key: 'expiryDate',
        isSortable: false,
        width: "16%",
        isExpiryDate: true
      },
      {
        title: 'Desc_Status',
        key: 'status',
        isSortable: false,
        width: "20%"
      },
      {
        title: 'Desc_Quantity',
        key: 'quantity',
        isSortable: false,
        width: "14%"
      }
    ]
  };
  historyTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: false,
    isOnline: true,
    showSearchBtn: true,
    isMultiSelection: false,
    openFilterDirectly: false,
    rowOperations: [],
    multiSelectionOperations: [
    ],
    columns: [
      {
        title: 'Desc_Date',
        key: 'date',
        isSortable: false,
        isDate: true
      },
      {
        title: 'Desc_Status',
        key: 'status',
        isSortable: false,

      },
      {
        title: 'Desc_Transaction_ID',
        key: 'transactionID',
        isSortable: false,
      },
      {
        title: 'Desc_Warehouse_Vehicle_Code_Name',
        key: 'warehouseVehicleCodeName',
        isSortable: false,
      },

      {
        title: 'Desc_Employee',
        key: 'employeeCodeName',
        isSortable: false,
      },
      {
        title: 'Desc_Outlet',
        key: 'outletCodeName',
        isSortable: false,
      },
      {
        title: 'Desc_Organization',
        key: 'organizationCodeName',
        isSortable: false,
      },
      {
        title: 'Desc_Item',
        key: 'itemCodeName',
        isSortable: false,
      },
      // {
      //   title: 'Desc_TransactionType',
      //   key: 'transactionTypeName',
      //   isSortable: false,
      //   width: "12%"
      // },
    ]
  };
  ssccHistoryTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: false,
    isOnline: true,
    showSearchBtn: true,
    isMultiSelection: false,
    openFilterDirectly: false,
    rowOperations: [{
      operation: RowOperation.View,
      title: 'Desc_View',
      icon: 'fa fa-eye',
      color: '#12344d',
    }],
    multiSelectionOperations: [
    ],
    columns: [
    ]
  };
  ShowSerialTrackingHistory = false;
  isSSCCBarcode = false;
  isParentSSCCBarcode = false;
  itemsFilter = {
    BySerial: 1,
    ByBatch: 2
  }
  isFilterOpend = true;
  DescActivated = '';
  batchNo: string = '';
  expiryDate: DateTimeModel = null;
  filterBy = 1;
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  trackingHistoryDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  expiryDateProperties: IDateTimePickerProperties = {
    label: 'Desc_ExpiryDate',
    formControlName: 'expiryDate',
    isCalendarOnly: true

  };
  onOpenFilter() {
    this.isFilterOpend = true;
  }
  onCloseFilter() {
    this.isFilterOpend = false;
  }
  selectedSerial: any = {
    fromSerial: '---',
    itemName: '---',
    itemCode: '---',
    details: {
      serialStatus: '---',
      salesmanName: '---',
      salesmanCode: '---',
      organizationName: '---',
      organizationCode: '---',
      warehouseName: '---',
      warehouseCode: '---',
      vehicleName: '---',
      vehicleCode: '---',
      customerName: '---',
      customerCode: '---',
      invoiceNumber: '---',
      invoiceDate: '---',
      expiryDate: null,
      batchNo: '---',
      ssccBarcode: '---',
    },
  };

  dataSourceSerials: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  sharedTabelDataForSerials: ITableProperties = {
    pageSize: 10,
    showPaginator: true,
    isOnline: false,
    showSearch: false,
    showEditButton: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Serial_No', key: 'fromSerial', isSortable: false, width: '50%' },
      { title: 'Desc_Transaction_ID', key: 'transactionId', isSortable: false, width: '50%' },
    ]
  };
  serialStatus = '---';
  organizationName = '---';
  organizationCode = '---';
  itemCode = '---';
  itemName = '---';
  @ViewChild('serialsDialog', { static: true }) serialsDialog: NgbModal;
  viewSSCCDetailsSummary = false;
  operationSummaryData: IOperationSummary = {
    operationData: {},
    formProcessMode: FormProcessMode.SSCCFromMainList,
    formTitle: "",
  };
  ssccObject: any = {};
  // selectedItemSerial :string = '';
  constructor(private coreSession: CoreSession,
    private serialsService: SerialsService,
    private translate: TranslateService,
    public sessionData: SessionDataProvider,
    private datepipe: DatePipe,
    private serialOperationService: SerialOperationService,
    private modalService: NgbModal,
    private ssccGeneratingService: SSCCGenerationService

  ) { }

  ngOnInit() {
    this.DescActivated = this.translate.instant(ConstantMessages.Desc_Activated);
    this.initFilterForm();
    this.initConfigurations();

  }
  initConfigurations() {
    this.ShowSerialTrackingHistory = this.sessionData
      .getConfigurationValue(ConstantConfigurations.ShowSerialTrackingHistory)
      .toLowerCase() === 'true';
  }
  initFilterForm() {
    this.filterForm = new FormGroup({
      filterBy: new FormControl(this.itemsFilter.BySerial, Validators.required),
      itemSerial: new FormControl(null, Validators.required),
      batchNo: new FormControl(null),
      expiryDate: new FormControl(null),
    });
  }
  filterForm: FormGroup = new FormGroup({});

  setTableColumns() {
    this.ssccHistoryTableData.columns = [
      {
        title: 'Desc_Date',
        key: 'date',
        isSortable: false,
        isDate: true
      },
      {
        title: 'Desc_Status',
        key: 'status',
        isSortable: false,

      },
      {
        title: 'Desc_Transaction_ID',
        key: 'transactionID',
        isSortable: false,
      },
      {
        title: 'Desc_Warehouse_Vehicle_Code_Name',
        key: 'warehouseVehicleCodeName',
        isSortable: false,
      },

      {
        title: 'Desc_Employee',
        key: 'employeeCodeName',
        isSortable: false,
      },
      {
        title: 'Desc_Outlet',
        key: 'outletCodeName',
        isSortable: false,
      },
      {
        title: 'Desc_Organization',
        key: 'organizationCodeName',
        isSortable: false,
      },
    ];
  }
  onRowClicked(event: any) {
    switch (event.operation) {
      case RowOperation.View:
        if (this.isSSCCBarcode) {
          this.viewSSCC(event.object.ssccBarcode);
        }
        else
          this.fillSerialsAndOpenDialog(event.object);
        break;
    }
  }
  populateTrackingReportData(filter: any) {
    this.isSSCCBarcode = false;
    this.isParentSSCCBarcode = false;
    this.setTableColumns();
    this.coreSession.ModalLoading.Show();
    this.serialsService.getTrackingReportData(filter).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (response.data && response.data.length > 0) {
            if (filter.filterByBatch) {
              this.dataSource = {
                data: response.data,
                totalItems: response.data.length
              }
            } else {
              this.selectedSerial = response.data[0];
              if (this.selectedSerial.isSSCCBarcode) {
                this.isSSCCBarcode = true;
                filter.ssccBarcode = this.selectedSerial.ssccBarcode;
                filter.parentSSCCBarcode = this.selectedSerial.parentSSCCBarcode;
                filter.itemSerial = '';
                if (this.selectedSerial.isParentSSCCBarcode) {
                  this.isParentSSCCBarcode = true;
                  filter.isParentSSCCBarcode = true;
                  this.ssccHistoryTableData.columns.push({
                    title: "Desc_SSCC",
                    key: "ssccBarcode",
                    isSortable: false
                  });
                }
              }
              if (ConstantConfigurations.ShowSerialTrackingHistory) {
                this.populateTrackingHistoryData(filter);
              }
            }
          }
          else {
            this.coreSession.showWarrning(this.translate.instant(ConstantMessages.WarningCaption), this.translate.instant(ConstantMessages.MsgNoDataFound));
            this.dataSource = {
              data: [],
              totalItems: 0
            }
            this.trackingHistoryDataSource = {
              data: [],
              totalItems: 0
            }
            this.selectedSerial = {
              fromSerial: '',
              itemName: '',
              itemCode: '',
              details: {},
            };
          }
        } else {
          this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      error => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), this.translate.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  onReset() {
    this.selectedSerial = {
      fromSerial: '---',
      itemName: '---',
      itemCode: '---',
      details: {
        serialStatus: '---',
        salesmanName: '---',
        salesmanCode: '---',
        organizationName: '---',
        organizationCode: '---',
        warehouseName: '---',
        warehouseCode: '---',
        vehicleName: '---',
        vehicleCode: '---',
        customerName: '---',
        customerCode: '---',
        invoiceNumber: '---',
        invoiceDate: '---',
        expiryDate: null,
        batchNo: '---',
        ssccBarcode: '---',
      },
    };
    this.dataSource = {
      data: [],
      totalItems: 0
    };
    this.trackingHistoryDataSource = {
      data: [],
      totalItems: 0
    }
    this.batchNo = '';
    this.expiryDate = null;
    this.filterForm.get('batchNo').setValue("");
    this.filterForm.get('expiryDate').setValue("");
    this.filterForm.get('itemSerial').setValue("");
  }
  populateTrackingHistoryData(filter: any) {
    this.coreSession.ModalLoading.Show();
    this.serialsService.getSerialTrackingHistory(filter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        if (response.data && response.data.length > 0) {
          this.trackingHistoryDataSource = {
            data: response.data,
            totalItems: response.data.length
          }

          var lastRow = response.data[response.data.length - 1];
          if (lastRow) {
            this.serialStatus = lastRow.status;
            this.organizationCode = lastRow.organizationCodeName.split('-')[0].trim();
            this.organizationName = lastRow.organizationCodeName.split('-')[1].trim();
            let itemData = lastRow.itemCodeName.split('-');
            if (itemData.length > 2) {
              this.itemName = itemData[1].trim() + itemData[2].trim();
            } else {
              this.itemName = itemData[1].trim();
            }
            this.itemCode = itemData[0].trim();

          }
        }
        else {
          this.coreSession.showWarrning(this.translate.instant(ConstantMessages.WarningCaption), this.translate.instant(ConstantMessages.MsgNoDataFound));
          this.trackingHistoryDataSource = {
            data: [],
            totalItems: 0
          }
        }
      } else {
        this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), this.translate.instant(ConstantMessages.ErrorHappened));
    });
  }
  onFind() {
    // if (this.filterForm.value.itemSerial != null) {
    //   this.selectedItemSerial = this.filterForm.value.itemSerial;
    // } else {
    //   this.selectedItemSerial = "";
    // }
    var filter = {
      itemSerial: this.filterForm.get('itemSerial').value,
      ssccBarcode: '',
      parentSSCCBarcode: '',
      isParentSSCCBarcode: false,
      batchNo: this.filterForm.get('batchNo').value,
      expiryDateModel: this.expiryDate,
      filterByBatch: this.filterForm.get('filterBy').value == this.itemsFilter.ByBatch ? true : false
    }
    if (filter.filterByBatch) {
      this.filterForm.get('batchNo').markAllAsTouched();
      this.filterForm.get('expiryDate').markAllAsTouched();
      if ((this.filterForm.get('batchNo').value == null || this.filterForm.get('batchNo').value == "")
        && (this.filterForm.get('expiryDate').value == null || this.filterForm.get('expiryDate').value == "")) {
        this.coreSession.showWarrning(this.translate.instant(ConstantMessages.WarningCaption), this.translate.instant(ConstantMessages.MsgFillBatchOrExpiry));
        return false;
      }
    }
    else {
      this.filterForm.get('itemSerial').markAllAsTouched();
      if (this.filterForm.get('itemSerial').invalid) {
        this.coreSession.showWarrning(this.translate.instant(ConstantMessages.WarningCaption), this.translate.instant(ConstantMessages.MsgFillMandatory));
        return false;
      }
    }
    this.populateTrackingReportData(filter);
  }
  onExpiryDateSelected(date) {
    this.batchNo = null;
    this.expiryDate = date;
    let batchNoFormat = this.sessionData.getConfigurationValue(ConstantConfigurations.BatchNumberFormat);
    if (batchNoFormat && batchNoFormat != '' && batchNoFormat != "No Format" && batchNoFormat != "NoFormat") {
      this.batchNo = this.datepipe.transform(this.expiryDate.date, batchNoFormat);
    }
    else {
      this.batchNo = this.datepipe.transform(this.expiryDate.date, this.coreSession.BatchNoFormat);
    }
    this.filterForm.get('batchNo').setValue(this.batchNo);
  }
  onChangeBatch(batch: any) {
    if (batch) {
      this.batchNo = this.filterForm.get('batchNo').value;
    }
  }
  onEnterClicked() {
    this.onFind();
  }
  viewSSCC(ssccBarcode) {
    this.getSSCCDetails(ssccBarcode);
  }

  getSSCCDetails(ssccBarcode: string) {
    this.coreSession.ModalLoading.Show();
    this.ssccGeneratingService.GetAllSSCCDetails(ssccBarcode).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.ssccObject = response.data;
          this.operationSummaryData = {
            operationData: this.ssccObject,
            formProcessMode: FormProcessMode.SSCCFromMainList,
            formTitle: "Desc_SSCC_Details",
          };
          this.viewSSCCDetailsSummary = true;
        } else {
          this.coreSession.showWarrning(this.translate.instant(ConstantMessages.WarningCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), this.translate.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  closeViewSummarySlider() {
    this.operationSummaryData = null;
    this.ssccObject = null;
    this.viewSSCCDetailsSummary = false;
  }
  fillSerialsAndOpenDialog(itemObj: any) {
    var filter =
    {
      packId: itemObj.packId,
      expiryDateModel: itemObj.expiryDateModel,
      filterByBatch: true,
      batchNo: itemObj.batchNo,
      itemSerial: '',
      customerId: itemObj.customerId,
      outletId: itemObj.outletId,
      warehouseId: itemObj.warehouseId

    }
    this.coreSession.ModalLoading.Show();
    this.serialOperationService.getSerialsForLocationItem(filter).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        if (response.data && response.data.length > 0) {
          this.coreSession.ModalLoading.Hide();
          this.dataSourceSerials = { data: response.data, totalItems: response.data.length };
          return this.modalService.open(this.serialsDialog, { centered: true, scrollable: true }).result.then(
            (result) => {
              if (result === DialogResult.Ok) {
                return this.serialsDialog;
              } else {
                return -1;
              }
            });
        } else {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showWarrning(this.translate.instant(ConstantMessages.WarningCaption), this.translate.instant(ConstantMessages.MsgNoSerials));
        }
      } else {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
      error => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), this.translate.instant(ConstantMessages.ErrorHappened));
      })

  }
}
