import { Component, OnInit, OnChanges, Input, Output, EventEmitter, OnDestroy, ViewChild } from '@angular/core';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { HttpErrorResponse } from '@angular/common/http';
import { CoreSession } from '../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { IDateTimePickerProperties } from '../../../shared/models/dateTimeModel/date-time-properties.interface';
import { DynamicReportService } from './dynamic-report.service';
import { ReportFilterTypes } from '../../../shared/models/enums/dynamic-report.enum';
import { NgbModal, NgbModalConfig, NgbModalRef } from '@ng-bootstrap/ng-bootstrap';
import { SendEmailService } from '../../admin-settings/email/send-email.service';
import { SharedTableResult } from '../../../shared/models/shared-table/shared-table-result.interface';
import { ResponseModel } from '../../../shared/models/api-models/api-models';
import { ITableProperties } from '../../../shared/models/shared-table/table-properties.interface';
import { RowOperation } from '../../../shared/models/enums/shared-table-operation.enum';
import { DialogResult } from '../../../shared/models/enums/dialog-result.enum';
import { DialogMode } from '../../../shared/models/enums/dialog-mode.enum';


@Component({
  selector: 'app-dynamic-report',
  templateUrl: './dynamic-report.component.html',
  styleUrls: ['./dynamic-report.component.css']
})
export class DynamicReportComponent implements OnInit, OnDestroy {

  entryFormGroup: FormGroup;
  isLoading = false;
  controlsList = [];
  hasCustomization: string;
  data: string = '';

  @Input() reportId = -1;
  @Input() reportName = '';
  @Input() gridReportURL = '';

  reportModel: any = {
    reportId: -1,
    reportName: '',
    reportFilters: [],
    fileName: '',
    scheduleId: -1,
  };
  //#region [Report Schedule Defintions]
  @ViewChild("ReportScheduleDialog", { static: true })
  ReportScheduleDialog: NgbModal;
  @ViewChild("ReportScheduleView", { static: true })
  ReportScheduleView: NgbModal;
  @ViewChild("ReportScheduleTable", { static: true })
  ReportScheduleTable: NgbModal;
  modalRef: NgbModalRef;
  modalRefTable: NgbModalRef;
  reportScheduleForm: FormGroup;
  ReportScheduleList: any[] = [];
  tableData: ITableProperties = {
    pageSize: 25,
    showPaginator: false,
    showSearch: false,
    isOnline: true,
    rowOperations: [
      {
        operation: RowOperation.View,
        title: 'Desc_View',
        icon: "fa-regular fa-eye",
        color: '#12344d',
      },
      {
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e'
      }
    ],
    multiSelectionOperations: [],
    columns: [
      {
        title: 'Report_Schedule_Name',
        key: 'reportScheduleDescription',
        isSortable: true,
        width: '50%'
      },
      {
        title: 'Desc_Period_Type',
        key: 'periodTypeDescription',
        isSortable: true,
        width: '50%'
      },
    ]
  };

  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  headerFilters: any;
  isReportHasNoSchedules: boolean = true;
  reportScheduleFilters: any;
  //#region
  constructor(
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private dynamicReportService: DynamicReportService,
    private config: NgbModalConfig,
    private modalService: NgbModal,
    private sendemail: SendEmailService,
  ) { }
  ngOnInit() {

    this.entryFormGroup = new FormGroup({});
    this.getReportFilters();
    this.populateScheduledReports();
  }
  initForm() {
    this.controlsList.forEach((control) => {

      control.disabled = false;
      if (control.isDateFilter || control.isDateTimeFilter) {
        var dateProperties: IDateTimePickerProperties = {
          label: control.description,
          formControlName: control.formControlName,
          isCalendarOnly: control.isDateFilter, // date only without time section
          dateValue: new Date(),
        };
        control.dateProperties = dateProperties;
        control.selectedDateModelValue = new Date();
      }
      var selectedValue = null;
      if (control.isDateFilter || control.isDateTimeFilter) {
        selectedValue = control.selectedDateModelValue.date;
      } else if (control.reportFilterTypeId === ReportFilterTypes.Lookup || control.reportFilterTypeId === ReportFilterTypes.LookUp_WithoutAll) {
        selectedValue = control.selectedValue;
      }

      this.entryFormGroup.addControl(control.formControlName,
        new FormControl({ value: selectedValue, disabled: false }, Validators.required));

    });
    this.reportScheduleForm = new FormGroup({
      scheduleId: new FormControl(null, Validators.required),
    });
  }
  ngOnDestroy() {
  }
  getReportFilters() {
    this.coreSession.ModalLoading.Show();
    this.dynamicReportService.getReportFilters(this.reportId).subscribe(
      (response) => {
        this.isLoading = true;
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.controlsList = response.data;
          this.hasCustomization = response.data[0].fileName;
          this.initForm();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.isLoading = true;
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  getChildFilterData(childControl) {
    this.coreSession.ModalLoading.Show();
    this.dynamicReportService.getChildFilterData(childControl).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          childControl.filterData = response.data;
          if (childControl.filterData && childControl.filterData.length > 0) {
            this.entryFormGroup.get(childControl.formControlName).setValue(childControl.filterData[0].bindValue);
            this.entryFormGroup.get(childControl.formControlName).updateValueAndValidity();
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  checkIfParentDisable(control) {
    var index = this.controlsList.findIndex(x => x.filterIndex === control.parentFilterIndex);
    if (index >= 0) {
      return this.controlsList[index].disabled;
    }
    return false;
  }
  onChangeDate(selectedControl, event) {
    selectedControl.selectedDateModelValue = event;
  }
  onChangeEnableStatus(selectedControl) {
    var isDisable = !selectedControl.disabled;
    if (isDisable) {
      selectedControl.disabled = true;
      this.entryFormGroup.get(selectedControl.formControlName).setValidators(Validators.nullValidator);
      this.entryFormGroup.get(selectedControl.formControlName).disable();
    } else {
      selectedControl.disabled = false;
      this.entryFormGroup.get(selectedControl.formControlName).enable();
      this.entryFormGroup.get(selectedControl.formControlName).setValidators(Validators.required);
    }
    this.entryFormGroup.get(selectedControl.formControlName).setValue(null);
    this.entryFormGroup.get(selectedControl.formControlName).updateValueAndValidity();

    // reflect child filters data and check all
    if (selectedControl.reportFilterTypeId === ReportFilterTypes.Lookup) {
      var index = this.controlsList.findIndex(x => x.reportFilterTypeId === ReportFilterTypes.Lookup && x.parentFilterIndex == selectedControl.filterIndex);
      if (index != -1) {
        this.onChangeEnableStatusForChild(this.controlsList[index], selectedControl);
      }
    }
  }
  onChangeEnableStatusForChild(childControl, parentControl) {
    //if (parentControl.disabled) {
    //  childControl.disabled = true;
    //  this.entryFormGroup.get(childControl.formControlName).setValidators(Validators.nullValidator);
    //  this.entryFormGroup.get(childControl.formControlName).disable();
    //} else {
    //  childControl.disabled = false;
    //  this.entryFormGroup.get(childControl.formControlName).enable();
    //  this.entryFormGroup.get(childControl.formControlName).setValidators(Validators.required);
    //}
    this.entryFormGroup.get(childControl.formControlName).setValue(null);
    this.entryFormGroup.get(childControl.formControlName).enable();
    this.entryFormGroup.get(childControl.formControlName).setValidators(Validators.required);

    if (parentControl.disabled) {
      // childControl.filterData //bana call method for fill child data source here[getChildFilterData]
    }
    // childControl.filterData = []; bana call method for fill child data source here [getChildFilterData]

    this.entryFormGroup.get(childControl.formControlName).updateValueAndValidity();
  }
  onChangeComboSelection(selectedControl) {
    var index = this.controlsList.findIndex(x => x.parentFilterIndex == selectedControl.filterIndex);
    if (index != -1) {
      var childControl = this.controlsList[index];
      if (childControl) {

        childControl.parentFilterValue = -1;
        childControl.filterData = [];
        this.entryFormGroup.get(childControl.formControlName).setValue(null);
        this.entryFormGroup.get(childControl.formControlName).updateValueAndValidity();

        if (!selectedControl.disabled) {
          var parentValue = this.entryFormGroup.get(selectedControl.formControlName).value;
          if (parentValue && parentValue != '' && parentValue != '-1' && parentValue != -1) {

            // set child as enabled when change value for parent filter
            childControl.disabled = false;
            this.entryFormGroup.get(childControl.formControlName).enable();
            this.entryFormGroup.get(childControl.formControlName).setValidators(Validators.required);

            childControl.parentFilterValue = parentValue;
            // call api to fill child control data after change parent filter selection
            this.getChildFilterData(childControl);
          }
        }
      }
    }
  }

  fillreportModelObj() {
    this.controlsList.forEach(control => {

      control.selectedText = control.description;

      if (control.disabled && (control.isDateFilter || control.isDateTimeFilter)) {
        control.selectedText = '---';
        control.selectedDateModelValue = new Date();
        control.selectedDateModelValue = control.selectedDateModelValue.date;
      }
      else if (control.reportFilterTypeId == ReportFilterTypes.Lookup) {
        if (!control.disabled && this.entryFormGroup.get(control.formControlName).value) {
          var data = control.filterData.find(x => x.bindValue === this.entryFormGroup.get(control.formControlName).value)
          if (data) {
            control.selectedText = data.bindLabel;
          }
        }
        control.selectedValue = this.entryFormGroup.get(control.formControlName).value ? this.entryFormGroup.get(control.formControlName).value : '-1';
      }
      else if (control.reportFilterTypeId == ReportFilterTypes.LookUp_WithoutAll) {
        if (control.disabled) {
          control.selectedValue = '-1';
        } else {
          if (!control.disabled && this.entryFormGroup.get(control.formControlName).value) {
            var data = control.filterData.find(x => x.bindValue === this.entryFormGroup.get(control.formControlName).value)
            if (data) {
              control.selectedText = data.bindLabel;
            }
          }
          control.selectedValue = this.entryFormGroup.get(control.formControlName).value ? this.entryFormGroup.get(control.formControlName).value : '-1';
        }
      } else if (control.reportFilterTypeId == ReportFilterTypes.Text) {
        control.selectedText = '---';
        if (!control.disabled && this.entryFormGroup.get(control.formControlName).value) {
          control.selectedText = this.entryFormGroup.get(control.formControlName).value;
        }
        control.selectedValue = this.entryFormGroup.get(control.formControlName).value ? this.entryFormGroup.get(control.formControlName).value : '';
      }
    });

    this.reportModel.reportId = this.reportId;
    this.reportModel.reportName = this.reportName;
    this.reportModel.reportFilters = this.controlsList;
    this.reportModel.fileName = this.hasCustomization;
    this.reportModel.scheduleId = this.reportScheduleForm.get('scheduleId').value !== null ? this.reportScheduleForm.get('scheduleId').value : -1;
  }

  showData(hasCustomization, isDownLoad?) {
    this.coreSession.markFormGroupTouched(this.entryFormGroup);
    if (this.entryFormGroup.invalid) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }

    this.fillreportModelObj();

    if (hasCustomization) {
      if (this.reportModel.fileName == "POSStockCountingMatrixReport") {
        this.dynamicReportService.ExportExcelFromGrid(this.reportModel, isDownLoad);
      } else {
        this.dynamicReportService.ExportReportFromGrid(this.reportModel, isDownLoad);
      }
    } else {
      this.coreSession.ModalLoading.Show();
      this.dynamicReportService.showReportData(this.reportModel).subscribe(
        (response) => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            let urlll = this.gridReportURL + response.data;
            window.open(urlll, "_blank");
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
    }
  }
  GetReportSchedule() {
    this.coreSession.ModalLoading.Show();
    this.dynamicReportService.GetReportSchedule().subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.ReportScheduleList = response.data;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  showReportScheduleDialog() {
    this.coreSession.markFormGroupTouched(this.entryFormGroup);
    if (this.entryFormGroup.invalid) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
    this.GetReportSchedule();
    this.config.backdrop = "static";
    this.modalRef = this.modalService.open(this.ReportScheduleDialog, {
      centered: true,
    });
    this.config.backdrop = true;
  }

  showReportScheduleView(scheduleId, reportScheduleAssignmentId) {
    this.GetReportScheduleFilter(scheduleId, reportScheduleAssignmentId)
    this.config.backdrop = "static";
    this.modalRef = this.modalService.open(this.ReportScheduleView, {
      centered: true,
    });
    this.config.backdrop = true;
  }
  showReportScheduleTable() {
    this.config.backdrop = "static";
    this.modalRefTable = this.modalService.open(this.ReportScheduleTable, {
      centered: true,
      size: 'lg',
    });
    this.config.backdrop = true;
  }
  OnShowTable() {
    this.showReportScheduleTable();
  }

  GetReportScheduleFilter(scheduleId, reportScheduleAssignmentId) {
    this.coreSession.ModalLoading.Show();
    this.dynamicReportService.GetReportScheduleFilter(scheduleId, reportScheduleAssignmentId).subscribe((response) => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.headerFilters = response.data;
        this.headerFilters = JSON.parse(this.headerFilters);
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  onCancelingReportSchedule() {
    this.modalRef.dismiss();
    this.reportScheduleForm.get("scheduleId").reset();
  }

  onContinuingReportSchedule() {
    this.fillreportModelObj();
    this.onCancelingReportSchedule();
    this.SaveReportScheduleData();
  }

  SaveReportScheduleData() {
    let matchingScheduleFilter = null;
    for (const uniqueAssignmentID of [...new Set(this.reportScheduleFilters.map(filter => filter.reportScheduleAssignmentId))]) {
      const filtersForAssignment = this.reportScheduleFilters.filter(filter => filter.reportScheduleAssignmentId === uniqueAssignmentID);
      let matchCount = 0;
      for (const scheduleFilter of filtersForAssignment) {
        for (const control of this.controlsList) {
          const selectedValue = control.selectedValue === null ? "" : control.selectedValue;
          if (
            scheduleFilter.reportId === control.reportId &&
            scheduleFilter.scheduleId === this.reportModel.scheduleId &&
            scheduleFilter.reportFilterId === control.reportFilterId &&
            scheduleFilter.reportParameterId === control.reportParameterId &&
            scheduleFilter.selectedValue === selectedValue
          ) {
            matchCount++;
          }
        }

        if (matchCount === this.controlsList.length) {
          matchingScheduleFilter = scheduleFilter;
          break;
        }
      }
    }
    // Check if a matching scheduleFilter was found
    if (matchingScheduleFilter) {
      return this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgThisReportScheduleAlreadyExist));
    } else if (this.reportModel.scheduleId === null || this.reportModel.scheduleId <= 0) {
      return this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgInsertReportSchedule));
    }
    this.coreSession.ModalLoading.Show();
    this.dynamicReportService.SaveReportScheduleData(this.reportModel).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), response.message);
          this.populateScheduledReports();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  //#endregion [Report Schedule Methods]
  populateScheduledReports() {
    this.coreSession.ModalLoading.Show();
    this.dynamicReportService.PopulateScheduledReports(this.reportId).subscribe(
      (response: ResponseModel) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.dataSource = {
            totalItems: response.data,
            data: response.data.data
          };
          this.reportScheduleFilters = response.data.filters;
          if (this.dataSource != null && this.dataSource.data.length > 0) {
            this.isReportHasNoSchedules = false
          }
        } else {
          this.dataSource = {
            totalItems: 0,
            data: []
          };
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  onRowClicked(event: any) {
    switch (event.operation) {
      case RowOperation.View:
        this.showReportScheduleView(event.object.scheduleId, event.object.reportScheduleAssignmentId);
        break;
      case RowOperation.delete:
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption))
          .then(
            (result: DialogResult) => {
              if (result === DialogResult.Yes) {
                this.deleteReportSchedule(event.object.scheduleId, event.object.reportScheduleAssignmentId);
              }
            });
        break;
    }
  }

  deleteReportSchedule(scheduleId, reportScheduleAssignmentId) {
    this.coreSession.ModalLoading.Show();
    this.dynamicReportService.deleteReportSchedule(scheduleId, reportScheduleAssignmentId)
      .subscribe(
        (response: ResponseModel) => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), response.message);
            this.populateScheduledReports();
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
  }

  onCancelingReportScheduleView() {
    this.modalRef.dismiss();
  }
  onClosingReportScheduleTable() {
    this.modalRefTable.dismiss();
  }
  //#region
}
