import { Injectable, Inject } from "@angular/core";
import { HttpClient } from "@angular/common/http";
import { ResponseModel } from "../../../shared/models/api-models/api-models";
import { CoreSession } from "../../../core/core.session";
import { TranslateService } from "@ngx-translate/core";
import * as FileSaver from 'file-saver';

@Injectable({
  providedIn: "root"
})
export class DynamicReportService {
  private url = "";
  constructor(private http: HttpClient, @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession,
    private translateService: TranslateService) {
    this.url = baseUrl + "DynamicReport";
  }

  getReportFilters(reportId) {
    const urlValue: string = this.url + "/GetReportFilters";
    return this.http.post<ResponseModel>(urlValue, reportId).map(
      response => {
        return response;
      });
  }
  getChildFilterData(childControl) {
    const urlValue: string = this.url + "/GetChildFilterData";
    return this.http.post<ResponseModel>(urlValue, childControl).map(
      response => {
        return response;
      });
  }
  showReportData(report: any) {
    const urlValue: string = this.url + '/ShowReportData';
    return this.http
      .post<ResponseModel>(urlValue, report)
      .map(response => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }

  markReportAsFavorite(reportId: number) {
    const urlValue: string = this.url + '/MarkReportAsFavorite';
    return this.http
      .post<ResponseModel>(urlValue, reportId)
      .map(response => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }

  unmarkReportAsFavorite(reportId: number) {
    const urlValue: string = this.url + '/UnMarkReportAsFavorite';
    return this.http
      .post<ResponseModel>(urlValue, reportId)
      .map(response => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }

  ExportReportFromGrid(report, isDownLoad?) {
    const urlValue = this.url + "/ExportReportFromGrid";
    this.coreSession.ModalLoading.Show();
    this.http.post(urlValue, report, { responseType: "blob" }).map(res => {
      var blob = new Blob([res], { type: "application/pdf" });
      return blob;
    }).subscribe(
      success => {
        const fileURL = URL.createObjectURL(success);
        if (isDownLoad) {
          const downloadLink = document.createElement("a");
          downloadLink.href = fileURL;
          downloadLink.download = report.reportName;
          downloadLink.click();
        } else {
          const newFileURL = fileURL;
          window.open(newFileURL, "_blank");
        }
        this.coreSession.ModalLoading.Hide();
      },
      err => {
        this.coreSession.ModalLoading.Hide();
      }
    );
  }
  ExportExcelFromGrid(report, isDownLoad?) {
    const urlValue = this.url + "/ExportExcelFromGrid";
    this.coreSession.ModalLoading.Show();
    this.http.post(urlValue, report, { responseType: "blob" }).map(res => {
      var blob = new Blob([res], { type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" });
      return blob;
    }).subscribe(
      success => {
        const fileURL = URL.createObjectURL(success);
        if (isDownLoad) {
          const downloadLink = document.createElement("a");
          downloadLink.href = fileURL;
          downloadLink.download = report.reportName;
          downloadLink.click();
        } else {
          const newFileURL = fileURL;
          window.open(newFileURL, "_blank");
        }
        this.coreSession.ModalLoading.Hide();
      },
      err => {
        this.coreSession.ModalLoading.Hide();
      }
    );
  }

  GetReportSchedule() {
    const urlValue: string = this.url + "/GetReportSchedules";
    return this.http.post<ResponseModel>(urlValue, "").map(
      response => {
        return response;
      });
  }

  SaveReportScheduleData(reportModel: any) {
    const urlValue = this.url + "/SaveReportScheduleData";
    return this.http
      .post<ResponseModel>(urlValue, reportModel)
      .map(response => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }

  PopulateScheduledReports(reportId: number) {
    const urlValue: string = this.url + "/PopulateScheduledReports";
    return this.http.post<ResponseModel>(urlValue, reportId).map(
      response => {
        return response;
      });
  }
  GetReportScheduleFilter(scheduleId: number, reportScheduleAssignmentId: number) {
    const reportSchedule = {
      scheduleId: scheduleId,
      reportScheduleAssignmentId: reportScheduleAssignmentId
    }
    const urlValue: string = this.url + "/GetReportScheduleFilter";
    return this.http.post<ResponseModel>(urlValue, reportSchedule).map(
      response => {
        return response;
      });
  }
  deleteReportSchedule(scheduleId: number, reportScheduleAssignmentId: number) {
    const reportSchedule = {
      scheduleId: scheduleId,
      reportScheduleAssignmentId: reportScheduleAssignmentId
    }
    const urlValue = this.url + '/DeleteReportSchedule';
    return this.http
      .post<ResponseModel>(urlValue, reportSchedule)
      .map(response => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }
}
