import { HttpErrorResponse } from '@angular/common/http';
import { Component, OnInit } from '@angular/core';
import * as cloneDeep from 'lodash/cloneDeep';
import { CoreSession } from '../../../core/core.session';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { MenuModel } from '../../../shared/models/menu/menu.model';
import { DynamicReportService } from '../dynamic-report/dynamic-report.service';

@Component({
  selector: 'app-grid-reports',
  templateUrl: './grid-reports.component.html',
  styleUrls: ['./grid-reports.component.css']
})
export class GridReportsComponent implements OnInit {

  selectedReportMenu: MenuModel;
  addedMenus: MenuModel[] = [];
  appearedMenus: MenuModel[] = [];
  reportList: MenuModel[] = [];
  navLinks: any[] = [];
  parentReportName: string = '';
  indexCounter: number = 0;
  searchTextValue: string = '';
  showCollapseAll: boolean = false;
  mainMenus: MenuModel[] = [];
  mainList: MenuModel[] = [];
  reportsMenuId = '500';
  gridReportsMenuId = '500-001';
  allMenusAvailable: MenuModel[] = [];
  //#region [Favorite reports]
  favouriteMenus: MenuModel[] = [];
  expandFavorites: boolean = false;
  showFavorites: boolean = false;
  //#endregion
  constructor(private sessionDataProvider: SessionDataProvider,
    public coreSession: CoreSession,
    private dynamicReportService: DynamicReportService,
  ) { }

  ngOnInit() {
    this.addedMenus = cloneDeep(this.sessionDataProvider.allMenusAvailable.filter(x => x.parentMenuId == this.gridReportsMenuId));
    this.appearedMenus = cloneDeep(this.addedMenus);
    this.allMenusAvailable = this.sessionDataProvider.allMenusAvailable.filter(x => x.isWithInReportHierarchy && x.isAvailable && x.menuId != this.gridReportsMenuId);
    this.favouriteMenus = cloneDeep(this.sessionDataProvider.allMenusAvailable.filter(x => x.isReportFavorite));
    this.showHideFavorites();
  }



  onSideMenuClick(menu: MenuModel) {

    if (menu.isParentMenu) {
      menu.hide = !menu.hide;
      if (this.appearedMenus.filter(x => x.hide).length > 0) {
        this.showCollapseAll = true;
      } else {
        if(!this.expandFavorites)
          this.showCollapseAll = false;
      }
    } else if (menu.reportId > 0) {
      this.openReportTab(menu);
    }


  }


  paddingSize(parentMenus: MenuModel) {

    let level = parentMenus.isWebMenu && parentMenus.menuId.split('-').length - 1;
    return (level * 10);
  }

  openReportTab(menu: MenuModel) {
    this.navLinks.filter(x => x.isActive = false);
    var i = this.navLinks.findIndex(x => x.reportId == menu.reportId);
    if (i > -1) {
      this.navLinks[i].isActive = true;
    } else {
      this.indexCounter = this.indexCounter + 1;
      let newName = {
        label: menu.menuName,
        link: menu.url, // empty url there is no separated menu
        index: this.indexCounter,
        isActive: true,
        reportId: menu.reportId,
        gridReportURL: menu.gridReportURL
      };
      this.navLinks.push(newName);
      // this.openNavLink(newName.reportId);
    }


  }

  openNavLink(reportId) {
    this.navLinks.filter(x => x.isActive = false);
    var index = this.navLinks.findIndex(x => x.reportId == reportId);
    if (index > -1) {
      this.navLinks[index].isActive = true;
    }
  }

  removeNavLink(reportId) {
    var index = this.navLinks.findIndex(x => x.reportId == reportId);
    var deleteActiveMenu = false;

    if (index > -1) {
      if (this.navLinks[index].isActive)
        deleteActiveMenu = true;

      this.navLinks.splice(index, 1);

      if (this.navLinks.length > 0 && deleteActiveMenu) {
        if (index == 0)
          this.navLinks[0].isActive = true;
        else
          this.navLinks[index - 1].isActive = true;
      }
    }
  }


  applaySearchFilter() {
    this.appearedMenus = cloneDeep(this.addedMenus);
    if (this.searchTextValue == null || this.searchTextValue.trim() == '') {
      this.showHideFavorites();
      this.appearedMenus = cloneDeep(this.addedMenus);
    } else {
      this.showFavorites = false;
      this.buildSearchedMenus();

    }
  }

  buildSearchedMenus() {
    this.mainMenus = [];
    this.mainList = [];
    var splitedArr = this.searchTextValue.trim().toLowerCase().split(' ');
    if (splitedArr && splitedArr.length > 0) {

      //Get all menus isWithInReportHierarchy
      this.mainMenus = cloneDeep(this.allMenusAvailable.filter(x => !x.isParentMenu));
      for (var mainMenu of this.mainMenus) {
        //Get all Reports applied the search
        var isValidMenu = false;
        for (var subPattern of splitedArr) {
          isValidMenu = mainMenu.menuName.toLowerCase().includes(subPattern.trim());
          if (!isValidMenu) {
            break;
          }
        }
        if (isValidMenu) {
          var index = this.mainList.findIndex(x => x.menuId == mainMenu.menuId);
          if (index == -1) {
            mainMenu.hide = false;
            this.mainList.push(mainMenu);
          }
        }
      }
    }

    var filterdlist: MenuModel[] = [];
    for (let i = 0; i < this.mainList.length; i++) {
      this.findParentMenu(filterdlist, this.mainList[i]);
    }

    filterdlist = filterdlist.filter(x => x.parentMenuId == this.gridReportsMenuId);

    this.appearedMenus = cloneDeep(filterdlist);
    this.collapseUncollapseAllMenus(this.appearedMenus, false);
  }




  findParentMenu(filteredList: MenuModel[], menu: MenuModel) {
    var index = filteredList.findIndex(x => x.menuId == menu.parentMenuId);
    if (index == -1) {
      var i = this.allMenusAvailable.findIndex(y => y.menuId == menu.parentMenuId);
      if (i > 0) {
        var parentMenu = this.allMenusAvailable[i];
        parentMenu.childMenus = [];
        parentMenu.childMenus.push(menu);
        filteredList.push(parentMenu);
        this.findParentMenu(filteredList, parentMenu)
      } else {
        // for level 1
        index = filteredList.findIndex(x => x.menuId == menu.menuId);
        if (index == -1)
          filteredList.push(menu);
      }
    } else {
      filteredList[index].childMenus.push(menu);
    }
  }

  collapseUncollapseAllMenus(collapseList, hide) {
    for (let index = 0; index < collapseList.length; index++) {
      collapseList[index].hide = !hide;
      this.collapseUncollapseAllMenus(collapseList[index].childMenus, hide);
    }
    if (this.appearedMenus.filter(x => x.hide).length > 0) {
      this.showCollapseAll = true;
      this.expandFavorites = true;
    } else {
      this.showCollapseAll = false;
      this.expandFavorites = false;
    }
  }

  // findParentMenu(menu: MenuModel, isExist: boolean) {
  //   var parentMenu: MenuModel;
  //   var index = this.sessionDataProvider.allMenusAvailable.findIndex(x => x.menuId == menu.parentMenuId);
  //   if (index > -1) {
  //     parentMenu = cloneDeep(this.sessionDataProvider.allMenusAvailable[index]);
  //     if (!isExist) {
  //       parentMenu.childMenus = [];
  //       parentMenu.childMenus.push(menu);
  //     } 
  //     if (parentMenu.menuId != this.gridReportsMenuId) {
  //       menu = this.findParentMenu(parentMenu, isExist)
  //     }
  //   }
  //   return menu;
  // }

  // findParentMenuId(menuId: string) {
  //   var parentMenuId = '';
  //   var index = this.allMenusAvailable.findIndex(x => x.menuId == menuId);
  //   if (index > -1) {
  //     parentMenuId = cloneDeep(this.allMenusAvailable[index].parentMenuId);
  //     if (parentMenuId != this.gridReportsMenuId) {
  //       menuId = this.findParentMenuId(parentMenuId);
  //     }
  //   }
  //   return menuId;
  // }


  // closeAllReports() {
  //   this.navLinks = [];
  // }

  // pushManuInFoundParent(filterdlist, parentMenuId, menu) {
  //   var index = filterdlist.filter(x => x.menuId == parentMenuId);
  //   if (index > 0) {

  //   }
  // }

  // findChildMenu(menu: MenuModel) {
  //   // Has Report

  //   if (menu.isParentMenu) {
  //     menu.childMenus = this.mainList.filter(x => x.parentMenuId == menu.menuId);
  //   }
  //   if (menu.childMenus.length == 0) {
  //     menu.childMenus = cloneDeep(this.sessionDataProvider.allMenusAvailable.filter(x => x.parentMenuId == menu.menuId));
  //   } else {
  //     if (menu.isParentMenu && menu.childMenus.length > 0 && menu.childMenus.filter(x => !x.isParentMenu && x.isAvailable).length > 0) {
  //       var childMeus = this.mainList.filter(x => x.parentMenuId == menu.menuId);
  //       if (childMeus.length > 0) {
  //         menu.childMenus = childMeus;
  //       }
  //     } else {
  //       for (let index = 0; index < menu.childMenus.length; index++) {
  //         this.findChildMenu(menu.childMenus[index]);
  //       }
  //     }
  //   }

  // }


  // groupByParnt(list) {
  //   var keys = [];
  //   list.forEach((item) => {
  //     const key = item.parentMenuId;
  //     var index = keys.findIndex(x => x == key);
  //     if (index == -1) {
  //       keys.push(key);
  //     }
  //   });
  //   return keys;
  // }

  // groupByMenus(list) {
  //   var keys = [];
  //   list.forEach((item) => {
  //     const key = { menuId: item.menuId, parentMenuId: item.parentMenuId, isParentMenu: item.isParentMenu };
  //     var index = keys.findIndex(x => x == key);
  //     if (index == -1) {
  //       keys.push(key);
  //     }
  //   });
  //   return keys;
  // }

  // groupByMenus(list) {
  //   var keys = [];
  //   list.forEach((item) => {
  //     const key = { menuId: item.menuId, parentMenuId: item.parentMenuId, isParentMenu: item.isParentMenu };
  //     var index = keys.findIndex(x => x == key);
  //     if (index == -1) {
  //       keys.push(key);
  //     }
  //   });
  //   return keys;
  // }

  // buildSearchedMenus() {
  //   this.mainMenus = [];
  //   this.mainList = [];
  //   var splitedArr = this.searchTextValue.trim().toLowerCase().split(' ');
  //   if (splitedArr && splitedArr.length > 0) {
  //     for (var subPattern of splitedArr) {
  //       //Get all menus isWithInReportHierarchy
  //       this.mainMenus = cloneDeep(this.sessionDataProvider.allMenusAvailable.filter(menu => menu.isWithInReportHierarchy === true && menu.menuId !== this.gridReportsMenuId));
  //       for (var mainMenu of this.mainMenus) {
  //         //Get all menus applied the search
  //         if (subPattern != '' && mainMenu.menuName.toLocaleLowerCase().includes(subPattern)) {
  //           var index = this.mainList.findIndex(x => x.menuId == mainMenu.menuId);
  //           if (index == -1) {
  //             mainMenu.hide = false;
  //             this.mainList.push(mainMenu);
  //           }
  //         }
  //       }
  //     }
  //   }


  //   //var menusList = this.groupByMenus(this.mainList);
  //   var filterdlist: MenuModel[] = [];
  //   var childsList = this.mainList.filter(x => !x.isParentMenu);
  //   var parentsList = this.mainList.filter(x => x.isParentMenu);
  //   for (let i = 0; i < parentsList.length; i++) {
  //     if (parentsList[i].parentMenuId == this.gridReportsMenuId) {
  //       var menu = parentsList[i];
  //       if (filterdlist.filter(x => x.menuId == menu.menuId).length <= 0) {
  //         filterdlist.push(menu);
  //       }
  //     } else {
  //       var parentMenuId = this.findParentMenuId(parentsList[i].menuId);
  //       var menu = this.findParentMenu(parentsList[i], true);
  //       if (filterdlist.filter(x => x.menuId == parentMenuId).length <= 0) {
  //         filterdlist.push(menu);
  //       }
  //     }

  //   }

  //   for (let i = 0; i < childsList.length; i++) {
  //     if (childsList[i].parentMenuId == this.gridReportsMenuId) {
  //       var menu = childsList[i];
  //       if (filterdlist.filter(x => x.menuId == menu.menuId).length <= 0) {
  //         filterdlist.push(menu);
  //       }
  //     } else {
  //       var parentMenuId = this.findParentMenuId(childsList[i].menuId);
  //       var menu = this.findParentMenu(childsList[i], true);
  //       if (filterdlist.filter(x => x.menuId == parentMenuId).length <= 0) {
  //         filterdlist.push(menu);
  //       }
  //     }



  //   }


  //   // var index = parentsList.findIndex(x => x == this.gridReportsMenuId);
  //   // if (index > -1) {
  //   //   this.mainList.filter(x => x.parentMenuId == this.gridReportsMenuId).forEach(element => {
  //   //     filterdlist.push(element);
  //   //   });
  //   //   parentsList.splice(index, 1);
  //   // }

  //   // for (let i = 0; i < parentsList.length; i++) {
  //   //   var parentMenuId = this.findParentMenu(parentsList[i]);
  //   //   var index = filterdlist.findIndex(x => x.menuId == parentMenuId);
  //   //   if (index == - 1) {
  //   //     var index = this.sessionDataProvider.allMenusAvailable.findIndex(x => x.menuId == parentMenuId);
  //   //     if (index > - 1) {
  //   //       filterdlist.push(this.sessionDataProvider.allMenusAvailable[index]);
  //   //     }
  //   //   }
  //   // }

  //   // for (let i = 0; i < filterdlist.length; i++) {
  //   //   this.findChildMenu(filterdlist[i]);
  //   // }

  //   this.appearedMenus = cloneDeep(filterdlist);
  //   this.collapseUncollapseAllMenus(this.appearedMenus, false);


  // }


  // groupMenusByParent(menuslist) {
  //   var keys = [];
  //   menuslist.forEach((menu) => {
  //     const key = { menu: menu, parentMenuId: menu.parentMenuId };
  //     var index = keys.findIndex(x => x.parentMenuId);
  //     if (index == -1) {
  //       keys.push(key);
  //     }
  //   });
  //   return keys;
  // }

  //#region [Favorite reports]
  onMarkAsFavouriteClick(menu: any, fromFavorites: boolean) {
    if(menu && menu.reportId > 0) {
      if(!menu.isReportFavorite) {
        this.addReportToFavorites(menu,fromFavorites);
      } else {
        this.removeReportFromFavorites(menu,fromFavorites);
      }
    }
  }

  addReportToFavorites(menu: any,fromFavorites: boolean) {
    this.dynamicReportService.markReportAsFavorite(menu.reportId).subscribe(response => {
      if(response && response.status >= 0) {
        menu.isReportFavorite = true;
        this.reflectOnSessionMenus(menu, true);
        if(fromFavorites)
          this.reflectOnListMenus(menu, true);
        var copyOfMenu = cloneDeep(menu);
        this.favouriteMenus.push(copyOfMenu);
        this.showHideFavorites();
      }
    }, (error: HttpErrorResponse) => {});
  }

  removeReportFromFavorites(menu: any,fromFavorites: boolean) {
    this.dynamicReportService.unmarkReportAsFavorite(menu.reportId).subscribe(response => {
      if(response && response.status >= 0) {
        menu.isReportFavorite = false;
        this.reflectOnSessionMenus(menu, false);
        if(fromFavorites)
          this.reflectOnListMenus(menu, false);
        var idx = this.favouriteMenus.findIndex(m => m.menuId === menu.menuId && m.reportId === menu.reportId);
        if(idx > -1) {
          this.favouriteMenus.splice(idx,1);
        }
        this.showHideFavorites();
      }
    }, (error: HttpErrorResponse) => {});
  }

  reflectOnSessionMenus(menu: any, isReportFavorite: boolean) {
    var menuObj = this.sessionDataProvider.allMenusAvailable.find(addedMenu => 
      addedMenu.menuId === menu.menuId && addedMenu.reportId === menu.reportId);
    if(menuObj) {
      menuObj.isReportFavorite = isReportFavorite;
    }
  }

  reflectOnListMenus(menu: any, isReportFavorite: boolean) {
    var requiredMenuParentsIdsList = menu.parentMenuIdsList;
    var listMenuObj = this.appearedMenus.find(listmenu => listmenu.menuId === menu.menuId 
      && listmenu.reportId === menu.reportId);
    if(listMenuObj) {
      listMenuObj.isReportFavorite = isReportFavorite;
    } else {
      var parent = this.appearedMenus.find(listmenu => requiredMenuParentsIdsList.includes(listmenu.menuId) );
      while(parent && parent.childMenus && parent.childMenus.length > 0 && parent.menuId !== menu.menuId) {
        parent = parent.childMenus.find(child =>
          requiredMenuParentsIdsList.includes(child.menuId) ||
          child.menuId === menu.menuId);
      }
      if(parent) {
        parent.isReportFavorite = isReportFavorite;
      }
    }


  }

  toggleExpandFavorites() {
    this.expandFavorites = !this.expandFavorites;
    if(this.expandFavorites) {
      this.showCollapseAll = true;
    } else {
      if (this.appearedMenus.filter(x => x.hide).length > 0) {
        this.showCollapseAll = true;
      } else {
        this.showCollapseAll = false;
      }
    }
  }

  showHideFavorites() {
    if(this.favouriteMenus && this.favouriteMenus.length > 0) {
      this.showFavorites = true;
    } else {
      this.showFavorites = false;
    }
  }
  //#endregion
}
