import { HttpErrorResponse } from '@angular/common/http';
import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { TranslateService } from '@ngx-translate/core';
import { CoreSession } from '../../../core/core.session';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { AtReportsService } from '../../../shared/services/at-reports.service';
import { DashboardService } from '../../dashboard/dashboard.service';

@Component({
  selector: 'app-navigation-cards',
  templateUrl: './navigation-cards.component.html',
  styleUrls: ['./navigation-cards.component.css']
})
export class NavigationCardsComponent implements OnInit {
  navLinks: any[];
  indexCounter: number = -1;
  reports: any[] = [];
  gridReportPermission: boolean = false;
  atReportPermission: boolean = false;
  showNoDataFound: boolean = false;
  constructor(
    private sessionDataProvider: SessionDataProvider,
    private coreSession: CoreSession,
    private atReportsService: AtReportsService,
    private translateService: TranslateService,
    private router: Router) { }

  ngOnInit() {
    this.coreSession.SetTitle('Reports Data');

    this.atReportPermission = this.sessionDataProvider.allMenusAvailable.filter(menu => menu.menuId == '500-002').length > 0;
    this.gridReportPermission = this.sessionDataProvider.allMenusAvailable.filter(menu => menu.menuId == '500-001').length > 0;

    if (this.atReportPermission) {
      this.getAvailableAdvancedToolReport();
    } else if (this.gridReportPermission) {
      this.router.navigate(['/reports/grid-reports']);
    }
  }

  prepareNavigation() {

    if (this.atReportPermission && this.reports && this.reports.length > 0 && this.gridReportPermission) {
      this.navLinks = [];
      for (let menu of this.sessionDataProvider.allMenusAvailable.filter(x => x.menuId == '500-001' || x.menuId == '500-002')) {
        if (menu.menuId == '500-001' || menu.menuId == '500-002') {
          this.indexCounter = this.indexCounter + 1
          let newName = {
            label: menu.menuName,
            link: '/reports/' + menu.url,
            isActive: false,
            index: this.indexCounter,
            menuId: menu.menuId
          };
          this.navLinks.push(newName);
        }
      }
    }else {
      if (this.gridReportPermission)
        this.router.navigate(['/reports/grid-reports']);
      else if (this.atReportPermission)
        this.router.navigate(['/reports/at-reports']);
    }
   

  }

  getAvailableAdvancedToolReport() {
    this.coreSession.ModalLoading.Show();
    this.atReportsService.getAvailableAdvancedToolReport().subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.reports = response.data;
          this.prepareNavigation();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
}