import { Component, OnInit, Input } from '@angular/core';
import { SafeResourceUrl, DomSanitizer } from '@angular/platform-browser';
import { CoreSession } from '../../../core/core.session';
import { DashboardService } from '../../dashboard/dashboard.service';
import { TranslateService } from '@ngx-translate/core';
import { DialogMode } from '../../../shared/models/enums/dialog-mode.enum';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';

@Component({
  selector: 'app-report-Cards',
  templateUrl: './report-Cards.component.html',
  styleUrls: ['./report-Cards.component.css']
})
export class ReportCardsComponent implements OnInit {
  @Input() isAdvancedToolReports = false;
  reports: any[] = [];
  showSlider = false;
  reportURL: string;
  reportName: string;
  safeURL: SafeResourceUrl;
  showNoDataFound = false;

  constructor(
    public coreSession: CoreSession,
    private dashboardService: DashboardService,
    private sanitizer: DomSanitizer,
    private translateService: TranslateService
  ) { }

  ngOnInit() {
    this.coreSession.SetTitle('Reports Data');
    if (this.isAdvancedToolReports) {
      this.getAvailableAdvancedToolReport();
    } else
      this.getAvailableReport();
  }
  getAvailableAdvancedToolReport() {
    this.coreSession.ModalLoading.Show();
    this.dashboardService.getAvailableAdvancedToolReport().subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.reports = response.data;
          if (this.reports && this.reports.length > 0) {
            this.showNoDataFound = false;
          }
          else {
            this.showNoDataFound = true;
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  getAvailableReport() {
    this.coreSession.ModalLoading.Show();
    this.dashboardService.getAvailableReport().subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.reports = response.data;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  closeSlider() {
    this.showSlider = false;
    this.reportURL = '';
  }

  openReport(url, name) {
    this.reportURL = url;
    this.reportName = name;
    this.getURL(url);
    this.showSlider = true;
  }

  getURL(url) {
    this.safeURL = this.sanitizer.bypassSecurityTrustResourceUrl(url);
    return this.safeURL;
  }

}
