import { Component, OnInit } from '@angular/core';
import { SafeResourceUrl, DomSanitizer } from '@angular/platform-browser';
import { CoreSession } from '../../../core/core.session';
import { DashboardService } from '../../dashboard/dashboard.service';
import { DialogMode } from '../../../shared/models/enums/dialog-mode.enum';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { TranslateService } from '@ngx-translate/core';
import { ActivatedRoute, Router } from '@angular/router';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { ConstantURLs } from '../../../shared/models/constants/constant-URL';

@Component({
  selector: 'app-report-main',
  templateUrl: './report-main.component.html',
  styleUrls: ['./report-main.component.css']
})
export class ReportMainComponent implements OnInit {

  navLinks: any[];
  indexCounter: number = -1;
  constructor(
    private route: ActivatedRoute,
    private router: Router,
    private sessionDataProvider: SessionDataProvider,
    private coreSession: CoreSession
  ) { }

  ngOnInit() {
    this.coreSession.SetTitle('Reports Data');
    /* this. prepareNavigation();
    this.navLinks[0].isActive = true; */
    //this.router.navigateByUrl(ConstantURLs.atreportsURL);
  }
  prepareNavigation() {
    this.navLinks = [];
    for (let menu of this.sessionDataProvider.allMenusAvailable) {
      if (menu.menuId.startsWith('500-')) {
        this.indexCounter = this.indexCounter + 1
        let newName = {
          label: menu.menuName,
          link: menu.url,
          isActive: false,
          index: this.indexCounter
        };
        this.navLinks.push(newName);
      }
    }
  }
}
