import { Routes, RouterModule } from "@angular/router";
import { NgModule } from "@angular/core";
import { ReportMainComponent } from "./report-main/report-main.component";
import { AuthGuard } from '../../core/auth/auth.gurad';
import { ConstantURLs } from '../../shared/models/constants/constant-URL';
import { PendingInvoicesComponent } from '../customer-operation/payments/pending-invoices/pending-invoices.component';
import { GridReportsComponent } from './grid-reports/grid-reports.component';
import { AtReportsComponent } from './at-reports/at-reports.component';
import { NavigationCardsComponent } from "./navigation-cards/navigation-cards.component";

const ReportRouting: Routes = [
  {
    path: '',
    canActivate: [AuthGuard],
    component: ReportMainComponent,
    children: [
      {
        path: '',
        canActivate: [AuthGuard],
        component: NavigationCardsComponent,
      },
      {
        path: ConstantURLs.gridReportsURL,
        canActivate: [AuthGuard],
        component: GridReportsComponent
      },
      {
        path: ConstantURLs.atreportsURL,
        canActivate: [AuthGuard],
        component: AtReportsComponent
      }
    ]
  }
];

@NgModule({
  imports: [RouterModule.forChild(ReportRouting)],
  exports: [RouterModule]
})
export class ReportRoutingModule { }
