import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { TranslateModule } from '@ngx-translate/core';
import { SharedModule } from '../../shared/shared.module';
import { ReportMainComponent } from './report-main/report-main.component';
import { ReportRoutingModule } from './report-routing.module';
import { ReportCardsComponent } from './report-Cards/report-Cards.component';
import { AtReportsComponent } from './at-reports/at-reports.component';
import { GridReportsComponent } from './grid-reports/grid-reports.component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { NavigationCardsComponent } from './navigation-cards/navigation-cards.component';
import { DynamicReportComponent } from './dynamic-report/dynamic-report.component';
import { NgMultiSelectDropDownModule } from 'ng-multiselect-dropdown';
import { NgSelectModule } from '@ng-select/ng-select';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { OwlDateTimeModule, OwlNativeDateTimeModule } from 'ng-pick-datetime';

@NgModule({
  imports: [
    CommonModule,
    ReportRoutingModule,
    ReactiveFormsModule,
    FormsModule,
    SharedModule,
    OwlDateTimeModule,
    OwlNativeDateTimeModule,
    NgbModule,
    TranslateModule.forChild(),
    NgSelectModule,
    NgMultiSelectDropDownModule,
  ],
  declarations: [
    ReportMainComponent,
    ReportCardsComponent,
    AtReportsComponent,
    GridReportsComponent,
    NavigationCardsComponent,
    DynamicReportComponent
  ]
})
export class ReportModule { }
