import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { ResponseModel } from '../shared/models/api-models/api-models';

@Injectable({
    providedIn: 'root'
})
export class EchoService {

    httpOptions;
    private url = '';
    constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string) {
        this.url = baseUrl + 'Echo';
        this.httpOptions = {
            headers: new HttpHeaders({
                'Content-Type': 'application/json'
            })
        };
    }

    saveCustomerProperties(customerProperties) {
        const urlValue = this.url + "/InsertCustomerProperties";
        return this.http.post(urlValue, customerProperties).map((response) => {
            const res = new ResponseModel();
            res.data = response['data'];
            res.message = response['message'];
            res.status = response['status'];
            return res;
        });
    }
    getContactUsList(filter) {
        const urlValue: string = this.url + '/GetContactUsList';
        return this.http.post(urlValue, JSON.stringify(filter), this.httpOptions).map(
            (response) => {
                const result = new ResponseModel();
                result.data = response['data'];
                result.message = response['message'];
                result.status = response['status'];
                return result;
            }
        );
    }
    getCustomerProperties() {
        const urlValue: string = this.url + '/GetCustomerProperties';
        return this.http.get<ResponseModel>(urlValue).map(
            (response) => {
                const res = new ResponseModel();
                res.data = response['data'];
                res.message = response['message'];
                res.status = response['status'];
                return res;
            }
        );
    }
    saveBanner(brand: FormData) {
        const urlValue = this.url + "/InsertBanner";
        return this.http.post<ResponseModel>(urlValue, brand)
            .map(response => {
                return response;
            })
    }
    getBanners() {
        const urlValue = this.url + "/getBanners";
        return this.http.get<ResponseModel>(urlValue).map(
            (response) => {
                const res = new ResponseModel();
                res.data = response['data'];
                res.message = response['message'];
                res.status = response['status'];
                return res;
            }
        );
    }
    deleteBanner(fileName) {
        const urlValue = this.url + "/DeleteBanner";
        return this.http.get(urlValue + '?fileName=' + fileName).map((response) => {
            const res = new ResponseModel();
            res.data = response['data'];
            res.message = response['message'];
            res.status = response['status'];
            return res;
        });
    }

    saveFeedbackReply(feedBackReply: any) {
        const urlValue: string = this.url + '/InsertFeedbackReply';

        return this.http.post(urlValue, JSON.stringify(feedBackReply), this.httpOptions).map(
            (response) => {
                const result = new ResponseModel();
                result.data = response['data'];
                result.message = response['message'];
                result.status = response['status'];
                return result;
            }
        );
    }

    getEchoItems() {
        const urlValue = this.url + "/GetEchoItems";
        return this.http.get<ResponseModel>(urlValue).map(
            (response) => {
                const res = new ResponseModel();
                res.data = response['data'];
                res.message = response['message'];
                res.status = response['status'];
                return res;
            }
        );
    }

    saveEchoItems(packList: any) {
        const urlValue = this.url + "/InsertEchoItems";
        return this.http.post(urlValue, JSON.stringify(packList), this.httpOptions).map(
            (response) => {
                const result = new ResponseModel();
                result.data = response['data'];
                result.message = response['message'];
                result.status = response['status'];
                return result;
            });
    }

    getEchoDivisions() {
        const urlValue = this.url + "/GetEchoDivisions";
        return this.http.get<ResponseModel>(urlValue).map(
            (response) => {
                const res = new ResponseModel();
                res.data = response['data'];
                res.message = response['message'];
                res.status = response['status'];
                return res;
            }
        );
    }

    getEchoCategories(divisionId: number) {
        const urlValue = this.url + "/GetEchoCategories";
        return this.http.get<ResponseModel>(urlValue + '?DivisionId=' + divisionId).map(
            (response) => {
                const res = new ResponseModel();
                res.data = response['data'];
                res.message = response['message'];
                res.status = response['status'];
                return res;
            }
        );
    }

    getEchoBrands(divisionId: number, itemCategoryId: number) {
        const urlValue = this.url + "/GetEchoBrands";
        return this.http.get<ResponseModel>(
            urlValue + "?divisionId=" + divisionId + "&itemCategoryId=" + itemCategoryId).map(
                (response) => {
                    const res = new ResponseModel();
                    res.data = response['data'];
                    res.message = response['message'];
                    res.status = response['status'];
                    return res;
                }
            );
    }

    getEchoFirstOrderItems(itemFilter: any, getAddedItems?: boolean) {
        getAddedItems = getAddedItems ? true : false;
        const urlValue: string = this.url + '/GetEchoFirstOrderItems';
        return this.http.get<ResponseModel>(urlValue + "?itemsFilter=" + JSON.stringify(itemFilter)
            + "&getAddedItems=" + getAddedItems).map(
                (response) => {
                    const res = new ResponseModel();
                    res.data = response['data'];
                    res.message = response['message'];
                    res.status = response['status'];
                    return res;
                }
            );
    }

    insertEchoFirstOrderItems(addedFirstOrderFreeItems: any[]) {
        const urlValue: string = this.url + '/InsertEchoFirstOrderItems';
        return this.http.post(urlValue, addedFirstOrderFreeItems).map(
            (response) => {
                const res = new ResponseModel();
                res.data = response['data'];
                res.message = response['message'];
                res.status = response['status'];
                return res;
            }
        );
    }
    getCustomerAppSettings() {
        const urlValue = this.url + "/GetCustomerAppSettings";
        return this.http.get<ResponseModel>(urlValue).map(
            (response) => {
                const res = new ResponseModel();
                res.data = response['data'];
                res.message = response['message'];
                res.status = response['status'];
                return res;
            }
        );
    }
    UpdateCustomerAppSettings(obj: any) {
        const urlValue = this.url + '/UpdateCustomerAppSettings';
        return this.http.post<ResponseModel>(urlValue, obj).map(response => {
            return response;
        });
    }
    getCustomizeHomePage() {
        const urlValue = this.url + "/GetCustomizeHomePage";
        return this.http.get<ResponseModel>(urlValue).map(
            (response) => {
                const res = new ResponseModel();
                res.data = response['data'];
                res.message = response['message'];
                res.status = response['status'];
                return res;
            }
        );
    }
    getCompany() {
        const urlValue = this.url + "/GetCompany";
        return this.http.get<ResponseModel>(urlValue).map(
            (response) => {
                const res = new ResponseModel();
                res.data = response['data'];
                res.message = response['message'];
                res.status = response['status'];
                return res;
            }
        );
    }
    getOrganizationListCompanyDetails(isEditMode?: boolean) {
        const urlValue = this.url + "/GetOrganizationListCompanyDetails";
        return this.http.get<ResponseModel>(urlValue + "?isEditMode=" + isEditMode).map(
            (response) => {
                const res = new ResponseModel();
                res.data = response['data'];
                res.message = response['message'];
                res.status = response['status'];
                return res;
            }
        );
    }
    getCompanyDetails(organizationId: number) {
        const urlValue: string = this.url + '/GetCompanyDetails?organizationId=' + organizationId;
        return this.http.get<ResponseModel>(urlValue).map(
            response => {
                return response;
            });
    }
    deleteCompanyDetails(organizationId: number) {
        const urlValue = this.url + '/DeleteCompanyDetails';
        return this.http.get<ResponseModel>(urlValue + '?organizationId=' + organizationId).map(response => {
            return response;
        });
    }
    InsertCompanyDetails(companyDetailsObject: any) {
        const urlValue: string = this.url + "/InsertCompanyDetails";
        return this.http.post<ResponseModel>(urlValue, companyDetailsObject).map((response) => {
            const res = new ResponseModel();
            res.data = response["data"];
            res.message = response["message"];
            res.status = response["status"];
            return res;
        });
    }
    updateCompanyDetails(companyDetailsObject: any) {
        const urlValue: string = this.url + "/UpdateCompanyDetails";
        return this.http.post<ResponseModel>(urlValue, companyDetailsObject).map((response) => {
            const res = new ResponseModel();
            res.data = response["data"];
            res.message = response["message"];
            res.status = response["status"];
            return res;
        });
    }
    getOrganization() {
        const urlValue = this.url + "/GetOrganization";
        return this.http.get<ResponseModel>(urlValue).map(
            (response) => {
                const res = new ResponseModel();
                res.data = response['data'];
                res.message = response['message'];
                res.status = response['status'];
                return res;
            }
        );
    }
    getOrganizationDetails(organizationId: number) {
        const urlValue: string = this.url + '/GetOrganizationDetails?organizationId=' + organizationId;
        return this.http.get<ResponseModel>(urlValue).map(
            response => {
                return response;
            });
    }
    InsertOrganizationDetails(organizationDetailsObject: any) {
        const urlValue: string = this.url + "/InsertOrganizationDetails";
        return this.http.post<ResponseModel>(urlValue, organizationDetailsObject).map((response) => {
            const res = new ResponseModel();
            res.data = response["data"];
            res.message = response["message"];
            res.status = response["status"];
            return res;
        });
    }
    updateOrganizationDetails(organizationDetailsObject: any) {
        const urlValue: string = this.url + "/UpdateOrganizationDetails";
        return this.http.post<ResponseModel>(urlValue, organizationDetailsObject).map((response) => {
            const res = new ResponseModel();
            res.data = response["data"];
            res.message = response["message"];
            res.status = response["status"];
            return res;
        });
    }
    deleteOrganizationDetails(organizationId: number) {
        const urlValue = this.url + '/DeleteOrganizationDetails';
        return this.http.get<ResponseModel>(urlValue + '?organizationId=' + organizationId).map(response => {
            return response;
        });
    }
    getOrganizationListOrganizationDetails(isEditMode?: boolean) {
        const urlValue = this.url + "/GetOrganizationListOrganizationDetails";
        return this.http.get<ResponseModel>(urlValue + "?isEditMode=" + isEditMode).map(
            (response) => {
                const res = new ResponseModel();
                res.data = response['data'];
                res.message = response['message'];
                res.status = response['status'];
                return res;
            }
        );
    }
    GetAllFQAs(fQAsFilter) {
        const urlValue = this.url + "/GetAllFQAs";
        return this.http.post<ResponseModel>(urlValue, fQAsFilter)
        .map(response => {
          return response;
      });
    }
    InsertFQA(fQAsArr){
        const urlValue = this.url + "/InsertFQA";
        return this.http.post(urlValue, fQAsArr).map((response) => {
            const res = new ResponseModel();
            res.data = response['data'];
            res.message = response['message'];
            res.status = response['status'];
            return res;
        });
    }
}
