import { Component, OnInit, EventEmitter, Input, Output, } from "@angular/core";
import { FormGroup, FormControl, Validators } from "@angular/forms";
import { Observable } from "rxjs/Rx";
import { HttpErrorResponse } from "@angular/common/http";
import { SharedTableResult } from "../../../../shared/models/shared-table/shared-table-result.interface";
import { CoreSession } from "../../../../core/core.session";
import { ConstantMessages } from "../../../../shared/models/constants/constant-message";
import { TranslateService } from "@ngx-translate/core";
import { EchoService } from "../../../echo.service";

@Component({
  selector: "app-company-details-entry",
  templateUrl: "./company-details-entry.component.html",
  styleUrls: ["./company-details-entry.component.css"],
})
export class CompanyDetailsEntryComponent implements OnInit {
  @Input() saveEvent: Observable<void>;
  @Input() companyDetailsObject: any = new Object();;
  @Output() onSaveCompleted = new EventEmitter();
  @Input() isEditMode: boolean = false;
  @Input() isViewMode = false;
  organizaionList: any[] = [];
  organizationId = null;
  isOrganizationLoading: boolean = false;
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: [],
  };
  myForm: FormGroup;

  constructor(
    private echoService: EchoService,
    public coreSession: CoreSession,
    private translateService: TranslateService,
  ) {
  }

  ngOnInit() {
    this.initForm();
    this.fillOrganizationList();
  }

  initForm() {
    this.myForm = new FormGroup({
      organizationID: new FormControl(({ value: this.isEditMode ? this.companyDetailsObject.organizationID : null, disabled: this.isEditMode || this.isViewMode }), Validators.required),
      mobileNo: new FormControl({ value: this.isEditMode ? this.companyDetailsObject.mobileNo : null, disabled: this.isViewMode }),
      fax: new FormControl({ value: this.isEditMode ? this.companyDetailsObject.fax : null, disabled: this.isViewMode }),
      email: new FormControl({ value: this.isEditMode ? this.companyDetailsObject.email : null, disabled: this.isViewMode }, [Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]),
      latitude: new FormControl({ value: this.isEditMode ? this.companyDetailsObject.latitude : null, disabled: this.isViewMode }),
      longitude: new FormControl({ value: this.isEditMode ? this.companyDetailsObject.longitude : null, disabled: this.isViewMode }),
      facebook: new FormControl({ value: this.isEditMode ? this.companyDetailsObject.facebook : null, disabled: this.isViewMode }, [Validators.pattern("^(?:https?:\/\/)?(?:www\.)?facebook\.com\/(#!\/)?[a-zA-Z0-9_]+|/$")]),
      instagram: new FormControl({ value: this.isEditMode ? this.companyDetailsObject.instagram : null, disabled: this.isViewMode }, [Validators.pattern("^(?:https?:\/\/)?(?:www\.)?instagram\.com\/(#!\/)?[a-zA-Z0-9_]+|/$")]),
      twitter: new FormControl({ value: this.isEditMode ? this.companyDetailsObject.twitter : null, disabled: this.isViewMode }, [Validators.pattern("^(?:https?:\/\/)?(?:www\.)?twitter\.com\/(#!\/)?[a-zA-Z0-9_]+$")]),
      youtube: new FormControl({ value: this.isEditMode ? this.companyDetailsObject.youtube : null, disabled: this.isViewMode }, [Validators.pattern("^(?:https?:\/\/)?(?:www\.)?youtube\.com\/(#!\/)?[a-zA-Z0-9_]+|/(#!\/)?[a-zA-Z0-9_]$")]),
      linkedin: new FormControl({ value: this.isEditMode ? this.companyDetailsObject.linkedin : null, disabled: this.isViewMode }, [Validators.pattern("^(?:https?:\/\/)?(?:www\.)?linkedin\.com\/(#!\/)?[a-zA-Z0-9_]+|/(#!\/)?[a-zA-Z0-9_]$")]),
      whatsapp: new FormControl({ value: this.isEditMode ? this.companyDetailsObject.whatsapp : null, disabled: this.isViewMode }),
      locationString: new FormControl({ value: this.isEditMode ? this.companyDetailsObject.locationString : null, disabled: this.isViewMode }),
    });
  }
  fillCompanyDetailsObject() {
    this.companyDetailsObject = new Object();
    this.companyDetailsObject.organizationID = this.myForm.get('organizationID').value ? this.myForm.get('organizationID').value : -1;
    this.companyDetailsObject.mobileNo = this.myForm.get('mobileNo').value ? String(this.myForm.get('mobileNo').value) : '';
    this.companyDetailsObject.fax = this.myForm.get('fax').value ? String(this.myForm.get('fax').value) : '';
    this.companyDetailsObject.email = this.myForm.get('email').value ? this.myForm.get('email').value : '';
    this.companyDetailsObject.latitude = this.myForm.get('latitude').value ? +this.myForm.get('latitude').value : 0;
    this.companyDetailsObject.longitude = this.myForm.get('longitude').value ? +this.myForm.get('longitude').value : 0;
    this.companyDetailsObject.facebook = this.myForm.get('facebook').value ? this.myForm.get('facebook').value : '';
    this.companyDetailsObject.instagram = this.myForm.get('instagram').value ? this.myForm.get('instagram').value : '';
    this.companyDetailsObject.twitter = this.myForm.get('twitter').value ? this.myForm.get('twitter').value : '';
    this.companyDetailsObject.youtube = this.myForm.get('youtube').value ? this.myForm.get('youtube').value : '';
    this.companyDetailsObject.linkedin = this.myForm.get('linkedin').value ? this.myForm.get('linkedin').value : '';
    this.companyDetailsObject.whatsapp = this.myForm.get('whatsapp').value ? String(this.myForm.get('whatsapp').value) : '';
    this.companyDetailsObject.locationString = this.myForm.get('locationString').value ? this.myForm.get('locationString').value : '';
    this.companyDetailsObject.organizationCode = "";

  }
  ngOnDestroy() {

  }
  public markFormGroupTouched(formGroup: FormGroup) {
    (<any>Object).values(formGroup.controls).forEach((control) => {
      control.markAsTouched();

      if (control.controls) {
        this.markFormGroupTouched(control);
      }
    });
  }

  fillOrganizationList() {
    this.coreSession.ModalLoading.Show();
    this.echoService.getOrganizationListCompanyDetails(this.isEditMode).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.organizaionList = response.data;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  onSaveAndNew() {
    this.SaveCompanyDetails(false);
    this.fillOrganizationList();
  }
  onSaveAndClose() {
    this.SaveCompanyDetails(true);
  }
  SaveCompanyDetailsToDB(close: boolean) {
    this.coreSession.ModalLoading.Show();
    this.echoService.InsertCompanyDetails(this.companyDetailsObject).subscribe(
      result => {
        this.coreSession.ModalLoading.Hide();
        if (result.status != null && result.status >= 0) {
          this.onSaveCompleted.emit(close);
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
          if (!close)
            this.clearControls();
        } else {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), result.message);
        }
      });
  }
  UpdateCompanyDetailsInDB(close: boolean) {
    this.coreSession.ModalLoading.Show();
    this.echoService.updateCompanyDetails(this.companyDetailsObject).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
          this.onSaveCompleted.emit(close);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorCaption));
      }
    );
  }
  SaveCompanyDetails(close: boolean) {
    if (this.myForm.invalid) {
      this.coreSession.markFormGroupTouched(this.myForm);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
    this.fillCompanyDetailsObject();
    if (this.companyDetailsObject.mobileNo === "" && this.companyDetailsObject.fax === "" && this.companyDetailsObject.email === "" && this.companyDetailsObject.latitude === 0 && this.companyDetailsObject.longitude === 0
      && this.companyDetailsObject.facebook === "" && this.companyDetailsObject.instagram === "" && this.companyDetailsObject.twitter === "" && this.companyDetailsObject.linkedin === "" && this.companyDetailsObject.youtube === ""
      && this.companyDetailsObject.whatsapp === "" && this.companyDetailsObject.locationString === "") {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillAtLeastOneOfContactFields));
      return;
    }
    if (!this.isEditMode) {
      this.SaveCompanyDetailsToDB(close);
    }
    else {
      this.UpdateCompanyDetailsInDB(close);
    }
  }

  clearControls() {
    this.myForm.get("organizationID").setValue(null);
    this.myForm.get("mobileNo").setValue(null);
    this.myForm.get("fax").setValue(null);
    this.myForm.get("email").setValue(null);
    this.myForm.get("latitude").setValue(null);
    this.myForm.get("longitude").setValue(null);
    this.myForm.get("facebook").setValue(null);
    this.myForm.get("instagram").setValue(null);
    this.myForm.get("twitter").setValue(null);
    this.myForm.get("youtube").setValue(null);
    this.myForm.get("linkedin").setValue(null);
    this.myForm.get("whatsapp").setValue(null);
    this.myForm.get("locationString").setValue(null);
  }
  get Email() {
    return this.myForm.get('email')
  }
  get Facebook() {
    return this.myForm.get('facebook')
  }
  get Instagram() {
    return this.myForm.get('instagram')
  }
  get Twitter() {
    return this.myForm.get('twitter')
  }
  get Linkedin() {
    return this.myForm.get('linkedin')
  }
  get Youtube() {
    return this.myForm.get('youtube')
  }
}



