import { BannerTypes } from './../../../shared/models/enums/banner-type.enum';
import { FormControl, Validators } from '@angular/forms';
import { Component, EventEmitter, OnInit, Output } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { CoreSession } from '../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { EchoService } from '../../echo.service';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { HttpErrorResponse } from '@angular/common/http';
import { DialogResult } from '../../../shared/models/enums/dialog-result.enum';
import { DialogMode } from '../../../shared/models/enums/dialog-mode.enum';
import { PricesAndOffersService } from '../../../content/master-data-definition/prices-and-offers-management/prices-and-offers.service';
import { SurveyService } from '../../../content/master-data-definition/survey-managment/survey.service';
import { PromotionService } from '../../../shared/services/data-definition/prices-and-offers/promotion.service';
import { ShepherdService } from 'angular-shepherd';
import { Router } from '@angular/router';
import { TourService } from '../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../shared/shepherd-config/trackTour.service';
@Component({
  selector: 'app-cust-app-banners-entry',
  templateUrl: './cust-app-banners-entry.component.html',
  styleUrls: ['./cust-app-banners-entry.component.css']
})
export class CustAppBannersEntryComponent implements OnInit {
  form: FormGroup;
  selectedImage: File = null;
  hasImage = false;
  isImageChanged = false;
  imagePath: any = "";
  bannerTypesList: any[] = [];
  isTypeLoading: boolean = false;
  bannerObject: any;
  bannersList: any[] = [];

  promotionDataSource: any[] = [];
  isPromotionLoading: boolean = false;

  surveyDataSource: any[] = [];
  isSurveyLoading: boolean = false;

  promotionFilter = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    promotionTypeId: -1,
    organizationId: -1,
    customerId: -1,
    outletId: -1,
    customerGroupId: -1,
    IncludeInactive: true,
    isCustomerApp: true,
    fromDate: null,
    toDate: null
  };
  query: any = {
    surveyTypeID: 6
  };

  constructor(private coreSession: CoreSession,
    private translateService: TranslateService,
    private echoService: EchoService,
    private pricesAndOffersService: PricesAndOffersService,
    private surveyService: SurveyService,
    private promotionService: PromotionService,
    private router:Router
  , private readonly shepherdService: ShepherdService,
  private tourService : TourService,
  private componentVisitService: ComponentVisitService
) { }

  private tourStartTimeout: any;
  ngAfterViewInit() {
//     this.tourStartTimeout =  setTimeout((data=>{
//       if (this.tourService.isTourCompletedForComponent('cust-app-banners')) {
//         return;
// }
//       const elementSelectors = ['#image-def','#banner-type','#button-save','#images-def']
//       const titles = [];
//       const texts = [];
//       for (let index = 0; index < elementSelectors.length; index++) {
//         const { title, text } = this.getTitleAndText(index);
//         titles.push(title);
//         texts.push(text);
//       }
//       // Target each column by its unique ID
//       const steps = this.tourService.generateSteps(elementSelectors,titles,texts);
//       this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
//       this.shepherdService.modal = true;
//       this.shepherdService.addSteps(steps);
//       this.shepherdService.start();
//     }),1000)

  }
  getTitleAndText(index: number): { title: string, text: string } {
    let title = '';
    let text = '';

    switch (index) {
      case 0:
        title = "Let's go to define your item";
        text = 'Here you can define your items.';
        break;
      case 1:
        title = "Let's go to define your customer";
        text = "Here you can define your customer";
        break;
      case 2:
      case 3:
      case 4:
      case 5:
        title = `Step ${index + 1} Title`;
        text = `Step ${index + 1} Content`;
        break;
      default:
        title = `Step ${index + 1}`;
        text = `Content in defult at bottom.`;
    }

    return { title, text };
  }

  ngOnInit() {
    this.subscribeSaveClick();
    this.initForm();
    this.fillPromotionList();
    this.fillSurveysList();
    this.fillBannerTypeList();
    this.getBanner();
  }
  initForm() {
    this.form = new FormGroup({
      bannerType: new FormControl(null),
      promotionId: new FormControl(null),
      surveyId: new FormControl(null),
      link: new FormControl(null),
    }); this.setDefaultImage();
  }

    ngOnDestroy(): void {
      if (this.tourStartTimeout) {
        clearTimeout(this.tourStartTimeout);
      }
      this.componentVisitService.markComponentVisited('cust-app-banners');

    }

  subscribeSaveClick() {
  }
  onSaveClicked() {
    this.fillBannerObject();
    if (this.form.invalid || !this.selectedImage) {
      this.coreSession.markFormGroupTouched(this.form as FormGroup);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
    this.saveBanner();
    this.onClearImage();
    this.onClearControls();
  }
  saveBanner() {
    var formData: FormData = new FormData();
    formData.append("image", this.selectedImage, this.selectedImage.name);
    formData.append('banner', JSON.stringify(this.bannerObject));
    this.echoService.saveBanner(formData).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), response.message);
          this.getBanner();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  onDeleteBanner(path: string) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption))
      .then(
        (result: DialogResult) => {
          if (result === DialogResult.Yes) {
            var index = this.bannersList ? this.bannersList.findIndex(x => x.path === path) : -1;
            if (index > -1) {
              var fileName = this.bannersList ? this.bannersList[index].bannerName : '';
              this.echoService.deleteBanner(fileName).subscribe(
                response => {
                  if (response.status != null && response.status >= 0) {
                    this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgDeletedSuccessfully));
                    this.getBanner();
                  } else {
                    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
                  }
                },
                (error: HttpErrorResponse) => {
                  this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
                }
              );
            }
          }
        }
      );
  }

  onUploadFinished(event: any) {
    if (event.target.files && event.target.files[0]) {
      const reader = new FileReader();
      this.selectedImage = event.target.files[0];
      this.hasImage = true;
      this.isImageChanged = true;
      reader.onload = (event: ProgressEvent) => {
        this.imagePath = (<FileReader>event.target).result;
      };
      reader.readAsDataURL(event.target.files[0]);
    }
  }
  onClearImage() {
    this.isImageChanged = true;
    this.hasImage = false;
    this.selectedImage = null;
    this.setDefaultImage();
  }
  onClearControls() {
    this.form.get("bannerType")?.setValue(null);
    this.form.get("valueId")?.setValue(null);
    this.form.get("link")?.setValue(null);
  }
  setDefaultImage() {
    this.imagePath = document.getElementsByTagName("base")[0].href + "Resources/NoProduct-Echo.jpg";
  }
  getBanner() {
    this.echoService.getBanners().subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.bannersList = response.data;

          if (this.bannersList && this.bannersList.length > 0) {
            var index = -1;
            this.bannersList.forEach((banner, i) => {
              index = -1;
              if (banner.bannerType == BannerTypes.Link.valueOf()) {
                this.bannersList[i].valueName = this.translateService.instant(ConstantMessages.Desc_Link_Banner_Type) + "-" + banner.link;
                this.bannersList[i].bannerName = banner.bannerName;
              }
              else if (banner.bannerType == BannerTypes.Promotion.valueOf()) {
                this.bannersList[i].valueName = this.translateService.instant(ConstantMessages.Promotion) + "-" + banner.valueName;
                this.bannersList[i].bannerName = banner.bannerName
              }
              else if (banner.bannerType == BannerTypes.Survey.valueOf()) {
                this.bannersList[i].valueName = this.translateService.instant(ConstantMessages.Desc_Survey) + "-" + banner.valueName;
                this.bannersList[i].bannerName = banner.bannerName
              }
              var currentPath = document.getElementsByTagName("base")[0].href + "Resources/banners-img/" + banner.bannerName;
              banner.path = currentPath;
            });
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  fillBannerTypeList() {
    this.bannerTypesList = [];
    this.bannerTypesList.push(
      { 'bannerType': BannerTypes.Promotion.valueOf(), 'bannerTypeName': this.translateService.instant(ConstantMessages.Promotion) },
      { 'bannerType': BannerTypes.Survey.valueOf(), 'bannerTypeName': this.translateService.instant(ConstantMessages.Desc_Survey) },
      { 'bannerType': BannerTypes.Link.valueOf(), 'bannerTypeName': this.translateService.instant(ConstantMessages.Desc_Link_Banner_Type) },
    );
  }
  fillPromotionList() {
    this.promotionService.getPromotionsListSharedTable(this.promotionFilter).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        this.promotionDataSource = response.data.data;
      }
      else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
  }
  fillSurveysList() {
    this.surveyService.getAllCustomerSurveys(this.query).subscribe(
      response => {
        (response.data, "Surveys");
        if (response.status != null && response.status >= 0) {
          this.surveyDataSource = response.data;
        }
        else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  fillBannerObject() {
    this.form.get('promotionId').setValidators([Validators.nullValidator]);
    this.form.get('promotionId').updateValueAndValidity();
    this.form.get('surveyId').setValidators([Validators.nullValidator]);
    this.form.get('surveyId').updateValueAndValidity();
    this.form.get('link').setValidators([Validators.nullValidator]);
    this.bannerObject = new Object();
    this.bannerObject.link = '';
    this.bannerObject.bannerType = this.form.get('bannerType').value ? this.form.get('bannerType').value : -1;
    if (this.bannerObject.bannerType == BannerTypes.Promotion) {
      this.bannerObject.valueId = this.form.get('promotionId').value ? this.form.get('promotionId').value : -1;
      if (this.bannerObject.valueId == -1) {
        this.form.get('promotionId').setValidators([Validators.required]);
      }
      this.form.get('promotionId').updateValueAndValidity();
    }
    else if (this.bannerObject.bannerType == BannerTypes.Survey) {
      this.bannerObject.valueId = this.form.get('surveyId').value ? this.form.get('surveyId').value : -1;
      if (this.bannerObject.valueId == -1) {
        this.form.get('surveyId').setValidators([Validators.required]);
      }
      this.form.get('surveyId').updateValueAndValidity();
    }
    else if (this.bannerObject.bannerType == BannerTypes.Link) {
      this.bannerObject.link = this.form.get('link').value ? this.form.get('link').value : ''
      if (this.bannerObject.link == '') {
        this.form.get('link').setValidators([Validators.required]);
      }
      this.form.get('link').updateValueAndValidity();
    }
  }
  public get getPromotionId() {
    return this.form.get("promotionId");
  }
  public get getSurveyId() {
    return this.form.get("surveyId");
  }
  public get getLink() {
    return this.form.get("link");
  }
}
