import { Component, OnDestroy, OnInit } from '@angular/core';
import { CoreSession } from '../../../core/core.session';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { EchoService } from '../../echo.service';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { ITableProperties } from '../../../shared/models/shared-table/table-properties.interface';
import { SharedTableResult } from '../../../shared/models/shared-table/shared-table-result.interface';
import { RowOperation } from '../../../shared/models/enums/shared-table-operation.enum';
import { CustAppPropertiesModel } from '../../models/custAppProperties.model';
import { Subject } from 'rxjs';
import { NavigationData } from '../../../shared/models/navigation-data/navigation-data.model';
import { ConstantURLs } from '../../../shared/models/constants/constant-URL';
import { NavBarService } from '../../../core/sidebar/sidebar.service';

@Component({
  selector: 'app-cust-app-contact-us',
  templateUrl: './contact-us-list.component.html',
  styleUrls: ['./contact-us-list.component.css']
})
export class CustAppContactUsComponent implements OnInit, OnDestroy {
  feedbackReplyModule: any;
  saveSubject: Subject<void> = new Subject<void>();
  showSlider = false;
  isShowFooter = true;
  constructor(private echoService: EchoService,
    public coreSession: CoreSession,
    private sessionDataProvider: SessionDataProvider,
    private navService:NavBarService) { }

  TableData: ITableProperties = {
    pageSize: 50,
    showPaginator: false,
    showSearch: true,
    isOnline: true,
    showSearchBtn: true,
    showNewBtn: false,
    rowOperations: [
    ],
    multiSelectionOperations: [],
    columns: [
      {
        title: 'Desc_Customer_Code',
        key: 'customerCode',
        isSortable: true,
        width: '25%'
      },
      {
        title: 'Desc_Customer',
        key: 'customerName',
        isSortable: true,
        width: '25%'
      },
      {
        title: 'Desc_Email_Subject',
        key: 'subject',
        isSortable: true,
        width: '20%'
      }
      ,
      {
        title: 'Desc_Date',
        key: 'createdDate',
        isDate: true,
        isSortable: true,
        width: '20%'
      },
      {
        title: 'Desc_Status',
        key: 'status',
        isSortable: true,
        width: '10%'
      }
    ]
  };
  filter = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    searchText: '',
    customerId: -1,
    outletId: -1,
    dateRange: []
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  navLinks: any[];
  ngOnInit() {
    this.coreSession.SetTitle('Contact-Us');
    this.populateTable();
    this.prepareNavigation();
    this.TableData.rowOperations.push(
      {
        operation: RowOperation.View,
        title: 'Desc_View',
        icon: 'fa-regular fa-eye',
        color: "#12344d"
      });

    //this.setNavigation(this.navLinks[0]);
  }
  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_Customer_App_Feedback',
        index: 0,
        isActive: true,
      }
    ];
  }
  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.View:
        if (event && event.object) {
          this.feedbackReplyModule = event.object;
          this.showSlider = true;
          if(this.feedbackReplyModule.statusId === 1){
            this.isShowFooter = true;
          }else{
            this.isShowFooter = false;
          }
        }
        break;
    }
  }

  closeSlider() {
    this.showSlider = false;
  }

  onSaveClick() {
    this.saveSubject.next();
  }

  onTableFilterChanged(query: any) {
    this.filter.customListFilter = query;
    this.populateTable();
  }
  onReset() {
  }
  applySerachFilterOnFind(event) {
    if (event) {
      this.filter.customerId = event.customerId;
      this.filter.outletId = event.outletId;
      this.filter.dateRange = event.transactionDate;
      this.populateTable();
    }
  }

  populateTable() {
    this.coreSession.ModalLoading.Show();
    this.echoService.getContactUsList(this.filter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.dataSource = <SharedTableResult>response.data;
      } else {
        this.coreSession.showError(response.message, '');
      }
    },
      error => {
        this.coreSession.showError(ConstantMessages.ErrorHappened, '');
      });
  }
  onSaveCompleted(){
    this.closeSlider();
    this.populateTable();
  }
  ngOnDestroy() {
    this.navService.setNavigation([]);
  }
  onChangeSeletedTab(tab) {
    this.setNavigation(tab);
  }
  setNavigation(tab) {
    let navigationList: NavigationData[] = [];
    navigationList.push(
      {
        Name: 'Desc_Settings',
        URL: ConstantURLs.settingsURL
      },
      {
        Name: tab.label,
        URL: undefined
      }
    );
    this.navService.setNavigation(navigationList);
  }
}
