import { HttpErrorResponse } from '@angular/common/http';
import { Component, EventEmitter, Input, OnDestroy, OnInit, Output } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { TranslateService } from '@ngx-translate/core';
import { Observable } from 'rxjs/Rx';
import { MasterDataService } from '../../../content/master-data-definition/master-data.service';
import { CoreSession } from '../../../core/core.session';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../shared/models/constants/constant-configuration';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { DataActions } from '../../../shared/models/enums/data-actions.enum';
import { SharedTableResult } from '../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../shared/models/shared-table/table-properties.interface';
import { EchoService } from '../../echo.service';
import * as cloneDeep from 'lodash/cloneDeep';
import { RowOperation } from '../../../shared/models/enums/shared-table-operation.enum';

@Component({
  selector: 'app-cust-app-first-order-items-entry',
  templateUrl: './cust-app-first-order-items-entry.component.html',
  styleUrls: ['./cust-app-first-order-items-entry.component.css']
})
export class CustAppFirstOrderItemsEntryComponent implements OnInit {
  @Input() events: Observable<void>;
  @Output() onSaveCompleted = new EventEmitter();
  isCategoryCustomerAppMode : boolean = false;
  isBrandCustomerAppMode : boolean = false;
  saveBtnSubscription:any;
  addedItemsList: any[] = [];
  assignmentObj= {
    organizationId: -1,
    itemPacks: []
  }
  listOfAssignment: any =[];
  filterForm: FormGroup;
  itemForm: FormGroup;
  itemFilter = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    divisionId: -1,
    itemCategoryId: -1,
    brandId: -1,
    organizationId: -1,
  };
  selectedOrganizationId: number = -1;
  itemsDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  TableProperties: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    isMultiSelection: false ,
    rowOperations: [
      {
      operation: RowOperation.delete,
      title: 'Desc_Delete',
      icon: 'fa-solid fa-trash',
      color: '#f1685e'
      }],
    multiSelectionOperations: [],
    showSearchBtn: true,
    columns: [
      {
        title: 'Desc_Vendor',
        key: 'organizationCodeName',
        isSortable: true,
        width: '15%'
      },
      {
        title: 'Desc_Item_Name',
        key: 'itemName',
        isSortable: true,
        width: '11%'
      },
      {
        title: 'Desc_Item_Code',
        key: 'itemCode',
        isSortable: true,
        width: '11%'
      },
      {
        title: 'Desc_UOM',
        key: 'uom',
        isSortable: true,
        width: '10%'
      },
      {
        title: 'Desc_Category',
        key: 'category',
        isSortable: true,
        width: '11%'
      },
      {
        title: 'Desc_Division',
        key: 'divisionName',
        isSortable: true,
        width: '11%'
      },
      {
        title: 'Desc_Brand',
        key: 'brand',
        isSortable: true,
        width: '11%'
      },
      {
        title: 'Desc_Quantity',
        key: 'customerAppQuantity',
        isSortable: true,
        width: '11%',
        isEditable:true,
        numberOfStockDigits:true,
      }
    ]
  };
  organizationsList: any[] = [];
  organizationDropdownSettings = {
    singleSelection: false,
    idField: 'organizationId',
    textField: 'organizationCodeName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 1,
  };
  isItemLoading: boolean = false;
  itemData: any[] = [];
  selectedItemPack:any;
  constructor(private sessionData: SessionDataProvider,
    private coreSession: CoreSession,
    private echoService: EchoService,
    private translateService: TranslateService,
    private masterDataService: MasterDataService) { }

  ngOnInit(): void {
    this.organizationDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.organizationDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.organizationDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    this.isCategoryCustomerAppMode = this.sessionData.getConfigurationValue(ConstantConfigurations.CategoryBrandCustomerAppMode).toLowerCase().includes('1');
    this.isBrandCustomerAppMode = this.sessionData.getConfigurationValue(ConstantConfigurations.CategoryBrandCustomerAppMode).toLowerCase().includes('2');
    this.fillOrganizations();
    this.subscribeSaveClick();
    this.initFilterForm();
    this.initItemForm();
    this.populateItemDatasource();
    this.populateItemsSharedTable();
  }


  populateItemsSharedTable() {
      this.echoService.getEchoFirstOrderItems(this.itemFilter,true).subscribe(
        (response) => {
          if (response.status != null && response.status >= 0) {
            this.addedItemsList = response.data;
            this.itemsDataSource = {
              data: response.data,
              totalItems: response.data.length
            };
          } else {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              this.translateService.instant(ConstantMessages.ErrorHappened)
            );
          }
        },(error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      );
  }

  populateItemDatasource() {
    var filter = {
      customListFilter: {
        searchFilter: '',
        page: 0,
        pageSize: this.coreSession.pageSize
      },
      divisionId: -1,
      itemCategoryId: -1,
      brandId: -1,
      organizationId: -1,
    };

    filter.divisionId = this.itemForm.get('divisionId').value && this.itemForm.get('divisionId').value > 0?
      this.itemForm.get('divisionId').value : -1;
    filter.itemCategoryId = this.itemForm.get('itemCategoryId').value && this.itemForm.get('itemCategoryId').value > 0?
      this.itemForm.get('itemCategoryId').value : -1;
    filter.brandId = this.itemForm.get('brandId').value && this.itemForm.get('brandId').value > 0?
      this.itemForm.get('brandId').value : -1;

    this.isItemLoading = true;
    this.echoService.getEchoFirstOrderItems(filter).subscribe(
      (response) => {
        this.isItemLoading = false;
        if (response.status != null && response.status >= 0) {
          this.itemData = response.data;
        }
      },(error: HttpErrorResponse) => {
        this.isItemLoading = false;
      }
    );
  }

  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClicked();
    });
  }

  onSaveClicked() {
    this.coreSession.ModalLoading.Show();
    this.echoService.insertEchoFirstOrderItems(this.addedItemsList).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if(response.status != null && response.status >=0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
          this.onSaveCompleted.emit();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      },(error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
      );
  }
  initFilterForm() {
    this.filterForm = new FormGroup({
        divisionId: new FormControl(),
        itemCategoryId: new FormControl(),
        brandId: new FormControl(),
        organizationId: new FormControl(),
    });
  }

  initItemForm() {
    this.itemForm = new FormGroup({
      organizations: new FormControl([]),
      divisionId: new FormControl(),
      itemCategoryId: new FormControl(),
      brandId: new FormControl(),
      packId: new FormControl(),
      quantity: new FormControl(),
    });
  }

  onFind() {
    this.itemFilter.brandId = this.filterForm.get('brandId').value? this.filterForm.get('brandId').value : -1;
    this.itemFilter.itemCategoryId = this.filterForm.get('itemCategoryId').value? this.filterForm.get('itemCategoryId').value : -1;
    this.itemFilter.divisionId = this.filterForm.get('divisionId').value? this.filterForm.get('divisionId').value : -1;
    var result = this.addedItemsList.filter(
      (i) =>
      i.brandId === (this.itemFilter.brandId > -1? this.itemFilter.brandId : i.brandId ) &&
      i.itemCategoryId === (this.itemFilter.itemCategoryId > -1? this.itemFilter.itemCategoryId : i.itemCategoryId ) &&
      i.divisionId === (this.itemFilter.divisionId > -1? this.itemFilter.divisionId : i.divisionId )
    );

    this.itemsDataSource = {
      data: result,
      totalItems: result.length
    };
  }

  onClear() {
    this.filterForm.get('divisionId').reset();
    this.filterForm.get('itemCategoryId').reset();
    this.filterForm.get('brandId').reset();
  }

  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        var idx = this.addedItemsList.findIndex(addedItem =>
          addedItem.itemId === event.object.itemId
          &&
          addedItem.packId === event.object.packId
          &&
          addedItem.organizationId === event.object.organizationId);
          if(idx > -1) {
            this.addedItemsList.splice(idx, 1);
            this.itemsDataSource= {
              data: this.addedItemsList,
              totalItems: this.addedItemsList.length
            };
          }
        break;
    }
  }

  onEditItemQuantity(event) {
    if(event && event !== undefined) {
      event.object.dataAction = DataActions.Edit;

      var idx = this.addedItemsList.findIndex(addedItem =>
        addedItem.itemId === event.object.itemId
        &&
        addedItem.packId === event.object.packId
        &&
        addedItem.organizationId === event.object.organizationId);

        if(idx > -1) {
          this.addedItemsList[idx].customerAppQuantity = event.object.customerAppQuantity && event.object.customerAppQuantity.trim() !== ''?
          parseFloat(event.object.customerAppQuantity): 0;
          this.addedItemsList[idx].dataAction =  DataActions.Edit;
        } else {
          var numVal = event.object.customerAppQuantity && event.object.customerAppQuantity.trim() !== ''?
          parseFloat(event.object.customerAppQuantity): 0;
          event.object.customerAppQuantity = numVal;
          this.addedItemsList.push(event.object);
        }
    }
  }

  onTableFilterChanged(query) {
    this.itemFilter.customListFilter = query;
    if(this.selectedOrganizationId && this.selectedOrganizationId > -1) {
      // this.populateItems(true);
    }
  }

  // reflectAddedItemsOnUI() {
  //   this.itemsDataSource.data.map(item => {
  //     var idx = this.addedItemsList.findIndex(addeditem => addeditem.itemId === item.itemId &&
  //       addeditem.packId === item.packId);
  //     if(idx > -1) {
  //       item.customerAppQuantity = this.addedItemsList[idx].customerAppQuantity;
  //     }
  //   });
  // }

  onDivisionSelected(division) {
    this.filterForm.get('itemCategoryId').setValue(null);
    this.filterForm.get('brandId').setValue(null);
  }

  onCategorySelected(category) {
    this.filterForm.get('brandId').setValue(null);
  }

  onDivisionSelectedForItems(division) {
    this.itemForm.get('itemCategoryId').setValue(null);
    this.itemForm.get('brandId').setValue(null);
    this.itemForm.get('packId').setValue(null);

    this.populateItemDatasource();
  }

  onCategorySelectedForItems(category) {
    this.itemForm.get('brandId').setValue(null);
    this.itemForm.get('packId').setValue(null);

    this.populateItemDatasource();

  }

  onBrandSelectedItems(brand) {
    this.itemForm.get('packId').setValue(null);

    this.populateItemDatasource();
  }

  addItemClicked() {
    if( !this.itemForm.get('organizations').value
    || this.itemForm.get('organizations').value.length === 0 ) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.SelectOrganization)
      );
      return;
    }

    if( !this.itemForm.get('packId').value ||
    this.itemForm.get('packId').value < 0
    ) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgSelectItem)
      );
      return;
    }

    if( !this.itemForm.get('quantity').value ||
    this.itemForm.get('quantity').value < 0
    ) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgEnterQuantity)
      );
      return;
    }

    // this.addOrgItemsToSharedTable();
    this.addItemToList();
  }

  addItemToList() {
    var selectedQuantity = this.itemForm.get('quantity').value;
    var selectedOrgs = this.itemForm.get('organizations').value? this.itemForm.get('organizations').value : [];
    this.selectedItemPack.customerAppQuantity = selectedQuantity;
    this.selectedItemPack.dataAction = DataActions.Edit;

    selectedOrgs.forEach(org => {
      var i = this.addedItemsList.findIndex(i => i.itemId === this.selectedItemPack.itemId &&
        i.packId === this.selectedItemPack.packId &&
        i.organizationId === org.organizationId
        );
        if(i > -1) {
          this.addedItemsList[i].customerAppQuantity = selectedQuantity;
        } else {
          var pack = cloneDeep(this.selectedItemPack);
          pack.organizationId = org.organizationId;
          pack.organizationCodeName = org.organizationCodeName;
          this.addedItemsList.push(pack);
        }
    });

    this.fillItemsDatasource();
    this.clearForm();
  }

  fillItemsDatasource() {
    this.itemsDataSource = {
      data: this.addedItemsList,
      totalItems: this.addedItemsList.length
    }
  }

  clearForm() {
    this.itemForm.get('organizations').setValue([]);
    var organizationsList = cloneDeep(this.organizationsList);
    this.organizationsList  = [];
    this.organizationsList = organizationsList;

    this.itemForm.get('packId').setValue(null);
    this.selectedItemPack = null;

    this.itemForm.get('quantity').setValue(null);
    this.itemForm.get('divisionId').setValue(null);
    this.itemForm.get('brandId').setValue(null);
    this.itemForm.get('itemCategoryId').setValue(null);

    this.populateItemDatasource();
  }

  fillOrganizations() {
    this.masterDataService.getOrganizationList().subscribe(result => {
      this.organizationsList = result;
    });
  }

  onItemSelected(itemPack) {
    this.selectedItemPack = null;
    if(itemPack && itemPack != undefined) {
      this.selectedItemPack = itemPack;
    }
  }

  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
 }


}
