import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import { Observable } from 'rxjs';
import { CoreSession } from '../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { HttpErrorResponse } from '@angular/common/http';
import { EchoService } from '../../echo.service';
import { CustAppPropertiesModel } from '../../models/custAppProperties.model';
import { ResponseModel } from '../../../shared/models/api-models/api-models';
import { TextLanguage } from '../../../shared/models/general/textLanguage.model';

@Component({
  selector: 'app-cust-app-properties-entry',
  templateUrl: './cust-app-properties-entry.component.html',
  styleUrls: ['./cust-app-properties-entry.component.css']
})
export class CustAppPropertiesEntryComponent implements OnInit {

  @Input() events: Observable<void>;
  @Input() moduleId: number;
  @Output() onSaveCompleted = new EventEmitter();
  saveBtnSubscription: any;
  custPropObject: CustAppPropertiesModel = new CustAppPropertiesModel() ;

  constructor(private coreSession: CoreSession,
    private translateService: TranslateService,
    private echoService: EchoService) { }

  ngOnInit() {
    if (this.moduleId == 1)
      this.coreSession.SetTitle('About Us');
    else
      this.coreSession.SetTitle('Privacy Policy');
    this.custPropObject.aboutUsLanguages.push({
      languageId: 1,
      description: ''
    });
    this.custPropObject.aboutUsLanguages.push({
      languageId: 2,
      description: ''
    });
    this.custPropObject.privacyPolicyLanguages.push({
      languageId: 1,
      description: ''
    });
    this.custPropObject.privacyPolicyLanguages.push({
      languageId: 2,
      description: ''
    });
    this.subscribeSaveClick();
    this.getCustomerProperties();
  }

  initForm() {
  }

  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClicked();
    });
  }
  onSaveClicked() {
    this.saveCustomerProperties();
  }
  saveCustomerProperties() {
    this.echoService.saveCustomerProperties(this.custPropObject).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), response.message);
          this.onSaveCompleted.emit();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  getCustomerProperties() {
    this.echoService.getCustomerProperties().subscribe(
      (response: ResponseModel) => {
        if (response.status != null && response.status >= 0) {
          this.custPropObject = response.data;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
}
