import { HttpErrorResponse } from '@angular/common/http';
import { Component, EventEmitter, Input, OnDestroy, OnInit, Output } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { TranslateService } from '@ngx-translate/core';
import { Observable } from 'rxjs/Rx';
import { MasterDataService } from '../../../content/master-data-definition/master-data.service';
import { CoreSession } from '../../../core/core.session';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../shared/models/constants/constant-configuration';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { DataActions } from '../../../shared/models/enums/data-actions.enum';
import { SharedTableResult } from '../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../shared/models/shared-table/table-properties.interface';
import { EchoService } from '../../echo.service';
import * as cloneDeep from 'lodash/cloneDeep';
import { RowOperation } from '../../../shared/models/enums/shared-table-operation.enum';
import { ShepherdService } from 'angular-shepherd';
import { Router } from '@angular/router';
import { TourService } from '../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../shared/shepherd-config/trackTour.service';
@Component({
  selector: 'app-cust-app-settings-entry',
  templateUrl: './cust-app-settings-entry.component.html',
  styleUrls: ['./cust-app-settings-entry.component.css']
})
export class CustAppSettingsEntryComponent implements OnInit {
  customerAppSettingsDataForm: FormGroup = new FormGroup({});
  @Input() events: Observable<void>;
  @Output() onSaveCompleted = new EventEmitter();
  navLinks: any[];
  navBarSelectedIndex: number = 0;
  saveBtnSubscription: any;
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  TableProperties: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: false,
    showSearch: true,
    isOnline: false,
    isMultiSelection: false,
    showOptionPerLine: false,
    showEditButton: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      {
        title: 'Desc_Action_Name',
        key: 'viewName',
        isSortable: true,
        width: '50%'
      },
      {
        title: 'Desc_Value',
        key: 'keyValue',
        isSortable: false,
        width: '50%',
        isEditablePerRow: true
      },
    ]
  };
  customizeSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  CustomizeTabelProperties: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: false,
    showSearch: true,
    isOnline: false,
    isMultiSelection: false,
    showOptionPerLine: false,
    showEditButton: false,
    isAllowDragDrop: true,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      {
        title: 'Desc_Section_Name',
        key: 'sectionName',
        isSortable: true,
        width: '40%'
      },
      {
        title: 'Desc_Status',
        key: 'booleanValue',
        isSortable: false,
        width: '40%',
        isEditablePerRow: true
      },
      {
        title: 'Desc_Sequence',
        key: 'sequence',
        isSortable: true,
        width: '20%'
      }
    ]
  };
  settingsData: any[] = [];
  customizeData: any[] = [];
  constructor(private sessionData: SessionDataProvider,
    private coreSession: CoreSession,
    private echoService: EchoService,
    private translateService: TranslateService,
    private masterDataService: MasterDataService,
    private router:Router
  , private readonly shepherdService: ShepherdService,
  private tourService : TourService,
  private componentVisitService: ComponentVisitService
) { }

  ngOnInit() {
    this.populateSettingsSharedTable();
    this.populateCustomizeSharedTable();
    this.subscribeSaveClick();
    this.prepareNavigation();
    this.navLinks[0].isActive = true;
  }
  private tourStartTimeout: any;
  ngAfterViewInit() {
//     this.tourStartTimeout =  setTimeout((data=>{
//       const elementSelectors = ['#subject-def','#body-def','#browseImage-def','#browseVid-def'
// ,'#groups-def','#Customers-def'
//       ]
//       const titles = [];
//       const texts = [];
//       for (let index = 0; index < elementSelectors.length; index++) {
//         const { title, text } = this.getTitleAndText(index);
//         titles.push(title);
//         texts.push(text);
//       }
//       const steps = this.tourService.generateSteps(elementSelectors,titles,texts);
//       this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
//       this.shepherdService.modal = true;
//       this.shepherdService.addSteps(steps);
//       this.shepherdService.start();
//     }),3000)
  }
  getTitleAndText(index: number): { title: string, text: string } {
    let title = '';
    let text = '';

    switch (index) {
      case 0:
        title = "Let's go to define your item";
        text = 'Here you can define your items.';
        break;
      case 1:
        title = "Let's go to define your customer";
        text = "Here you can define your customer";
        break;
      case 2:
      case 3:
      case 4:
      case 5:
        title = `Step ${index + 1} Title`;
        text = `Step ${index + 1} Content`;
        break;
      default:
        title = `Step ${index + 1}`;
        text = `Content in defult at bottom.`;
    }

    return { title, text };
  }

  populateSettingsSharedTable() {
    this.echoService.getCustomerAppSettings().subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        this.dataSource = {
          data: response.data,
          totalItems: response.data.length
        };
      });
    (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(ConstantMessages.ErrorHappened, '');
    };
  }
  populateCustomizeSharedTable() {
    this.echoService.getCustomizeHomePage().subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        this.customizeSource = {
          data: response.data,
          totalItems: response.data.length
        };
        this.sortCustomizeHomePageArray();
      });
    (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(ConstantMessages.ErrorHappened, '');
    };
  }
  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_Settings',
        index: 0,
        isActive: false,
        hidden: false,
        disable: false
      },
      {
        label: 'Desc_Customize_Home_Page',
        index: 1,
        isActive: false,
        hidden: false,
        disable: false
      },
    ]
  }
  ChangeDataView(index: number) {

    this.navLinks.forEach(a => a.isActive = false);
    this.navBarSelectedIndex = index;
    this.navLinks[index].isActive = true;
  }

  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClick();
    });
  }

  onSaveClick() {
    var obj = {
      settingsList: this.settingsData,
      customizeList: this.customizeData
    }
    this.coreSession.ModalLoading.Show();
    this.echoService.UpdateCustomerAppSettings(obj).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        (response.status);
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption),
            this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
          this.onSaveCompleted.emit();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  onValueChanges(event: any) {
    if (event.object.keyValue == true || event.object.keyValue == false)
      event.object.keyValue = event.object.keyValue == true ? 1 : 0;
    let changedValue = event.object;
    if (!this.settingsData) { this.settingsData = []; }
    let index = this.settingsData.findIndex(a => a.actionName === changedValue.actionName);
    if (index > -1) {
      this.settingsData[index] = changedValue;
    } else {
      this.settingsData.push(changedValue);
    }
  }
  onCustomizeChanges(event: any) {
    let changedValue = event.object;
    if (!this.customizeData) { this.customizeData = []; }
    let index = this.customizeData.findIndex(a => a.sectionTypeId === changedValue.sectionTypeId);
    if (index > -1) {
      this.customizeData[index] = changedValue;
    } else {
      this.customizeData.push(changedValue);
    }
  }

  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.componentVisitService.markComponentVisited('cust-app-setting-entry');

  }

  onDragDrop(event: any) {
    var sequence = 1;
    this.customizeSource.data.forEach((x, index) => {
      x.sequence = sequence;
      sequence++;
    });
    this.sortCustomizeHomePageArray();
  }
  sortCustomizeHomePageArray() {
    this.customizeData = this.customizeSource.data.sort((a, b) =>
      a.sequence > b.sequence
        ? 1
        : a.sequence === b.sequence
          ? a.description > b.description
            ? 1
            : -1
          : -1
    );
    this.customizeSource = {
      data: this.customizeData,
      totalItems: this.customizeData.length,
    };
  }
}



