import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { Observable } from 'rxjs/Rx';
import { EchoService } from '../../echo.service';
import { CoreSession } from '../../../core/core.session';
import * as cloneDeep from 'lodash/cloneDeep';
import { SharedTableResult } from '../../../shared/models/shared-table/shared-table-result.interface';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { ITextInput } from '../../../shared/models/shared-table/custom-list.interface';
import { ITableProperties } from '../../../shared/models/shared-table/table-properties.interface';
import { MultiSelectionOperation, RowOperation } from '../../../shared/models/enums/shared-table-operation.enum';
import { CommonButtonStyles } from '../../../shared/models/enums/common-button-styles.enum';
import { TranslateService } from '@ngx-translate/core';
import { DialogMode } from '../../../shared/models/enums/dialog-mode.enum';
import { DialogResult } from '../../../shared/models/enums/dialog-result.enum';
import { ResponseModel } from '../../../shared/models/api-models/api-models';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantStorage } from '../../../shared/models/constants/constant-stroage';

@Component({
  selector: 'app-fqas-entry',
  templateUrl: './fqas-entry.component.html',
  styleUrls: ['./fqas-entry.component.css']
})
export class FQAsEntryComponent implements OnInit {
  @Input() events: Observable<void>;
  @Input() fQAsObject: any;
  saveBtnSubscription: any;

  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  fQAsTableData: ITableProperties = {
    pageSize: 10,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    showExport: false,
    isMultiSelection: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: []
  };
  questionInput: ITextInput = {
    formControlName: "questionInput",
    placeHolder: "Desc_QuestionFQAs",
    label: "Desc_QuestionFQAs",
    isTextArea: true,
    isRequierd: true
  };
  answerInput: ITextInput = {
    formControlName: "answerInput",
    placeHolder: "Desc_Answer",
    label: "Desc_Answer",
    isTextArea: true,
    isRequierd: true
  };

  buttonText = "Desc_Add";
  fQAsList: any [] = [];
  fQAsListLastId:number;
  questionOtherLanguages: any[] = [];
  answerOtherLanguages: any[] = [];
  allFQAs:any []= [];
  addedTable: any=[];
  sharedTbFqa: any = new Object();
  editQuestionLanguages: any[] = [];
  editAnswerLanguages: any[] = [];
  isEditMode: boolean = false;
  selectedRow:any;

  formFQAs: FormGroup;

  constructor(
    private echoService: EchoService,
    public coreSession: CoreSession,
    private translateService: TranslateService, ) {}

  ngOnInit() {
    this.initForm();
    this.populateFQAs();
    this.subscribeSaveClick();
    this.addActions();
    this.initTable();
  }
  addActions() {
      this.fQAsTableData.rowOperations.push({
      operation: RowOperation.delete,
      title: 'Desc_Delete',
      icon: 'fa-solid fa-trash',
      color: '#f1685e',
    });

    this.fQAsTableData.rowOperations.push({
      operation: RowOperation.edit,
      title: "Desc_Edit",
      icon: "fa-regular fa-pen-to-square",
      color: "#12344d"
    });

    // this.fQAsTableData.multiSelectionOperations.push({
    //   operation: MultiSelectionOperation.delete,
    //   title: 'Desc_Delete',
    //   icon: 'fa-solid fa-trash',
    //   color: '#f1685e',
    //   style: CommonButtonStyles.Negative.valueOf()
    // });
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClicked();
    });
  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
  }
  markasTouched() {
    this.formFQAs.get('questionInput').markAsTouched();
    this.formFQAs.get('answerInput').markAsTouched();
  }
  onSaveClicked() {
    if (this.dataSource.totalItems <= 0) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant("Desc_Must_Add_Question")
      );
    }
  for(let fqa of this.dataSource.data){
    this.allFQAs.push({
      id: fqa.id,
      question:fqa.question,
      answer:fqa.answer,
      questionDescriptionLanguages:[{
        description:fqa.questionDescriptionLanguages.description,
        languageId:fqa.questionDescriptionLanguages.languageId
      }],
      answerDescriptionLanguages:[{
        description:fqa.answerDescriptionLanguages.description,
        languageId:fqa.answerDescriptionLanguages.languageId
      }]
    })
  }
    this.echoService.InsertFQA(this.dataSource.data).subscribe(
      response => {
        this.onSaveSurveySuccess(response);
      }, (error: HttpErrorResponse) => {
        this.onSaveSurveyFailure(error);
      });;
  }
  initTable(){
      this.fQAsTableData.columns.push({
        title: 'Desc_QuestionFQAs',
        key: 'question',
        isSortable: false,
        width: '40%'
      })
      this.fQAsTableData.columns.push({
        title: 'Desc_Answer',
        key: 'answer',
        isSortable: false,
        width: '50%',
      })
  }
  onRowClicked(event: any) {
    switch (event.operation) {
      case RowOperation.edit:
        this.isEditMode = true;
        this.buttonText = 'Desc_Edit';
        this.editQuestionLanguages = null;
        this.editQuestionLanguages = event.object.questionDescriptionLanguages;

        this.editAnswerLanguages = null;
        this.editAnswerLanguages = event.object.answerDescriptionLanguages;
        this.formFQAs.get('questionInput').setValue(event.object.question);
        this.formFQAs.get('answerInput').setValue(event.object.answer);
        this.selectedRow = event;
        break;
      case RowOperation.delete:
          if (event.object && event.object != null) {
            this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation)
              , DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
                (result: DialogResult) => {
                  if (result === DialogResult.Yes) {
                    var x = this.fQAsList.findIndex(a => a === event.object);
                    this.fQAsList.splice(x, 1);
                    this.dataSource.data = this.fQAsList;
                    this.dataSource.totalItems = this.dataSource.totalItems -1;
                    // this.fQAsList = this.dataSource.data.slice();
                  }
                });
          }
        break;
    }
  }
  onSelectAll(event: any) {
    this.dataSource.data.forEach((element) => {
      element.isChecked = event;
    });
  }
  // onMultiSelectionOperationForFQAs(event: any) {
  //   debugger;
  //   switch (event.operation) {
  //     case MultiSelectionOperation.delete: {
  //                 if (event.object && event.object != null) {
  //           this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation)
  //             , DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
  //               (result: DialogResult) => {
  //                 if (result === DialogResult.Yes) {
  //                   event.object.forEach(fqa => {
  //                     var index = this.fQAsList.findIndex(x => x.id === fqa.id);
  //                     if (index >= 0) {
  //                       this.fQAsList.splice(index, 1);
  //                       this.dataSource.data = this.fQAsList;
  //                     }
  //                   });
  //                 }
  //               });
  //         }
  //       break;
  //     }
  //   }
  // }
  initForm() {
    this.formFQAs = new FormGroup({
      questionInput: new FormControl('', Validators.required),
      answerInput: new FormControl('', Validators.required)
    })
  }
  populateFQAs() {
    let fQAsFilter = {
      id: -1,
      question: '',
      answer: '',
      languageId: -1,
    };
    this.echoService.GetAllFQAs(fQAsFilter).subscribe(response => {
        if (response.status != null && response.status >= 0) {
          this.dataSource = <SharedTableResult>response.data;
          this.fQAsList = response.data.data;

          if(this.fQAsList && this.fQAsList.length > 0)
          this.fQAsListLastId = this.fQAsList[this.fQAsList.length -1].id;


        } else {
            this.coreSession.showError(response.message, '');
        }
    },
    error => {
      this.coreSession.showError(ConstantMessages.ErrorHappened, '');
    });
  }
  resetFqaValues() {
    this.formFQAs.get('questionInput').reset();
    this.formFQAs.get('answerInput').reset();
    this.buttonText = "Desc_Add";
    this.editQuestionLanguages = [];
    this.editAnswerLanguages = [];
    this.isEditMode = false;
  }
  onAddFqa() {
    if (this.formFQAs.invalid) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgFillMandatory)
      );
      return;
    }
    let fqa:any = new Object();
    // fqa.id = this.fQAsListLastId +1;
    fqa.id = -1;

    let questionDescription = cloneDeep(this.questionOtherLanguages);
    if (questionDescription.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      questionDescription.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.formFQAs.value.questionInput
      });
    }
    fqa.questionDescriptionLanguages = cloneDeep(questionDescription);

    let answerDescription = cloneDeep(this.answerOtherLanguages);
    if (answerDescription.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      answerDescription.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.formFQAs.value.answerInput
      });
    }
    fqa.answerDescriptionLanguages = cloneDeep(answerDescription);

    for(let desc of fqa.questionDescriptionLanguages){
      if(desc.languageId == +localStorage.LanguageId){
        fqa.question = desc.description;          }
    }

    for(let desc of fqa.answerDescriptionLanguages){
      if(desc.languageId == +localStorage.LanguageId){
        fqa.answer = desc.description;
      }
    }
    this.dataSource.data.push(fqa);
    this.dataSource.totalItems = this.dataSource.totalItems + 1;
    this.resetFqaValues();
  }
  onEditFqa() {
    if (this.formFQAs.invalid) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgFillMandatory)
      );
      return;
    }

    let editedFqa:any = new Object();

      var fqaIndex = this.dataSource.data.findIndex(x => x.id == this.selectedRow.object.id)
      if (fqaIndex > -1) {
        editedFqa.id = this.dataSource.data[fqaIndex].id;
      }

    let questionDescription = cloneDeep(this.questionOtherLanguages);
    if (questionDescription.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      questionDescription.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.formFQAs.value.questionInput
      });
    }
    editedFqa.questionDescriptionLanguages = cloneDeep(questionDescription);

    let answerDescription = cloneDeep(this.answerOtherLanguages);
    if (answerDescription.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      answerDescription.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.formFQAs.value.answerInput
      });
    }
    editedFqa.answerDescriptionLanguages = cloneDeep(answerDescription);

    for(let desc of editedFqa.questionDescriptionLanguages){
      if(desc.languageId == +localStorage.LanguageId){
        editedFqa.question = desc.description;
      }
    }

    for(let desc of editedFqa.answerDescriptionLanguages){
      if(desc.languageId == +localStorage.LanguageId){
        editedFqa.answer = desc.description;
      }
    }

    this.dataSource.data[fqaIndex] = editedFqa;
    this.resetFqaValues();
  }
  onSaveSurveySuccess(response: any) {
    if (response.status != null && response.status >= 0) {
      this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption),
        this.translateService.instant(response.message),
      );
    } else {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
    }
  }
  onSaveSurveyFailure(error: HttpErrorResponse) {
    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
  }
  onQuestionOtherLanguagesTextSubmitted(event) {
    this.questionOtherLanguages = event;
  }
  onAnswerOtherLanguagesTextSubmitted(event) {
    this.answerOtherLanguages = event;
  }
}
