import { Component, OnInit, EventEmitter, Input, Output, } from "@angular/core";
import { FormGroup, FormControl, Validators } from "@angular/forms";
import { Observable } from "rxjs/Rx";
import { HttpErrorResponse } from "@angular/common/http";
import { SharedTableResult } from "../../../../shared/models/shared-table/shared-table-result.interface";
import { CoreSession } from "../../../../core/core.session";
import { ConstantMessages } from "../../../../shared/models/constants/constant-message";
import { TranslateService } from "@ngx-translate/core";
import { EchoService } from "../../../echo.service";

@Component({
    selector: "app-organization-details-entry",
    templateUrl: "./organization-details-entry.component.html",
    styleUrls: ["./organization-details-entry.component.css"],
})
export class OrganizationDetailsEntryComponent implements OnInit {
    @Input() saveEvent: Observable<void>;
    @Input() organizationDetailsObject: any = new Object();
    @Output() onSaveCompleted = new EventEmitter();
    @Input() isEditMode: boolean = false;
    @Input() isViewMode = false;
    organizaionList: any[] = [];
    organizationId = null;
    isOrganizationLoading: boolean = false;
    dataSource: SharedTableResult = {
        totalItems: 0,
        data: [],
    };
    myForm: FormGroup;
    constructor(
        private echoService: EchoService,
        public coreSession: CoreSession,
        private translateService: TranslateService,
    ) {
    }

    ngOnInit() {
        this.initForm();
        this.fillOrganizationList();
    }

    initForm() {
        this.myForm = new FormGroup({
            organizationID: new FormControl(({ value: this.isEditMode ? this.organizationDetailsObject.organizationID : null, disabled: this.isEditMode || this.isViewMode }), Validators.required),
            email: new FormControl({ value: this.isEditMode ? this.organizationDetailsObject.email : null, disabled: this.isViewMode }, [Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]),
        });
    }
    fillOrganizationDetailsObject() {
        this.organizationDetailsObject = new Object();
        this.organizationDetailsObject.organizationID = this.myForm.get('organizationID').value ? this.myForm.get('organizationID').value : -1;
        this.organizationDetailsObject.email = this.myForm.get('email').value ? this.myForm.get('email').value : '';
    }
    ngOnDestroy() {

    }
    public markFormGroupTouched(formGroup: FormGroup) {
        (<any>Object).values(formGroup.controls).forEach((control) => {
            control.markAsTouched();

            if (control.controls) {
                this.markFormGroupTouched(control);
            }
        });
    }

    fillOrganizationList() {
        this.coreSession.ModalLoading.Show();
        this.echoService.getOrganizationListOrganizationDetails(this.isEditMode).subscribe(
            response => {
                this.coreSession.ModalLoading.Hide();
                if (response.status != null && response.status >= 0) {
                    this.organizaionList = response.data;
                } else {
                    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
                }
            },
            (error: HttpErrorResponse) => {
                this.coreSession.ModalLoading.Hide();
                this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
            }
        );
    }
    onSaveAndNew() {
        this.SaveOrganizationDetails(false);
        this.fillOrganizationList();
    }
    onSaveAndClose() {
        this.SaveOrganizationDetails(true);
    }
    SaveOrganizationDetailsToDB(close: boolean) {
        this.coreSession.ModalLoading.Show();
        this.echoService.InsertOrganizationDetails(this.organizationDetailsObject).subscribe(
            result => {
                this.coreSession.ModalLoading.Hide();
                if (result.status != null && result.status >= 0) {
                    this.onSaveCompleted.emit(close);
                    this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
                    if (!close)
                        this.clearControls();
                } else {
                    this.coreSession.ModalLoading.Hide();
                    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), result.message);
                }
            });
    }
    UpdateOrganizationDetailsInDB(close: boolean) {
        this.coreSession.ModalLoading.Show();
        this.echoService.updateOrganizationDetails(this.organizationDetailsObject).subscribe(
            (response) => {
                this.coreSession.ModalLoading.Hide();
                if (response.status != null && response.status >= 0) {
                    this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
                    this.onSaveCompleted.emit(close);
                } else {
                    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
                }
            }, (error: HttpErrorResponse) => {
                this.coreSession.ModalLoading.Hide();
                this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorCaption));
            }
        );
    }
    SaveOrganizationDetails(close: boolean) {
        if (this.myForm.invalid) {
            this.coreSession.markFormGroupTouched(this.myForm);
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
            return;
        }
        this.fillOrganizationDetailsObject();
        if (!this.isEditMode) {
            this.SaveOrganizationDetailsToDB(close);
        }
        else {
            this.UpdateOrganizationDetailsInDB(close);
        }
    }

    clearControls() {
        this.myForm.get("organizationID").setValue(null);
        this.myForm.get("email").setValue(null);
    }
    get Email() {
        return this.myForm.get('email')
    }
}



