import {AfterViewInit, Component, forwardRef, Input, OnInit, ViewChild} from '@angular/core';
import {NG_VALUE_ACCESSOR} from '@angular/forms';
import Quill from 'quill';
import {QuillEditorComponent} from 'ngx-quill';

@Component({
  selector: 'app-html-entry',
  providers: [
    {
        provide: NG_VALUE_ACCESSOR,
        useExisting: forwardRef(() => HtmlEntryComponent),
        multi: true
    }
],
  templateUrl: './html-entry.component.html',
  styleUrls: ['./html-entry.component.css']
})
export class HtmlEntryComponent implements OnInit, AfterViewInit  {
  @ViewChild(QuillEditorComponent, {static: true}) editor: QuillEditorComponent;
  @Input('value') val: string;
  @Input() name: string;
  icons = Quill.import('ui/icons');
  modules: any;

  @Input('customDropDowns') customDropDowns: CustomDropDown[];

  @Input('addedToolbarsContainer') addedToolbarsContainer: string[];

  onChangeModel(event) {
  }

  onChange: any = () => {
  };
  onTouched: any = () => {
  };

  constructor() { }

  ngOnInit() {
    this.modules = {
        toolbar: {
            container: [
                ['bold', 'italic', 'underline', 'strike'],        // toggled buttons
                [{'color': []}, {'background': []}],          // dropdown with defaults from theme
                [{'list': 'ordered'}, {'list': 'bullet'}],
                [{'align': []}],
                [{'size': ['small', false, 'large', 'huge']}],  // custom dropdown
                [{'header': [1, 2, 3, 4, 5, 6, false]}],
                [{'font': []}],
                ['link'],
                ['blockquote'],              // custom button values
                [{'direction': 'rtl'}],                         // text direction
                ['undo'],
                ['redo'],
                ['clean'],
                this.addedToolbarsContainer
            ],
            history: {
                delay: 2000,
                userOnly: true
            },
            handlers: {
                undo: function (value) {
                    this.quill.history.undo();
                },
                redo: function (value) {
                    this.quill.history.redo();
                }
            }
        }
    };

    if (this.customDropDowns && this.customDropDowns.length > 0) {
        for (let i = 0; i < this.customDropDowns.length; i++) {
            let options = [];
            for (let j = 0; j < this.customDropDowns[i].options.length; j++) {
                options.push(this.customDropDowns[i].options[j].text);
            }
            let containerObj = {};
            containerObj[this.customDropDowns[i].key] = options;
            this.modules.toolbar.container.unshift([containerObj]);
            let thisObj = this;
            this.modules.toolbar.handlers[this.customDropDowns[i].key] = function (value: any) {
                if (value) {
                    let index = thisObj.customDropDowns[i].options.findIndex(item => item.text == value);
                    value = thisObj.customDropDowns[i].options[index].id;
                    const cursorPosition = this.quill.getSelection().index;
                    this.quill.insertText(cursorPosition, value);
                    thisObj.value = this.quill.root.innerHTML;
                    this.quill.setSelection(cursorPosition + value.length);
                }
            };
        }
    }


    this.icons['undo'] = `<svg viewbox="0 0 18 18">
                <polygon class="ql-fill ql-stroke" points="6 10 4 12 2 10 6 10"></polygon>
                <path class="ql-stroke" d="M8.09,13.91A4.6,4.6,0,0,0,9,14,5,5,0,1,0,4,9"></path>
             </svg>`;
    this.icons['redo'] = `<svg viewbox="0 0 18 18">
                <polygon class="ql-fill ql-stroke" points="12 10 14 12 16 10 12 10"></polygon>
                <path class="ql-stroke" d="M9.91,13.91A4.6,4.6,0,0,1,9,14a5,5,0,1,1,5-5"></path>
             </svg>`;
}

ngAfterViewInit(): void {
    if (this.customDropDowns && this.customDropDowns.length > 0) {
        for (let i = 0; i < this.customDropDowns.length; i++) {
            const pickerItems = Array.prototype.slice.call(document.querySelectorAll('.ql-' + this.customDropDowns[i].key + ' .ql-picker-item'));
            pickerItems.forEach(item => item.textContent = item.dataset.value);
            document.querySelector('.ql-' + this.customDropDowns[i].key + ' .ql-picker-label').innerHTML
                = this.customDropDowns[i].placeholder + document.querySelector('.ql-' + this.customDropDowns[i].key + ' .ql-picker-label').innerHTML;
        }
    }
}


get value() {
    return this.val;
}

set value(val) {
    this.val = val;
    this.onChange(val);
    this.onTouched();
}

registerOnChange(fn) {
    this.onChange = fn;
}

registerOnTouched(fn) {
    this.onTouched = fn;
}

writeValue(value) {
    this.value = value;
}
}

export interface CustomDropDown {
key: string;
placeholder: string;
options: CustomDropDownOptions[];
}

export interface CustomDropDownOptions {
id: string;
text: string;
}
