import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { SharedTableResult } from '../../../models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../models/shared-table/table-properties.interface';
import { Observable } from 'rxjs';
import { CoreSession } from '../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../models/constants/constant-message';
import { DialogMode } from '../../../models/enums/dialog-mode.enum';
import { DialogResult } from '../../../models/enums/dialog-result.enum';
import { SerialsPropertiesInterface } from '../serials-properties.interface';
import { RowOperation } from '../../../models/enums/shared-table-operation.enum';

@Component({
  selector: 'app-serials-summary',
  templateUrl: './serials-summary.component.html',
  styleUrls: ['./serials-summary.component.css']
})
export class SerialsSummaryComponent implements OnInit {

  @Input() serialsProperties: SerialsPropertiesInterface;
  @Input() addedSerialsForAllPacks = [];
  @Input("addedSerialsList") addedSerialsList: any[] = [];
  @Input() events: Observable<void>;
  @Output() onSaveCompleted = new EventEmitter();
  saveBtnSubscription: any;
  addedSerialsCount = 0;

  sertailsListDataSource: SharedTableResult = {
    totalItems: 0,
    data: [],
  };
  sertailsTableData: ITableProperties = {
    pageSize: 25,
    showPaginator: false,
    showSearch: false,
    isOnline: false,
    showSearchBtn: false,
    showEditButton: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      { title: "Desc_Serial_No", key: "fromSerial", isSortable: false },
      { title: "Desc_Customer_Code_Name", key: "customerCodeName", isSortable: false },
      { title: "Desc_Outlet_Code_Name", key: "outletCodeName", isSortable: false },
      { title: "Desc_UOM", key: "uom", isSortable: false },
      { title: "Desc_BatchNo", key: "batchNo", isSortable: false },
      { title: "Desc_ExpiryDate", key: "expiryDate", isSortable: false, isExpiryDate: true, },
    ],
  };


  constructor(public coreSession: CoreSession,
    private translateService: TranslateService,) { }

  ngOnInit() {
    this.fillSerialsTable();
    this.saveBtn();
    this.addRowOptionsForSharedTable();
  }

  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
  }
  addRowOptionsForSharedTable() {
    this.sertailsTableData.rowOperations.push(
      {
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e",
      },);
  }
  fillSerialsTable() {
    this.sertailsListDataSource = {
      data: this.addedSerialsList,
      totalItems: this.addedSerialsList.length
    }
  }
  removeSerial(item: any) {
        if (!item.childs || item.childs.length === 0) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then((result: DialogResult) => {
        if (result === DialogResult.Yes) {
          this.deleteSerial(item.fromSerial);
        }
      });
    } else {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.Desc_Confirmation_Delete_Serial_And_Sub), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then((result: DialogResult) => {
        if (result === DialogResult.Yes) {
          this.deleteSerial(item.fromSerial);
        }
      });
    }
  }
  deleteSerial(serial: string) {
    let index = this.addedSerialsList.findIndex((x) => x.fromSerial === serial);
    if (index > -1) {
      this.addedSerialsList.splice(index, 1);
    }
    index = this.addedSerialsForAllPacks.findIndex((x) => x.fromSerial === serial);
    if (index > -1) {
      this.addedSerialsForAllPacks.splice(index, 1);
    }
  }
  saveBtn() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClicked();
    });
  }
  onSaveClicked() {
    this.fillAddedSerialsCount(null);
    if (this.serialsProperties.packObj.isFOCItem) {
      this.serialsProperties.packObj.addedFOCSerials = this.addedSerialsList;
    } else {
      this.serialsProperties.packObj.addedSerials = this.addedSerialsList;
    }
    if (this.serialsProperties.packObj.isFOCItem) {
      this.serialsProperties.packObj.requiredFOCQty = this.addedSerialsCount;
    } else {
      this.serialsProperties.packObj.requiredQty = this.addedSerialsCount;
    }
    this.onSaveCompleted.emit(this.serialsProperties.packObj);
  }
  fillAddedSerialsCount(item: any) {
    this.addedSerialsCount = 0;
    if (this.addedSerialsList && this.addedSerialsList.length > 0) {
      this.addedSerialsCount = this.addedSerialsList.length;
    }

  }
  onRowClicked(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.removeSerial(event.object);
    }
  }
}
