import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { EntryFormTypes } from '../../../models/enums/entry-form-types.enum';
import { CustomerClassModel, CustomerSubClassModel } from '../../../models/customer/customer-class.model';
import { Observable } from 'rxjs';
import { CustomerService } from '../../../services/data-definition/customer/customers.service';
import { CoreSession } from '../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../models/constants/constant-message';
import { ITextInput } from '../../../models/shared-table/custom-list.interface';

@Component({
  selector: 'app-entry-form',
  templateUrl: './entry-form.component.html',
  styleUrls: ['./entry-form.component.css']
})
export class EntryFormComponent implements OnInit {

  parentForm: FormGroup;
  @Input() isEditMode = false;
  @Input() isViewMode = false;
  @Input() entryFormType: EntryFormTypes;
  @Output() onAddingNewCustomerClass = new EventEmitter();
  @Input() saveEvent: Observable<void>;
  saveBtnSubscription: any;
  otherLanguagess: any[] = [];
  customerNameInput: ITextInput = {
    formControlName: "customerName",
    placeHolder: "Desc_Name",
    label: "Desc_Name",
    isRequierd: true,
  };
  constructor(private customerService: CustomerService, public coreSession: CoreSession, private translateService: TranslateService,) { }

  ngOnInit() {
    this.subscribeSaveClick();
    this.parentForm = new FormGroup({
      code: new FormControl("",Validators.required),
      customerName:new FormControl("",Validators.required)
    });
  }
  onOtherLanguagesTextSubmitted(event: any){
    this.otherLanguagess = event;
    ;
  }
  addNewCustomerClass() {
     var customerClass = new CustomerClassModel();
    customerClass.customerClassName = this.parentForm.value.customerName;
  customerClass.customerClassCode = this.parentForm.value.code;
  if (this.otherLanguagess.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
    this.otherLanguagess.push({
      languageId: this.coreSession.selectedLanguageId,
      description: this.parentForm.value.customerName
    });
  }
  customerClass.descriptionLanguages = this.otherLanguagess;
    if (customerClass.customerClassName != null && customerClass.customerClassName != ''
      && customerClass.customerClassCode != null && customerClass.customerClassCode != '') {
      this.customerService.InsertNewCustomerClass(customerClass).subscribe(result => {
        customerClass = result.data;
        this.onAddingNewCustomerClass.emit(customerClass.customerClassId);

      });
    } else {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      this.markAsTouched();
    }
  }
  addNewCustomerSubClass() {
     var customerSubClass = new CustomerSubClassModel();
    customerSubClass.customerSubClassName = this.parentForm.value.customerName;
    customerSubClass.customerSubClassCode = this.parentForm.value.code;
    if (this.otherLanguagess.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      this.otherLanguagess.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.parentForm.value.customerName
      });
    }
    customerSubClass.descriptionLanguages = this.otherLanguagess;
    if (customerSubClass.customerSubClassName != null && customerSubClass.customerSubClassName != ''
      && customerSubClass.customerSubClassCode != null && customerSubClass.customerSubClassCode != '') {
      this.customerService.InsertNewCustomerSubClass(customerSubClass).subscribe(result => {

        customerSubClass = result.data;
        this.onAddingNewCustomerClass.emit(customerSubClass.customerSubClassId);

      });
    } else {
      this.markAsTouched();
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
    }
  }

  markAsTouched() {
    this.parentForm.get("code").markAsTouched();
    this.parentForm.get("customerName").markAsTouched();
  }
  addNew() {
    switch (this.entryFormType) {
      case EntryFormTypes.CustomerClass:
        this.addNewCustomerClass();
        break;
      case EntryFormTypes.CustomerSubClass:
        this.addNewCustomerSubClass();
        break;
    }
  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
  }

  subscribeSaveClick() {
    this.saveBtnSubscription = this.saveEvent.subscribe(() => {
      this.addNew();
    });
  }

}
