import { Injectable } from "@angular/core";

@Injectable({
  providedIn: "root"
})
export class BatchService {
  constructor() {}

  updateItemBatches(allPacks: any[], currentPack: any): any {
    allPacks
      .filter(
        a => a.itemId == currentPack.itemId && a.packId != currentPack.packId
      )
      .forEach(pack => {
        pack.itemStockBatches.forEach(batch => {
          let index = currentPack.itemStockBatches.findIndex(
            i => i.batchNo === batch.batchNo && i.expiryDate == batch.expiryDate
          );
          if (index != -1) {
            batch.availableQtyInPcs =  batch.actualAvailableQtyInPcs
            batch.availableQtyInPcs -= (currentPack.itemStockBatches[index].requiredQty * currentPack.piecesInPack);
          }
        });
      });

  }
}
