import { Component, OnInit, Input, Output, EventEmitter, OnDestroy, ViewChild, OnChanges } from '@angular/core';
import { FormGroup, FormControl } from '@angular/forms';
import { SharedTableResult } from '../../../models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../models/shared-table/table-properties.interface';
import { CoreSession } from '../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { CustomerService } from '../../../services/data-definition/customer/customers.service';
import { ConstantMessages } from '../../../models/constants/constant-message';
import { HttpErrorResponse } from '@angular/common/http';
import { Observable } from 'rxjs';
import { DialogResult } from '../../../models/enums/dialog-result.enum';
import { NgbModal, NgbModalConfig } from '@ng-bootstrap/ng-bootstrap';
import { CustomerSelectionLevel } from '../../../models/enums/customer-selection-level.enum';
import { GeolocationService } from '../../../services/geolocation.service';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../models/constants/constant-configuration';
import { DialogMode } from '../../../models/enums/dialog-mode.enum';
import * as cloneDeep from 'lodash/cloneDeep';
import { MultiSelectionOperation, RowOperation } from '../../../models/enums/shared-table-operation.enum';
import { rejects } from 'assert';
import { CommonButtonStyles } from '../../../models/enums/common-button-styles.enum';

@Component({
  selector: 'app-select-customers',
  templateUrl: './select-customers.component.html',
  styleUrls: ['./select-customers.component.css']
})
export class SelectCustomersComponent implements OnInit, OnChanges, OnDestroy {

  @ViewChild('selectCustomerDialog', { static: true }) selectCustomerDialog: any;
  OkResult: DialogResult = DialogResult.Ok;

  @Input() currentId = 'customerSelection';
  @Input() addedCustomersList: any[] = [];
  @Input() isFromPayerAccountScreen : boolean = false;
  @Input() customerSelectionLevel = CustomerSelectionLevel.OutletLevel;
  @Input() showDefault: boolean = false;
  @Input() isSalesRestrictionCustomers: boolean = false;
  @Input() isPromotions: boolean = false;
  @Input() channelId: number = -1;
  @Input() subChannelId: number = -1;
  @Input() groupId: number = -1;
  @Input() isConflectCustomer = false
  @Input() disableCustomerGroup = false;
  @Input() fillCustomerOrganizationIds: boolean = false;
  @Input() fillCustomerSDCIds: boolean = false;
  @Input() sdcIdsList: number[] = [];
  @Input() isTerritory: boolean = false;
  @Input() isDismissible: boolean = false;
  @Input() achievementCustomerList: any[] = [];
  @Input() isEditTargetPromotion: boolean = false;
  @Input() overwriteAddedCustomersList: boolean = false
  @Input() title = 'Desc_Select_Customer';
  @Input() hideAddedCustomers: boolean = false;
  @Output() customersOnOrganizationsSelected = new EventEmitter();
  @Output() saveEvent = new EventEmitter();
  @Output() removeCustomerapplied = new EventEmitter();
  @Output() viewCustomerConflect = new EventEmitter();


  @Input() customerSelectionInOfflineMode: boolean = false;

  addedExcludeCustomerPromotionList: any[] = [];
  selectedOraganizationIds = '';
  customerCodeNames: string = '';
  isValid = true;
  isCustomerOutletDivisionHasRecords: boolean = false;
  query;
  public customerFilterForm: FormGroup;

  sharedTabelData: ITableProperties = {
    pageSize: 100,
    showPaginator: true,
    isOnline: true,
    showSearch: true,
    // showSearchBtn: true,
    isMultiSelection: true,
    showEditButton: false,
    rowOperations: [],
    multiSelectionOperations: [],
    specificActionWhenCheckAll: true,
    specificActionWhenCheckRow: true,
    columns: [
      { title: 'Desc_Customer', key: 'customerCodeName', isSortable: true, },
      { title: 'Desc_Outlet', key: 'outletCodeName', isSortable: true,  },
      { title: 'Desc_Phone', key: 'phone', isSortable: true,  },
      { title: 'Desc_Address', key: 'address', isSortable: true,  }
    ]
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  outletsFilter: any = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: 100
    },
    customerGroupId: -1,
    customerClassId: -1,
    territoryId: -1,
    selectedOraganizationIds: '',
    channelId: -1,
    subChannelId: -1,
    routeId: -1,
    customerTypeId: -1,
    showDefault: false,
    isCustomerOutletDivisionHasRecords: false
  }
  excludedCustomers: any[] = [];

  dataList: any[] = [];
  enableSalesDistributionChannel: boolean = false;
  constructor(
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private customerService: CustomerService,
    private config: NgbModalConfig,
    private modalService: NgbModal,
    private locationService: GeolocationService,
    private sessionData: SessionDataProvider,
  ) {
    this.config.backdrop = true;
    this.config.keyboard = true;
  }
  ngOnInit() {
    if (this.isDivisionLevel()) {
      this.checkCustomerOutletDivisionIsExist();
    }


    this.enableSalesDistributionChannel = this.sessionData.getConfigurationValue(ConstantConfigurations.EnableSalesDistributionChannel).toLowerCase() === "true"
  }
  ngOnChanges() {
    this.initFilterForm()

  }
  approveCustomerList:any[]=[];
  rejectCustomerList: any[]=[];

  onMultiSelectionOperation(event: any) {

    switch (event.operation) {
      case MultiSelectionOperation.delete: {
        this.onDeleteMultiCustomersClick(event.object);
        break;
      }
      case MultiSelectionOperation.approve: {
        this.onApproveCustomersClicked(event.object);
        break;
      }
    }
  }
  onDeleteMultiCustomersClick(dataCustomer:any){
    dataCustomer.forEach(customerReject => {
      this.rejectCustomerList.push(customerReject)
      var index = this.dataSource.data.findIndex(customer=>customer.customerId==customerReject.customerId)
      if(index>-1)
        this.dataSource.data.splice(index,1)
    });
  }
  onApproveCustomersClicked(dataCustomer){
    dataCustomer.forEach(customerReject => {
      this.approveCustomerList.push(customerReject)
      var index = this.dataSource.data.findIndex(customer=>customer.customerId==customerReject.customerId)
      if(index>-1)
        this.dataSource.data.splice(index,1)
    });
        }


  onRowClicked(event: any) {

    switch (event.operation) {
      case RowOperation.delete:
        this.rejectCustomerList.push(event.object)
        this.dataSource.data.splice(event.index,1)
               break;
      case RowOperation.approve:
        this.approveCustomerList.push(event.object)
        this.dataSource.data.splice(event.index,1)
        break;
        case RowOperation.View:
        this.viewCustomerConflect.emit(event.object)
        break;
    }
  }
  ngOnDestroy() {
    this.config.backdrop = true;
    this.config.keyboard = true;
  }
  initFilterForm() {
    this.customerFilterForm = new FormGroup({
      customerGroupId: new FormControl({ value: null, disabled: this.disableCustomerGroup }),
      customerClassId: new FormControl(null),
      channelId: new FormControl(null),
      subChannelId: new FormControl(null),
      territoryId: new FormControl(null),
      routeId: new FormControl(null),
      customerTypeId: new FormControl(null),
      divisionId: new FormControl(null),
      country: new FormControl(null),
      state: new FormControl(null),
      city: new FormControl(null),
      area: new FormControl(null),
      street: new FormControl(null),
      sdcId: new FormControl
    });
  }
  populateCustomers(isFromSearchFilter: boolean = false) {
    if ((this.dataList && this.dataList.length > 0) && !isFromSearchFilter) {
      this.dataSource = {
        totalItems: 0,
        data: []
      };
      this.sharedTabelData.isOnline = false;
      var data = {
        data: this.dataList,
        totalItems: this.dataList.length
      };
      this.reflectAddedBeforeCustomers(data);
    } else {
      this.outletsFilter.customerGroupId = (!this.customerGroupInput.value || this.customerGroupInput.value === null) ? -1 : this.customerGroupInput.value;
      this.outletsFilter.customerClassId = (!this.customerClassInput.value || this.customerClassInput.value === null) ? -1 : this.customerClassInput.value;
      this.outletsFilter.channelId = (!this.customerChannelInput.value || this.customerChannelInput.value === null) ? -1 : this.customerChannelInput.value;
      this.outletsFilter.subChannelId = (!this.customerSubChannelInput.value || this.customerSubChannelInput.value === null) ? -1 : this.customerSubChannelInput.value;
      this.outletsFilter.territoryId = (!this.territoryIdInput.value || this.territoryIdInput.value === null) ? -1 : this.territoryIdInput.value;
      this.outletsFilter.routeId = (!this.routeIdlInput.value || this.routeIdlInput.value === null) ? -1 : this.routeIdlInput.value;
      this.outletsFilter.customerTypeId = (!this.customerTypeIdInput.value || this.customerTypeIdInput.value === null) ? -1 : this.customerTypeIdInput.value;
      this.outletsFilter.selectedOraganizationIds = this.selectedOraganizationIds ? this.selectedOraganizationIds.toString() : '';
      this.outletsFilter.showDefault = this.showDefault ? this.showDefault : false;
      this.outletsFilter.getAllData = false;
      this.outletsFilter.fillCustomerOrganizationIds = this.fillCustomerOrganizationIds;
      this.outletsFilter.fillCustomerSDCIds = this.fillCustomerSDCIds;
      this.outletsFilter.excludedCustomers = this.excludedCustomers;
      this.outletsFilter.sdcIdsList = this.sdcIdsList;
      this.outletsFilter.sdcId = this.sdcIdInput && this.sdcIdInput.value ? this.sdcIdInput.value : -1;
      this.outletsFilter.isCustomerOutletDivisionHasRecords = this.isCustomerOutletDivisionHasRecords;
      this.outletsFilter.isFromPayerAccountScreen = this.isFromPayerAccountScreen;
      this.outletsFilter.isFromTerritoryScreen = this.customerSelectionInOfflineMode;
      if (this.isSalesRestrictionCustomers || this.isPromotions) {
        this.prepareOutletsFilter();
      }
      if(this.customerSelectionInOfflineMode){
        this.sharedTabelData.isOnline = false;
      } else {
        this.sharedTabelData.isOnline = true;
      }
      this.coreSession.ModalLoading.Show();
      if (this.customerSelectionLevel === CustomerSelectionLevel.OutletLevel) {
        this.customerService.getOutletsListSharedTable(this.outletsFilter).subscribe(response => {

          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            if ((this.dataList && this.dataList.length > 0) && isFromSearchFilter) {
              var resData = response.data && response.data.data ? response.data.data : [];
              var data = this.dataList.filter(c => resData.some(d => d.customerId === c.customerId && d.outletId === c.outletId));
              var ds = {
                data: data,
                totalItems: data.length
              };
              this.reflectAddedBeforeCustomers(ds);
            } else {
              this.reflectAddedBeforeCustomers(response.data);
            }
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        }, (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        });
      } else {
        this.customerService.getCustomersListSharedTable(this.outletsFilter).subscribe(response => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            this.reflectAddedBeforeCustomers(response.data);
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        }, (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        });
      }
    }
  }
  reflectAddedBeforeCustomers(dataSource) {

    if(this.isConflectCustomer){
      this.sharedTabelData.isMultiSelection = true;
      if(this.sharedTabelData.rowOperations.length!=3 && this.sharedTabelData.multiSelectionOperations.length !=2){
        this.sharedTabelData.rowOperations.push({
          operation: RowOperation.delete,
          title: "Desc_Reject",
          icon: "fa-solid fa-trash",
          color: "#f1685e",
        });
        this.sharedTabelData.rowOperations.push({
          operation: RowOperation.approve,
          title: "Desc_Order_Approve",
          icon: "fa-solid fa-check",
          color: "#02b875"
        });
        this.sharedTabelData.multiSelectionOperations.push({
          operation: MultiSelectionOperation.delete,
          title: 'Desc_Reject',
          icon: 'fa-solid fa-trash',
          color: '#f1685e',
          style: CommonButtonStyles.Negative.valueOf()
        })
        this.sharedTabelData.multiSelectionOperations.push({
          style: CommonButtonStyles.Success.valueOf(),
          operation: MultiSelectionOperation.approve,
          title: "Desc_Approve",
          icon: "fa-solid fa-check",
          color: "#02b875"
        });
        this.sharedTabelData.rowOperations.push(
          {
              operation: RowOperation.View,
              title: "Desc_View",
              icon: "fa-regular fa-eye",
              color: "#12344d"
          });
      }
        this.sharedTabelData.columns.push({
           title: 'Desc_Price_List_Code', key: 'priceListCode', isSortable: true, width: '20%'
        })
     this.title ='Conflect Customer Price  List'
    }
    else{
      this.coreSession.SetTitle('Select Customers');
      this.sharedTabelData.rowOperations=[]
      var index =this.sharedTabelData.columns.findIndex(column => column.key=='priceListCode');
      if(index>-1)
        this.sharedTabelData.columns.splice(index,1)
    }
    if (dataSource && dataSource.data && dataSource.data.length > 0) {
      if(!this.hideAddedCustomers){
        if(this.isConflectCustomer){
            dataSource.data = this.addedCustomersList
          dataSource.totalItems = this.addedCustomersList.length
        }
          else{
            dataSource.data.forEach(newCustomer => {
              var index = this.addedCustomersList.findIndex(addedCustomer => addedCustomer.customerId === newCustomer.customerId && addedCustomer.outletId === newCustomer.outletId);
              if (index >= 0) {
                newCustomer.isChecked = true;
                newCustomer.routesList = this.addedCustomersList[index].routesList;
                newCustomer = this.addedCustomersList[index];
              }
            })
          }
          }else{
      dataSource.data = dataSource.data.filter(cust=> !this.addedCustomersList.find(c => c.customerId === cust.customerId && c.outletId === cust.outletId));
    }
    }
    this.dataSource = {
      totalItems: dataSource.totalItems,
      data: dataSource.data
    }
    this.customersOnOrganizationsSelected.emit(this.dataSource);
  }

  get customerGroupInput() {
    return this.customerFilterForm.get('customerGroupId');
  }
  get customerClassInput() {
    return this.customerFilterForm.get('customerClassId');
  }
  get customerChannelInput() {
    return this.customerFilterForm.get('channelId');
  }
  get customerSubChannelInput() {
    return this.customerFilterForm.get('subChannelId');
  }
  get routeIdlInput() {
    return this.customerFilterForm.get('routeId');
  }
  get territoryIdInput() {
    return this.customerFilterForm.get('territoryId');
  }
  get customerTypeIdInput() {
    return this.customerFilterForm.get('customerTypeId');
  }
  get sdcIdInput() {
    return this.customerFilterForm.get('sdcId');
  }
  onFindCustomers() {
    this.populateCustomers(true);
  }
  onClearFilters() {
    this.customerFilterForm.reset();
  }
  onCheckRowOperation(customerOutlet) {

    var index = this.addedCustomersList.findIndex(x => x.customerId === customerOutlet.customerId && x.outletId === customerOutlet.outletId);
    var indexPromo = this.addedExcludeCustomerPromotionList.findIndex(x => x.customerId === customerOutlet.customerId && x.outletId === customerOutlet.outletId);
    if (customerOutlet.isChecked) {
      if (index < 0) {
        this.addedCustomersList.push(customerOutlet);
      }
      if (indexPromo < 0) {
        this.addedExcludeCustomerPromotionList.push(customerOutlet);
      }
    } else {
      if (index >= 0) {
        this.addedCustomersList.splice(index, 1);
      }
      if (indexPromo >= 0) {
        this.addedExcludeCustomerPromotionList.splice(indexPromo, 1);
      }
    }
  }
  onCheckAllOperation(checkAll: boolean) {
    this.dataSource.data.forEach(outlet => {
      var index = this.addedCustomersList.findIndex(x => x.customerId === outlet.customerId && x.outletId === outlet.outletId);
      if (index >= 0 && !checkAll) {
        this.addedCustomersList.splice(index, 1);
      } else if (index < 0 && checkAll) {
        this.addedCustomersList.push(outlet);
      }
    })
  }
  onTableFilterChanged(query: any) {
    this.outletsFilter.customListFilter = query;
    this.query = query;
    this.populateCustomers(true);
  }
  onSaveClick() {

    this.validateBenfitsCustomers();
  }
  validateBenfitsCustomers() {
    let customerNames = [];
    if (this.customerSelectionLevel === CustomerSelectionLevel.CustomerLevel) {
      var promoExclusionCustomers = this.addedExcludeCustomerPromotionList.filter(x => this.achievementCustomerList.find(c => c.customerId == x.customerId))
    }
    else if (this.customerSelectionLevel === CustomerSelectionLevel.OutletLevel) {
      var promoExclusionCustomers = this.addedExcludeCustomerPromotionList.filter(x => this.achievementCustomerList.find(c => c.customerId == x.customerId && c.outletId == x.outletId))
    }
    if (promoExclusionCustomers != null && promoExclusionCustomers.length > 0) {
      promoExclusionCustomers.forEach(x => {
        this.customerSelectionLevel === CustomerSelectionLevel.CustomerLevel ? customerNames.push(x.customerCodeName) : customerNames.push(x.outletCodeName);
      });
      this.customerCodeNames = customerNames.join(',');
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(this.customerSelectionLevel === CustomerSelectionLevel.CustomerLevel ? ConstantMessages.MsgConfirmationExcludeCustomers : ConstantMessages.MsgConfirmationExcludeOutlets).replace('{0}', this.customerCodeNames)
        , DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
          (result: DialogResult) => {
            if (result === DialogResult.Yes) {
              this.isValid = true;
              this.onSaveCompleted(this.isValid);
            } else {
              this.isValid = false;
            }
          });
    } else {
      this.isValid = true;
      this.onSaveCompleted(this.isValid);
    }
  }
  onSaveCompleted(valid) {

    if (valid) {
      this.addedExcludeCustomerPromotionList = [];
      this.saveEvent.emit(this.addedCustomersList);
    }
  }
  public closeSelectCustomerDialog() {
    this.modalService.dismissAll()
  }
  public showDialog(organizationIds: any, excludedCustomers: any[] = [], dataList: any[] = [], addedCustomers: any[] = []) {

    if (this.customerSelectionLevel === CustomerSelectionLevel.CustomerLevel) {
      this.sharedTabelData.columns = [
        { title: 'Desc_Customer_Code', key: 'customerCode', isSortable: true, width: '35%' },
        { title: 'Desc_Customer_Name', key: 'customerName', isSortable: true, width: '35%' },
        { title: 'Desc_Phone', key: 'phone', isSortable: true, width: '15%' },
        { title: 'Desc_Address', key: 'address', isSortable: true, width: '15%' }
      ];
    } else {
      this.sharedTabelData.columns = [
        { title: 'Desc_Customer', key: 'customerCodeName', isSortable: true, width: '30%' },
        { title: 'Desc_Outlet', key: 'outletCodeName', isSortable: true, width: '30%' },
        { title: 'Desc_Phone', key: 'phone', isSortable: true, width: '10%' },
        { title: 'Desc_Address', key: 'address', isSortable: true, width: '10%' }
      ];
    }

    if (this.overwriteAddedCustomersList) {
      this.addedCustomersList = addedCustomers;
    }
    this.excludedCustomers = excludedCustomers;
    this.dataList = dataList;
    this.selectedOraganizationIds = organizationIds;
    this.coreSession.SetTitle('Select Customers');
    this.outletsFilter.customListFilter = {
      searchFilter: '',
      page: 0,
      pageSize: 100
    };
    this.customerFilterForm.reset();
    this.query = {
      searchFilter: '',
      page: 0,
      pageSize: 100
    };
    this.customerGroupInput.setValue(this.groupId && this.groupId != -1 ? this.groupId : null);
    this.customerChannelInput.setValue(this.channelId && this.channelId != -1 ? this.channelId : null);
    this.customerSubChannelInput.setValue(this.subChannelId && this.subChannelId != -1 ? this.subChannelId : null);

    this.populateCustomers();
    if (!this.isDismissible) {
      // backdrop = "static", not dismissible on click.
      this.config.backdrop = "static";
    }


    return this.modalService.open(this.selectCustomerDialog, { centered: true, size: 'xl' }).result.then(
      (result) => {
        this.config.backdrop = true;
        if (result === DialogResult.Ok) {
          if(this.isConflectCustomer){

            var customerappliedList = {
              rejectCustomer :this.rejectCustomerList,
              approvCustomer :this.approveCustomerList

            }
            return customerappliedList;
          }
          else{
            return this.addedCustomersList;
          }

        } else {
          return -1;
        }
      });

  }

  onAreaSelected(area) {
  }

  prepareOutletsFilter() {
    this.outletsFilter = {
      customListFilter: {
        searchFilter: '',
        page: 0,
        pageSize: 100
      },
      customerGroupId: -1,
      customerClassId: -1,
      territoryId: -1,
      selectedOraganizationIds: '',
      channelId: -1,
      subChannelId: -1,
      routeId: -1,
      customerTypeId: -1,
      showDefault: false,
      divisionId: -1,
      countryId: "",
      stateId: "",
      cityId: "",
      areaId: "",
      streetId: "",
      getAllData: false
    };
    this.outletsFilter.customerGroupId = (!this.customerGroupInput.value || this.customerGroupInput.value === null) ? -1 : this.customerGroupInput.value;
    this.outletsFilter.customerClassId = (!this.customerClassInput.value || this.customerClassInput.value === null) ? -1 : this.customerClassInput.value;
    this.outletsFilter.channelId = (!this.customerChannelInput.value || this.customerChannelInput.value === null) ? -1 : this.customerChannelInput.value;
    this.outletsFilter.subChannelId = (!this.customerSubChannelInput.value || this.customerSubChannelInput.value === null) ? -1 : this.customerSubChannelInput.value;
    this.outletsFilter.territoryId = (!this.territoryIdInput.value || this.territoryIdInput.value === null) ? -1 : this.territoryIdInput.value;
    this.outletsFilter.routeId = (!this.routeIdlInput.value || this.routeIdlInput.value === null) ? -1 : this.routeIdlInput.value;
    this.outletsFilter.customerTypeId = (!this.customerTypeIdInput.value || this.customerTypeIdInput.value === null) ? -1 : this.customerTypeIdInput.value;
    this.outletsFilter.selectedOraganizationIds = this.selectedOraganizationIds ? this.selectedOraganizationIds.toString() : '';
    this.outletsFilter.showDefault = this.showDefault ? this.showDefault : false;
    this.outletsFilter.divisionId = this.customerFilterForm.get('divisionId').value ? this.customerFilterForm.get('divisionId').value : -1;
    this.outletsFilter.countryId = this.customerFilterForm.get('country').value ? this.customerFilterForm.get('country').value : "";
    this.outletsFilter.stateId = this.customerFilterForm.get('state').value ? this.customerFilterForm.get('state').value : "";
    this.outletsFilter.cityId = this.customerFilterForm.get('city').value ? this.customerFilterForm.get('city').value : "";
    this.outletsFilter.areaId = this.customerFilterForm.get('area').value ? this.customerFilterForm.get('area').value : "";
    this.outletsFilter.streetId = this.customerFilterForm.get('street').value ? this.customerFilterForm.get('street').value : "";
    this.outletsFilter.customListFilter = this.query ? this.query : this.outletsFilter.customListFilter;
    this.outletsFilter.getAllData = false;
    this.outletsFilter.fillCustomerOrganizationIds = this.fillCustomerOrganizationIds;
    this.outletsFilter.fillCustomerSDCIds = this.fillCustomerSDCIds;
    this.outletsFilter.excludedCustomers = this.excludedCustomers;
    this.outletsFilter.sdcIdsList = this.sdcIdsList;
    this.outletsFilter.sdcId = this.sdcIdInput && this.sdcIdInput.value ? this.sdcIdInput.value : -1;
    this.outletsFilter.isCustomerOutletDivisionHasRecords = this.isCustomerOutletDivisionHasRecords
  }
  checkCustomerOutletDivisionIsExist() {
    this.coreSession.ModalLoading.Show();
    this.customerService.checkCustomerOutletDivisionIsExist().subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.isCustomerOutletDivisionHasRecords = response.data;
          // this.transactionForm.get('transactionId').setValue(this.transactionId);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  isDivisionLevel() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true";
  }
}
