import { Component, OnInit, Input, Output, EventEmitter, ViewChild, ChangeDetectorRef } from '@angular/core';
import { CustomerClassModel } from '../../../../models/customer/customer-class.model';
import { FormGroup } from '@angular/forms';
import { EntryFormTypes } from '../../../../models/enums/entry-form-types.enum';
import { Subject } from 'rxjs';
import { CustomerService } from '../../../../services/data-definition/customer/customers.service';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { SharedDialogComponent } from '../../../shared-dialog/shared-dialog.component';


@Component({
  selector: 'app-customer-class-filter',
  templateUrl: './customer-class-filter.component.html',
  styleUrls: ['./customer-class-filter.component.css']
})
export class CustomerClassFilterComponent implements OnInit {

  @ViewChild("templateEntry", { static: true }) templateEntry: SharedDialogComponent;
  isClassLoading = false;
  addClass = false;
  lastAddedCustomerClassId: number;
  entryFormType: EntryFormTypes = EntryFormTypes.CustomerClass;
  customerClassDataSource: CustomerClassModel[] = [];

  @Input() parentForm: FormGroup;
  @Input() isLabelHidden: boolean;
  @Input() isAddNewHidden: boolean;
  @Input() isMandatory: boolean =true;
  @Output() onChangeCustomerClass = new EventEmitter();
  saveSubject: Subject<void> = new Subject<void>();

  constructor(private customerService: CustomerService, private modalService: NgbModal, private cdr: ChangeDetectorRef) { }

  ngOnInit() {
    this.populateClassesList();
    this.lastAddedCustomerClassId = this.parentForm.value.customerClassId;
  }

  populateClassesList() {
    this.isClassLoading = true;
    this.customerService.getCustomerClasses().subscribe(result => {
      this.customerClassDataSource = result.data;
      this.isClassLoading = false;
      this.cdr.detectChanges(); // Manually trigger change detection after data is loaded
    });
  }

  onCustomerClassSelectionchanged() {
    this.onChangeCustomerClass.emit();
  }

  onAddingNewCustomerClass(customerClassId: number) {

    this.lastAddedCustomerClassId = customerClassId;
    this.cdr.detectChanges();
    this.populateClassesList();
    // Manually trigger change detection after updating the variable
    this.onCloseClassClicked();
  }

  onSaveClassClicked() {
    this.saveSubject.next();
  }

  onCloseClassClicked() {
    this.templateEntry.Close();
  }

  showClassModal() {
    this.templateEntry.Show(true).then(
      (res) => {
      }
    );
  }

  onDialogResult(event) {
    if (event && event.saveCLicked) {
      this.onSaveClassClicked();
    }
  }
}
