import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { AbstractControl, FormGroup } from '@angular/forms';
import { CustomerService } from '../../../services/data-definition/customer/customers.service';

@Component({
  selector: 'app-customer-status-filter',
  templateUrl: './customer-status-filter.component.html',
  styleUrls: ['./customer-status-filter.component.css']
})
export class CustomerStatusFilterComponent implements OnInit {
  isClassLoading = false;
  customerStatusDataSource= [];
  @Input() parentForm: FormGroup;
  @Output() onChange:EventEmitter<number>=new EventEmitter<number>();
  isRequired = false;
  constructor(private customerService:CustomerService) { }
  
  ngOnInit() {
    if(this.parentForm.get('customerStatusId').validator != null){
      const validator = this.parentForm.get('customerStatusId').validator({} as AbstractControl);
      if (validator && validator.required) {
        this.isRequired = true;
      }
    }
    this.populateCustomerStatusList();
  }

  populateCustomerStatusList() {
    this.isClassLoading = true;
    this.customerService.getCustomerStatus().subscribe(result => {
      this.customerStatusDataSource = result.data;
      this.isClassLoading = false;
    });
  }
  onCustomerStatusChanged(){
  this.onChange.emit(this.parentForm.value.customerStatusId);
  }

}
