import { HttpErrorResponse } from '@angular/common/http';
import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { AbstractControl, FormGroup } from '@angular/forms';
import { TranslateService } from '@ngx-translate/core';
import { CoreSession } from '../../../../core/core.session';
import { ConstantMessages } from '../../../models/constants/constant-message';
import { DiscountService } from '../../../services/data-definition/prices-and-offers/discount.service';

@Component({
  selector: 'app-discount-type-filter',
  templateUrl: './discount-type-filter.component.html',
  styleUrls: ['./discount-type-filter.component.css']
})
export class DiscountTypeFilterComponent implements OnInit {
  @Input() excludedDiscountTypeId = -1;
  @Input() currentFormControlName = 'discountTypeId';
  @Input() hideLabel = false;
  @Input() parentForm: FormGroup;
  @Input() emitIdAndCaption = false;
  @Output() selectedDiscountType = new EventEmitter();
  @Output()
  onChangeIdCaptionSalesMode = new EventEmitter();
  discountTypesDataSource: any[];
  isDiscountTypeLoading = false;
  isRequired = false;


  constructor(
    private translateService: TranslateService,
    private discountService: DiscountService,
    private coreSession: CoreSession,) { }

  ngOnInit(): void {
    if (this.parentForm.get(this.currentFormControlName).validator != null) {
      const validator = this.parentForm.get(this.currentFormControlName).validator({} as AbstractControl);
      if (validator && validator.required) {
        this.isRequired = true;
      }
    }
  }

  ngOnChanges() {
    this.fillDiscountTypes();
  }

  fillDiscountTypes() {
    this.isDiscountTypeLoading = true;
    this.discountService.getDiscountTypes().subscribe(
      response => {
        this.isDiscountTypeLoading = false;
        if (response.status != null && response.status >= 0) {
          this.discountTypesDataSource = response.data;
          (this.discountTypesDataSource);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.isDiscountTypeLoading = false;
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

}
