import { Injectable, Inject } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { ResponseModel } from '../../../models/api-models/api-models';

@Injectable({
  providedIn: 'root'
})
export class DivisionService {
  private url = '';
  constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string) {
    this.url = baseUrl + 'Item';
  }

  getEmpDivision(filter: any) {
    const urlValue: string = this.url + '/GetDivisions';

    return this.http.get<ResponseModel>(urlValue + '?' + this.toQueryString(filter))
      .map(response => {
        return response.data;
      });
  }
  getDivisionsUnderOrgAccess() {
    return this.getEmployeeDivisions(false);
  }
  getDivisionsUnderEmployeeAccess() {
    return this.getEmployeeDivisions(true);
  }
  getEmployeeDivisions(checkEmployeeAccess: boolean) {
    const urlValue: string = this.url + '/GetDivisionsUnderOrgAccess';
    let employeeDivisons = {
      employeeAccess: checkEmployeeAccess
    }
    return this.http.post<ResponseModel>(urlValue, employeeDivisons).map(response => {
      return <any>response.data;
    });
  }

  toQueryString(obj: any) {
    const parts = [];
    // tslint:disable-next-line:forin
    for (const property in obj) {
      const value = obj[property];
      if (value != null && value !== undefined) {
        parts.push(
          encodeURIComponent(property) + '=' + encodeURIComponent(value)
        );
      }
    }
    return parts.join('&');
  }
}
