import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { AbstractControl, FormGroup } from '@angular/forms';
import { EmployeeService } from '../../../../content/employee/employee.service';

@Component({
  selector: 'app-employee-branch-filter',
  templateUrl: './employee-branch-filter.component.html',
  styleUrls: ['./employee-branch-filter.component.css']
})
export class EmployeeBranchFilterComponent implements OnInit {
  @Input() parentForm: FormGroup;
  @Input () organizationId : number;
  @Output() onChangeEmployeeBranch = new EventEmitter();
  employeeBranchesList: any[];
  isEmployeeBranchLoading = false;
  isRequired = false;
  
  constructor(private employeeService : EmployeeService) { }

  ngOnInit(): void {
    if (this.parentForm.get('employeeBranchId').validator != null) {
      const validator = this.parentForm.get('employeeBranchId').validator({} as AbstractControl);
      if (validator && validator.required) {
        this.isRequired = true;
      }
    }
    this.populateEmployeeBranchList();
  }
  ngOnChanges(){
    this.populateEmployeeBranchList();
  }
  populateEmployeeBranchList() {
    this.isEmployeeBranchLoading = true;
    this.employeeBranchesList = [];
    let employeeBrancheFilter = {
      organizationId: this.organizationId ? this.organizationId : -1,
    };
    this.employeeService.getEmployeeBranches(employeeBrancheFilter).subscribe((result) => {
      this.employeeBranchesList = result;
      this.isEmployeeBranchLoading = false;
    });
  }

  onChangeselectedEmployeeBranch(selectedEmployeeBranch) {
    this.onChangeEmployeeBranch.emit(selectedEmployeeBranch);
  }

}


