import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { AbstractControl, FormGroup } from '@angular/forms';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../models/constants/constant-message';
import { HeaderDiscountTypes } from '../../../models/enums/HeaderDiscount-type-enum';

@Component({
  selector: 'app-header-discount-type-filter',
  templateUrl: './header-discount-type-filter.component.html',
  styleUrls: ['./header-discount-type-filter.component.css']
})
export class HeaderDiscountTypeFilterComponent implements OnInit {

  @Input() excludeHeaderDiscountType = -1;
  @Input() currentFormControlName = 'typeId';
  @Input() hideLabel = false;
  @Input() parentForm: FormGroup;
  @Input() emitIdAndCaption = false;
  @Output() selectedHeaderDiscountType = new EventEmitter();
  @Output()
  onChangeIdCaptionSalesMode = new EventEmitter();
  HeaderDiscountTypeList: any[] = [];
  isHeaderDiscountTypeLoading = false;
  isRequired = false;


  constructor(private translateService: TranslateService,) { }

  ngOnInit(): void {
    if (this.parentForm.get(this.currentFormControlName).validator != null) {
      const validator = this.parentForm.get(this.currentFormControlName).validator({} as AbstractControl);
      if (validator && validator.required) {
        this.isRequired = true;
      }
    }
  }

  ngOnChanges() {
    this.fillHeaderDiscountType();
  }

  fillHeaderDiscountType() {
    this.isHeaderDiscountTypeLoading = true;
    this.HeaderDiscountTypeList = [];
    this.HeaderDiscountTypeList.push({ TypeId: HeaderDiscountTypes.CashHeader.valueOf(), HeaderDiscountTypeName: this.translateService.instant(ConstantMessages.Desc_Cash_Header_Discount)});
    this.HeaderDiscountTypeList.push({ TypeId: HeaderDiscountTypes.NormalHeader.valueOf(), HeaderDiscountTypeName: this.translateService.instant(ConstantMessages.Desc_Normal_Header_Discount)});
    this.isHeaderDiscountTypeLoading = false;
  }

}
