import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { FormGroup, AbstractControl } from '@angular/forms';
import { ItemService } from '../../../services/data-definition/product/item.service';

@Component({
  selector: 'app-item-model-filter',
  templateUrl: './item-model-filter.component.html',
  styleUrls: ['./item-model-filter.component.css']
})
export class ItemModelFilterComponent implements OnInit {
  @Input() currentFormControlName = 'modelId';
  @Input() hideLabel = false;
  @Input() parentForm: FormGroup;
  @Output() selectedItemModel = new EventEmitter();
  itemModelList: any[];
  isItemModelLoading = false;
  isRequired = false;
  translateService: any;


  constructor(private itemService : ItemService) { }

  ngOnInit(): void {
    if (this.parentForm.get(this.currentFormControlName).validator != null) {
      const validator = this.parentForm.get(this.currentFormControlName).validator({} as AbstractControl);
      if (validator && validator.required) {
        this.isRequired = true;
      }
    }
  }

  ngOnChanges() {
    this.populateItemModel();
  }

  populateItemModel() {
    this.itemModelList = [];
    this.isItemModelLoading = true;
    this.itemService.getItemModel().subscribe(result => {
    this.itemModelList = result.data;
    this.isItemModelLoading = false;
    });
  }
  onChangeItemModel(selectedItemModel: any) {
      this.selectedItemModel.emit(selectedItemModel);
  }
}
