import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { TranslateService } from '@ngx-translate/core';
import { RouteHistoryStatus } from '../../../models/enums/routeHistoryStatus-enum';
import { ConstantMessages } from '../../../models/constants/constant-message';

@Component({
  selector: 'app-route-history-status-filter',
  templateUrl: './route-history-status-filter.component.html',
  styleUrls: ['./route-history-status-filter.component.css']
})
export class RouteHistoryStatusFilterComponent implements OnInit {

  @Input() excludeRouteHistoryStatus = -1;
  @Input() currentFormControlName = 'routeHistoryStatusId';
  @Input() hideLabel = false;
  @Input() parentForm: FormGroup;
  @Input() emitIdAndCaption = false;
  @Output() selectedRouteHistoryStatus = new EventEmitter();
  @Output()
  onChangeIdCaptionSalesMode = new EventEmitter();
  RouteHistoryStatusList: any[] = [];
  RouteHistoryStatusLoading = false;
  isRequired = false;


  constructor(private translateService: TranslateService,) { }

  ngOnInit(): void {
    this.fillRouteHistoryStatus();
  }

  fillRouteHistoryStatus() {
    this.RouteHistoryStatusLoading = true;
    this.RouteHistoryStatusList = [];
    this.RouteHistoryStatusList.push({ routeHistoryStatusId: RouteHistoryStatus.Uploaded.valueOf(), RouteHistoryStatusName: this.translateService.instant(ConstantMessages.Desc_Uploaded)});
    this.RouteHistoryStatusList.push({ routeHistoryStatusId: RouteHistoryStatus.Started.valueOf(), RouteHistoryStatusName: this.translateService.instant(ConstantMessages.Desc_Started)});
    this.RouteHistoryStatusList.push({ routeHistoryStatusId: RouteHistoryStatus.Out.valueOf(), RouteHistoryStatusName: this.translateService.instant(ConstantMessages.Desc_Out)});
    this.RouteHistoryStatusList.push({ routeHistoryStatusId: RouteHistoryStatus.In.valueOf(), RouteHistoryStatusName: this.translateService.instant(ConstantMessages.Desc_In)});
    this.RouteHistoryStatusList.push({ routeHistoryStatusId: RouteHistoryStatus.Ended.valueOf(), RouteHistoryStatusName: this.translateService.instant(ConstantMessages.Desc_Ended)});
    this.RouteHistoryStatusList.push({ routeHistoryStatusId: RouteHistoryStatus.Downloaded.valueOf(), RouteHistoryStatusName: this.translateService.instant(ConstantMessages.Desc_Downloaded)});
    this.RouteHistoryStatusList.push({ routeHistoryStatusId: RouteHistoryStatus.ApprovedReturn.valueOf(), RouteHistoryStatusName: this.translateService.instant(ConstantMessages.Desc_ApprovedReturn)});
    this.RouteHistoryStatusList.push({ routeHistoryStatusId: RouteHistoryStatus.ScannedOdometer.valueOf(), RouteHistoryStatusName: this.translateService.instant(ConstantMessages.Desc_ScannedOdometer)});
    this.RouteHistoryStatusList.push({ routeHistoryStatusId: RouteHistoryStatus.OffLoadNonResalableItems.valueOf(), RouteHistoryStatusName: this.translateService.instant(ConstantMessages.Desc_OffLoadNonResalableItems)});
    this.RouteHistoryStatusList.push({ routeHistoryStatusId: RouteHistoryStatus.LoadExecution.valueOf(), RouteHistoryStatusName: this.translateService.instant(ConstantMessages.Desc_LoadExecution)});
    this.RouteHistoryStatusList.push({ routeHistoryStatusId: RouteHistoryStatus.SODVehicleWeighted.valueOf(), RouteHistoryStatusName: this.translateService.instant(ConstantMessages.Desc_SODVehicleWeighted)});
    this.RouteHistoryStatusList.push({ routeHistoryStatusId: RouteHistoryStatus.EODVehicleWeighted.valueOf(), RouteHistoryStatusName: this.translateService.instant(ConstantMessages.Desc_EODVehicleWeighted)});
    this.RouteHistoryStatusList.push({ routeHistoryStatusId: RouteHistoryStatus.Canceled.valueOf(), RouteHistoryStatusName: this.translateService.instant(ConstantMessages.Desc_Canceled_Word)});
    this.RouteHistoryStatusLoading = false;
  }

}
