import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { AbstractControl, FormGroup } from '@angular/forms';
import { ConstantMessages } from '../../../models/constants/constant-message';
import { SalesModes } from '../../../models/enums/sales.modes.enum';
import { HeaderDiscountService } from '../../../services/data-definition/prices-and-offers/header-discount.service';

@Component({
  selector: 'app-sales-mode-filter',
  templateUrl: './sales-mode-filter.component.html',
  styleUrls: ['./sales-mode-filter.component.css']
})
export class SalesModeFilterComponent implements OnInit {
  @Input() excludedsalesModeId = -1;
  @Input() currentFormControlName = 'saleModeId';
  @Input() hideLabel = false;
  @Input() parentForm: FormGroup;
  @Input() emitIdAndCaption = false;
  @Output() selectedSalesMode = new EventEmitter();
  @Output()
  onChangeIdCaptionSalesMode = new EventEmitter();
  SalesModeList: any[];
  isSalesModeLoading = false;
  isRequired = false;
  translateService: any;


  constructor(private headerDiscountservice : HeaderDiscountService) { }

  ngOnInit(): void {
    if (this.parentForm.get(this.currentFormControlName).validator != null) {
      const validator = this.parentForm.get(this.currentFormControlName).validator({} as AbstractControl);
      if (validator && validator.required) {
        this.isRequired = true;
      }
    }
  }

  ngOnChanges() {
    this.populateSalesMode();
  }

  populateSalesMode() {
    this.SalesModeList = [];
    this.isSalesModeLoading = true;
    this.headerDiscountservice.getSalesMode().subscribe(result => {
    this.SalesModeList = result.data;
    this.isSalesModeLoading = false;

     // Add an additional value to the SalesModeList array
     const additionalValue = { salesModeId: -1, salesModeName: 'Both' };
     this.SalesModeList.push(additionalValue);
    });
  }
  onChangeSalesMode(selectedSalesMode: any) {
    if (!this.emitIdAndCaption)
      this.selectedSalesMode.emit(selectedSalesMode);
    else {
      let event = {
        id: selectedSalesMode.salesModeId,
        caption: selectedSalesMode.salesModeName
      }
      this.onChangeIdCaptionSalesMode.emit(event);
    }
  }

}
