import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { AbstractControl, FormGroup } from '@angular/forms';
import { OrderStatus } from '../../../models/enums/order-status.enum';
import { PriceService } from '../../../services/data-definition/prices-and-offers/price.service';
@Component({
  selector: 'app-sales-order-status-type-filter',
  templateUrl: './sales-order-status-type-filter.component.html',
  styleUrls: ['./sales-order-status-type-filter.component.css']
})
export class SalesOrderStatusTypeFilterComponent implements OnInit {

  @Input() parentForm: FormGroup;
  @Output() salesOrderTypeSelected = new EventEmitter();
  @Input() orderStatus: OrderStatus[] =
  [OrderStatus.New,OrderStatus.Approved,OrderStatus.Rejected];

  salesOrderStatusTypeDataSource: any[];
  isRequired: boolean = false;
  isSalesOrderTypeLoading: boolean = false;
  constructor(private priceService: PriceService) {
  }
  ngOnInit(): void {
    // if(this.parentForm.get('salesOrderStatusTypeId').validator != null){
    //   const validator = this.parentForm.get('salesOrderStatusTypeId').validator({} as AbstractControl);
    //   if (validator && validator.required) {
    //     this.isRequired = true;
    //   }
    // }
    this.populateSalesOrderTypesList();
  }

  populateSalesOrderTypesList() {
    this.isSalesOrderTypeLoading = true;
    this.priceService.getSalesOrderStatusTypes(this.orderStatus).subscribe(result => {
      debugger
      this.salesOrderStatusTypeDataSource = result.data;
      this.isSalesOrderTypeLoading = false;
    }, (error) => {
      this.isSalesOrderTypeLoading = false;
    });
  }


  onChange(selectedSalesOrderStatusType:any){
    debugger
    var orderStatusTypeId = -1
    if(selectedSalesOrderStatusType)
      orderStatusTypeId= selectedSalesOrderStatusType.orderStatusId

    this.salesOrderTypeSelected.emit(orderStatusTypeId);
  }


}
