import { Component, EventEmitter, Input, OnChanges, OnInit, Output } from '@angular/core';
import { AbstractControl, FormGroup } from '@angular/forms';
import { HttpResponse } from '@aspnet/signalr';
import { SalesDistributionChannelService } from '../../../../content/master-data-definition/customer-managment/sales-distribution-channel/sales-distribution-channel.service';
import { CustomerService } from '../../../services/data-definition/customer/customers.service';

@Component({
  selector: 'app-sdc-filter',
  templateUrl: './sdc-filter.component.html',
  styleUrls: ['./sdc-filter.component.css']
})
export class SdcFilterComponent implements OnInit, OnChanges {
  @Input() currentFormControlName = 'sdcId'
  @Input() parentForm: FormGroup;
  @Input() sdcIdsList: number[] = [];

  @Output() onSDCSelected = new EventEmitter();
  isRequired: boolean = false;
  allSDCsList: any[] = [];
  isSDCLoading: boolean = false;
  constructor(private customerService: CustomerService) { }

  ngOnInit(): void {
    if (this.parentForm.get(this.currentFormControlName).validator != null) {
      const validator = this.parentForm.get(this.currentFormControlName).validator({} as AbstractControl);
      if (validator && validator.required) {
        this.isRequired = true;
      }
    }
  }

  ngOnChanges() {
    this.populateSDCsList();
  }

  populateSDCsList() {
    this.allSDCsList = [];
    this.isSDCLoading = true;
    var filter = {
      organizationIds: null,
      sdcIdsString: this.sdcIdsList ? this.sdcIdsList.join(',') : null
    }
    this.customerService.getAllSalesDistributionChannels(filter).subscribe(result => {
      this.isSDCLoading = false;
      this.allSDCsList = result && result.data ? result.data : [];
    },(error: HttpResponse) => {this.isSDCLoading = false;});
  }

}
