import { Component, OnInit, Input, Output, EventEmitter,OnChanges } from '@angular/core';
import { AbstractControl, FormGroup } from '@angular/forms';
@Component({
  selector: 'app-territory-filter',
  templateUrl: './territory-filter.component.html',
  styleUrls: ['./territory-filter.component.css']
})
export class TerritoryFilterComponent implements OnInit,OnChanges {

  @Input() parentForm: FormGroup;
  @Input() customeExchangeRouteCustomer = false;
  @Input() masterTerritoryId: number = -1;
  @Input() selectedOrgIds: string;
  @Output() onChangeTerritory = new EventEmitter();
  territoryDataSource: any[];
  isTerritoryLoading = false;
  isRequired = false;

  @Input() hideInactiveTerritories = false;
  constructor() { }

  ngOnInit() {
    if (this.parentForm.get('territoryId').validator != null) {
      const validator = this.parentForm.get('territoryId').validator({} as AbstractControl);
      if (validator && validator.required) {
        this.isRequired = true;
      }
    }
    // this.populateTerritoryList();
  }
  ngOnChanges() {
    this.populateTerritoryList();
  }
  populateTerritoryList() {
    let territoryFilter = {
      hideInactiveTerritories : this.hideInactiveTerritories ,
      masterTerritoryId: this.masterTerritoryId ? this.masterTerritoryId : -1,
      organizationIds : this.selectedOrgIds
    }

    this.isTerritoryLoading = true;
  }
  onChangeSelectedTerritory(selectedTerritory) {
    this.onChangeTerritory.emit(selectedTerritory);
  }

}
