import { InvoiceService } from './../../../services/customer-operation/invoice/invoice.service';
import { TransactionService } from './../../../../content/customer-operation/transactions/transaction.service';
import { Component, OnInit, Input, Output, EventEmitter, OnDestroy, ViewChild, OnChanges } from '@angular/core';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { SharedTableResult } from '../../../models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../models/shared-table/table-properties.interface';
import { CoreSession } from '../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../models/constants/constant-message';
import { HttpErrorResponse } from '@angular/common/http';
import { NgbModal, NgbModalConfig } from '@ng-bootstrap/ng-bootstrap';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { IDateTimePickerProperties } from '../../../models/dateTimeModel/date-time-properties.interface';
import { ResponseModel } from '../../../models/api-models/api-models';
import { CustomerService } from '../../../services/data-definition/customer/customers.service';
import { ConstantURLs } from '../../../models/constants/constant-URL';
import { MenuActions } from '../../../models/enums/menu-actions-enum';
import { RowOperation } from '../../../models/enums/shared-table-operation.enum';
import { SelectInvoiceItemsComponent } from '../../items/select-invoice-items/select-invoice-items.component';
import { GeneralFilter } from '../../../models/general/generalFilter.model';

@Component({
  selector: 'app-select-invoices',
  templateUrl: './select-invoices.component.html',
  styleUrls: ['./select-invoices.component.css']
})
export class SelectInvoicesComponent implements OnInit, OnChanges, OnDestroy {

  @ViewChild('selectInvoiceDialog', { static: true }) selectInvoiceDialog: any;
  @ViewChild("selectInvoiceItemsDialog", { static: true }) selectInvoiceItemsDialog: SelectInvoiceItemsComponent;
  selectedTransactionId: string;
  @Input('customerCodeName') customerCodeName: string;
  query: GeneralFilter = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: 15
    },
  };
  transactionFilter: FormGroup;
  transactionDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Transaction_Date',
    formControlName: 'transactionDate',
    isCalendarOnly: true,
    isRange: true
  };
  showSelectInvoiceDialog: boolean = false;

  sharedTabelData: ITableProperties = {
    pageSize: 100,
    showPaginator: true,
    isOnline: true,
    showSearch: true,
    isMultiSelection: false,
    showEditButton: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Outlet', key: 'outletCodeName', isSortable: true, width: '30%' },
      { title: 'Desc_Transaction_ID', key: 'transactionId', isSortable: true, width: '30%' },
      { title: 'Desc_Date', key: 'transactionDate', isSortable: true, width: '10%', isExpiryDate: true },
      { title: 'Desc_Type', key: 'transactionTypeName', isSortable: true, width: '10%' },
      { title: 'Desc_Color', key: 'icon', isSortable: false, isIcon: true, iconColor: 'iconColor', width: '10%', isColoring: true }
    ]
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  invoiceFilter: any = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: 100
    },
    fromToDate: [],
    customerId: -1
  }

  constructor(
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private invoiceService: InvoiceService,
    private config: NgbModalConfig,
    private modalService: NgbModal,
    private sessionData: SessionDataProvider
  ) {
    this.config.backdrop = true;
    this.config.keyboard = true;
  }
  ngOnInit() {
    this.initFilterForm();
    this.addViewAction();
  }
  ngOnChanges() {
    this.initFilterForm();
  }
  ngOnDestroy() {
    this.config.backdrop = true;
    this.config.keyboard = true;
  }
  initFilterForm() {
    this.transactionFilter = new FormGroup({
      transactionDate: new FormControl([null, null])
    });
  }
  addViewAction() {
    this.sharedTabelData.rowOperations.push(
      {
        operation: RowOperation.View,
        title: 'Desc_View',
        icon: 'fa-regular fa-eye',
        color: '#12344d'
      });
  }
  onChangeDate(date) {
    this.invoiceFilter.fromToDate = date;
  }
  populateCustomerTransaction() {
    this.coreSession.ModalLoading.Show();
    this.invoiceService.getVmTransactionsForSelectedCustomers(this.invoiceFilter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.dataSource = <SharedTableResult>response.data;
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
    );
  }
  onRowClicked(event: any) {
    switch (event.operation) {
      case RowOperation.View:
        this.selectedTransactionId = event.object.transactionId;
        this.selectInvoiceItemsDialog.showDialog(event.object).then(
          (result) => {
          });
        break;
    }
  }
  onFindInvoices() {
    this.populateCustomerTransaction();
  }
  onClearFilters() {
    this.transactionFilter.reset();
    this.invoiceFilter.fromToDate = [];
  }
  onTableFilterChanged(query: any) {
    this.invoiceFilter.customListFilter = query;
    this.query = query;
    this.populateCustomerTransaction();
  }
  public showDialog(selectedCustomerId) {
    this.sharedTabelData.columns = [
      { title: 'Desc_Outlet', key: 'outletCodeName', isSortable: true, width: '30%' },
      { title: 'Desc_Transaction_ID', key: 'transactionId', isSortable: true, width: '30%' },
      { title: 'Desc_Date', key: 'transactionDate', isSortable: true, width: '10%', isExpiryDate: true },
      { title: 'Desc_Type', key: 'transactionTypeName', isSortable: true, width: '10%' },
      { title: 'Desc_Color', key: 'icon', isSortable: false, isIcon: true, iconColor: 'iconColor', width: '10%', isColoring: true }
    ];
    this.coreSession.SetTitle('Define Transactions');
    this.showSelectInvoiceDialog = true;
    this.invoiceFilter.customerId = selectedCustomerId;
    this.invoiceFilter.customListFilter = {
      searchFilter: '',
      page: 0,
      pageSize: 100
    };
    this.transactionFilter.reset();
    this.invoiceFilter.fromToDate = [];
    this.query.fromToDate = [];
    this.populateCustomerTransaction();
    return this.modalService.open(this.selectInvoiceDialog, { centered: true, size: 'xl' }).result.then(
      (result) => {

      });
  }

}
