import { Component, EventEmitter, Input, OnInit, Output, ViewChild } from '@angular/core';
import { FormControl, FormGroup } from '@angular/forms';
import { NgbModal, NgbModalConfig } from '@ng-bootstrap/ng-bootstrap';
import { TranslateService } from '@ngx-translate/core';
import { CoreSession } from '../../../../core/core.session';
import { ConstantMessages } from '../../../models/constants/constant-message';
import { DialogResult } from '../../../models/enums/dialog-result.enum';
import { SharedTableResult } from '../../../models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../models/shared-table/table-properties.interface';
import { ItemService } from '../../../services/data-definition/product/item.service';
import * as cloneDeep from "lodash/cloneDeep";
import { ConstantConfigurations } from '../../../models/constants/constant-configuration';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { DialogMode } from '../../../models/enums/dialog-mode.enum';
import { HttpErrorResponse } from '@angular/common/http';
import { InvoiceService } from '../../../services/customer-operation/invoice/invoice.service';

@Component({
  selector: 'app-select-invoice-items',
  templateUrl: './select-invoice-items.component.html',
  styleUrls: ['./select-invoice-items.component.css']
})


export class SelectInvoiceItemsComponent implements OnInit {

  @ViewChild('selectInvoiceItemsDialog', { static: true }) selectInvoiceItemsDialog: any;
  @Input('TransactionId') TransactionId: string;
  query;
  sharedTabelData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: false,
    isOnline: false,
    showSearch: true,
    isMultiSelection: false,
    showEditButton: false,
    rowOperations: [],
    multiSelectionOperations: [],
    specificActionWhenCheckAll: true,
    specificActionWhenCheckRow: true,
    columns: [
      { title: 'Desc_Items', key: 'itemCodeName', isSortable: true, width: '50%' },
      { title: 'Desc_Quantity', key: 'quantity', isSortable: true, width: '25%', numberOfStockDigits: true },
      { title: 'Desc_Stock_After', key: 'stockQty', isSortable: true, width: '25%', numberOfStockDigits: true },
    ]
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  itemsFilter = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    transactionId: '',
    divisionId: -1,
    transactionType: -1
  };
  constructor(
    private coreSession: CoreSession,
    private invoiceService: InvoiceService,
    private translateService: TranslateService,
    private config: NgbModalConfig,
    private modalService: NgbModal,
    private sessionData: SessionDataProvider) {
    this.config.backdrop = true;
    this.config.keyboard = true;
  }
  ngOnInit() {
  }
  ngOnDestroy() {
    this.config.backdrop = true;
    this.config.keyboard = true;
  }
  onTableFilterChanged(query: any) {
    this.itemsFilter.customListFilter = query;
    this.query = query;
    this.populateVmTransactionDetails();
  }
  populateVmTransactionDetails() {
    this.coreSession.ModalLoading.Show();
    this.invoiceService.getVmTransactionDetails(this.itemsFilter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.dataSource = {
          totalItems: response.data.length,
          data: response.data
        };
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
    );
  }
  public closeSelectItemsDialog() {
    this.modalService.dismissAll()
  }
  public showDialog(transaction) {
    this.sharedTabelData.columns = [
      { title: 'Desc_Items', key: 'itemCodeName', isSortable: true, width: '50%' },
      { title: 'Desc_Quantity', key: 'quantity', isSortable: false, width: '25%', numberOfStockDigits: true },
      { title: 'Desc_Stock_After', key: 'stockQty', isSortable: false, width: '25%', numberOfStockDigits: true }];
    this.coreSession.SetTitle('Define Items');
    this.itemsFilter.transactionId = transaction.transactionId;
    this.itemsFilter.divisionId = transaction.divisionId;
    this.itemsFilter.transactionType = transaction.transactionTypeId;
    this.itemsFilter.customListFilter = {
      searchFilter: '',
      page: 0,
      pageSize: 100
    };
    this.populateVmTransactionDetails();
    return this.modalService.open(this.selectInvoiceItemsDialog, { centered: true, size: 'xl' }).result.then(
      (result) => {

      });
  }
}
