import { Component, ElementRef, EventEmitter, Injectable, Output, ViewChild, ViewEncapsulation } from '@angular/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { DialogResult } from '../../models/enums/dialog-result.enum';
import { DialogMode } from '../../models/enums/dialog-mode.enum';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../models/constants/constant-message';

@Component({
  selector: 'app-modal-dialog',
  templateUrl: './modal-dialog.component.html',
  styleUrls: ['./modal-dialog.component.css'],
  // encapsulation: ViewEncapsulation.None
})
@Injectable()
export class ModalDialogComponent {

  //#region [DECLARATIONS]

  showYesNoButton = true;
  showOkButton = true;
  showWithWithoutOffload = true;
  YesResult: DialogResult = DialogResult.Yes;
  NoResult: DialogResult = DialogResult.No;
  OkResult: DialogResult = DialogResult.Ok;
  WithOffloadResult: DialogResult = DialogResult.WithOffload;
  WithoutOffloadResult: DialogResult = DialogResult.WithoutOffload;
  @ViewChild('content', { static: true }) content: any;
  // Default Value
  confirmation = '';
  body = ' ';
  isList: boolean = false;
  msgList: string[];
  //#endregion

  //#region [INITIALIZED]

  constructor(private modalService: NgbModal,
    private translateService: TranslateService) {
  }

  //#endregion

  //#region [METHODS]

  public ShowMessage(bodyMsg: string, dialogMode: DialogMode, title?: string) {
    this.isList = false;
    this.body = bodyMsg;
    if (title) {
      this.confirmation = title;
    } else {
      this.confirmation = this.translateService.instant(ConstantMessages.WarningCaption);
    }
    switch (dialogMode) {
      case DialogMode.YesNo:
        this.showYesNoButton = true;
        this.showOkButton = false;
        this.showWithWithoutOffload = false;
        break;
      case DialogMode.Ok:
        this.showOkButton = true;
        this.showYesNoButton = false;
        this.showWithWithoutOffload = false;
        break;
      case DialogMode.WithWithout:
        this.showOkButton = false;
        this.showYesNoButton = false;
        this.showWithWithoutOffload = true;
        break;
      default:
        this.showOkButton = false;
        this.showYesNoButton = false;
        this.showWithWithoutOffload = false;
        break;
    }
    // centered: true
    return this.modalService.open(this.content, { centered: true }).result.then(
      (result) => {
        return result;
      },
      (resaon) => {
        return DialogResult.None;
      }
    );
  }
  public ShowMessageList(mainMsg: string, list: string[], dialogMode: DialogMode, title?: string) {
    this.body = mainMsg;
    this.isList = true;
    this.msgList = list;

    if (title) {
      this.confirmation = title;
    } else {
      this.confirmation = this.translateService.instant(ConstantMessages.WarningCaption);
    }
    switch (dialogMode) {
      case DialogMode.YesNo:
        this.showYesNoButton = true;
        this.showOkButton = false;
        this.showWithWithoutOffload = false;
        break;
      case DialogMode.Ok:
        this.showOkButton = true;
        this.showYesNoButton = false;
        this.showWithWithoutOffload = false;
        break;
      case DialogMode.WithWithout:
        this.showOkButton = false;
        this.showYesNoButton = false;
        this.showWithWithoutOffload = true;
        break;
      default:
        this.showOkButton = false;
        this.showYesNoButton = false;
        this.showWithWithoutOffload = false;
        break;
    }
    // centered: true
    return this.modalService.open(this.content, { centered: true }).result.then(
      (result) => {
        return result;
      },
      (resaon) => {
        return DialogResult.None;
      }
    );
  }
  /* private getDismissReason(reason: any): string {
      if (reason === ModalDismissReasons.ESC) {
          return 'by pressing ESC';
      } else if (reason === ModalDismissReasons.BACKDROP_CLICK) {
          return 'by clicking on a backdrop';
      } else {
          return `with: ${reason}`;
      }
  } */

  //#endregion
}
