import { Component, OnInit, Output, EventEmitter, Input, OnChanges, OnDestroy } from '@angular/core';
import { FormGroup, AbstractControl } from '@angular/forms';
import { Observable, Subject } from 'rxjs';
import { debounceTime, distinctUntilChanged, map, switchMap, takeUntil } from 'rxjs/operators';
import { ItemService } from '../../services/data-definition/product/item.service';
import { GeneralFilter } from '../../models/general/generalFilter.model';
@Component({
  selector: 'app-multi-items-lazy-loading-filter',
  templateUrl: './multi-items-lazy-loading-filter.component.html',
  styleUrls: ['./multi-items-lazy-loading-filter.component.css']
})
export class MultiItemsLazyLoadingFilterComponent implements OnInit , OnDestroy {

  @Input() TipContent='Desc_Select_Multi_Item_to_Add_to_List'
  @Input() currentFormControlName = 'packId';
  @Input() parentForm: FormGroup;
  @Input() divisionId = -1;
  @Input() categoryId = -1;
  @Input() hideLabel = false;
  @Input() selectedPackId = -1;
  @Input() clearSelectEvent: Observable<void>;
  @Input() excludeCompetitorItem = false;
  @Output() selectedItem = new EventEmitter();
  private unsubscribe$ = new Subject<void>();

  selectedItems: any[] = [];
  isItemsLoading = false;
  isRequired = false;
  itemsDataSource: any[] = [];
  itemsInput$ = new Subject<string>();
  itemFilter: GeneralFilter = {
    customListFilter: { searchFilter: '', page: 0, pageSize: 15 },
    divisionId: this.divisionId,
    itemCategoryId: this.categoryId,
    packId: this.selectedPackId,
    excludeCompetitorItem: this.excludeCompetitorItem,
    getAllItems:false
  };
  dropdownSettings = {
    singleSelection: false,
    idField: 'packId',
    textField: 'itemCodeName',
    enableCheckAll: true,
    selectAllText: 'Select All',
    unSelectAllText: 'UnSelect All',
    allowSearchFilter: true,
    itemsShowLimit: 3
  };

  constructor(private itemService: ItemService) { }
  ngOnDestroy(): void {
    this.unsubscribe$.next();
    this.unsubscribe$.complete();
    }

  ngOnInit() {

    this.currentFormControlName = 'packId'
    const control = this.parentForm.get(this.currentFormControlName);
    if (control) {
      if (control.validator != null) {
        const validator = control.validator({} as AbstractControl);
        if (validator && validator.required) {
          this.isRequired = true;
        }
      }
    } else {
      console.error(`Form control with name '${this.currentFormControlName}' not found in parent form group.`);
    }

    this.clearSelectEvent.pipe(takeUntil(this.unsubscribe$)).subscribe(() => {
      this.selectedItems = [];
    });

     this.populateAllItemsList();

  }
  ngOnChanges() {

    const control = this.parentForm.get(this.currentFormControlName);
    this.itemFilter = {
      customListFilter: { searchFilter: '', page: 0, pageSize: 15 },
      divisionId: this.divisionId,
      itemCategoryId: this.categoryId,
      packId: this.selectedPackId,
      excludeCompetitorItem: this.excludeCompetitorItem
    };
this.currentFormControlName = 'packId';
    this.populateAllItemsList();
  }

  onItemSelected($event) {

    var item = this.itemsDataSource.find(item=>item.packId==$event.packId)
    this.selectedItems.push(item);
    this.selectedItem.emit(this.selectedItems);
  }

  onItemDeselected($event) {
    this.selectedItems = this.selectedItems.filter(item => item.packId !== $event.packId);
    this.selectedItem.emit(this.selectedItems);
  }

  onSelectAll($event) {
    this.selectedItems = this.itemsDataSource;
    this.selectedItem.emit(this.selectedItems);
  }

  onDeSelectAll() {
    this.selectedItems = [];
    this.selectedItem.emit(this.selectedItems);
  }

  populateAllItemsList() {
    this.itemFilter.customListFilter.page = this.itemsDataSource.length;

    if(this.selectedPackId){
      this.itemFilter.packId = this.selectedPackId;
    }else{
      this.itemFilter.packId = -1;
    }
    this.itemFilter.itemCategoryId = this.categoryId;
    this.itemFilter.divisionId=this.divisionId;
    this.itemFilter.izLazyLodingCombo = true;
    this.itemFilter.excludeCompetitorItem = this.excludeCompetitorItem;
    this.itemFilter.getAllItems = true;
    this.isItemsLoading = true;
    this.itemService.getAllItemsLazyLoading(this.itemFilter).subscribe(result => {

      if (result && result.data) {
        this.itemsDataSource = result.data.data;

        // if (this.itemFilter.customListFilter.page === 0) {
        // } else {
        //   this.itemsDataSource = this.itemsDataSource.concat(result.data.data);
        // }
      }
      this.isItemsLoading = false;
    });
  }


  getItemSearchResultFromServer(term) {
    this.itemFilter.customListFilter.page = 0;
    this.itemsDataSource = [];
    this.itemFilter.customListFilter.searchFilter = term;
    return this.itemService.getAllItemsLazyLoading(this.itemFilter).pipe(
      map(response => response.data.data)
    );
  }

}
