import {
  Component,
  OnInit,
  Input,
  OnChanges,
  Output,
  EventEmitter,
  OnDestroy,
  ViewChild
} from "@angular/core";
import { PromotionTypes } from "../../../models/enums/promotion-types.enum";
import { CoreSession } from "../../../../core/core.session";
import { TranslateService } from "@ngx-translate/core";
import { ConstantMessages } from "../../../models/constants/constant-message";
import { PackGroupItemsComponent } from "../pack-group-items/pack-group-items.component";
import * as cloneDeep from "lodash/cloneDeep";
import { Observable } from 'rxjs';
import { FormProcessMode } from '../../../models/enums/form-process-mode.enum';
import { PromotionOutputDetailTypes } from "../../../models/enums/promotion-output-detail-types.enum";
import { ConstantConfigurations } from "../../../models/constants/constant-configuration";
import { SessionDataProvider } from "../../../../core/session-data-provider.service";
import { CalculationService } from '../../../services/calculations.service'; import { SalesTransactionTypes } from "../../../models/enums/sales-transaction-types";
import { DialogResult } from "../../../models/enums/dialog-result.enum";
import { DialogMode } from "../../../models/enums/dialog-mode.enum";
import { ItemPackModel } from "../../../models/Item/item.model";
import { PackGroupService } from "../../../services/data-definition/product/pack-group.service";
import { OrderTypes } from "../../../models/enums/order-types.enum";
import { DeliveryModes } from "../../../models/enums/delivery-modes.enum";
import { NgbModal, NgbModalConfig, NgbModalRef } from "@ng-bootstrap/ng-bootstrap";
import { ITableProperties } from "../../../models/shared-table/table-properties.interface";
import { SharedTableResult } from "../../../models/shared-table/shared-table-result.interface";
import { TourService } from "../../../shepherd-config/shepherd-config";
import { ShepherdService } from "angular-shepherd";

@Component({
  selector: "app-take-promotion",
  templateUrl: "./take-promotion.component.html",
  styleUrls: ["./take-promotion.component.css"]
})
export class TakePromotionComponent implements OnInit, OnChanges, OnDestroy {
  @ViewChild('invalidPromotionDialog', { static: true }) invalidPromotionDialog: any;
  @Output()
  takePromotion: EventEmitter<any> = new EventEmitter();

  @Output()
  cancelPromotion = new EventEmitter();

  @Input() promotions: any[] = []; // Get Current Level Promotion
  @Input() promotionsLevels: any[] = []; // Get All Promotion Levels
  @Input() transaction: any = null;
  @Input() formProcessMode = FormProcessMode.PartialDelivery;
  @Input() setPromotionAsSelected: boolean = false;
  @Input() availablePromotions: any[] = []; // Get Current Level Promotion
  @Input("ItemsList") itemsList: ItemPackModel[];
  @Input("orderTypeId") orderTypeId = -1;
  @Input("ItemProcessMode") itemProcessMode: FormProcessMode;
  @ViewChild("selectPackGroupItems", { static: true })
  selectPackGroupItems: PackGroupItemsComponent;
  includeTax = false;
  numberOfStockDigitsFormat: number = 0;
  promoWithItemSelection: any[] = [];  // Get Current Item Level Promotion
  currentLevelPromoWithItemSelection: any[] = []; // Get All Item Promotion Levels
  isPercentageChecked: boolean = true;
  isAmountChecked: boolean = false;
  totalAdded = 0;
  totalAchieved = 0;
  isOringvalid = false;
  lastInputvalue = 0;
  lastOutputRepeatCount = 0;
  oringValidationMsg = '';
  currentPromoInSelection: any = {};
  required = 0;
  pageIndex = 0;
  pageNumber = 1;
  lastPromotion: boolean = false; // To check If there is a next level or last level
  currentLevelId = 1;
  nextLevelId = 1;
  @Input() nextEvent: Observable<void>;
  nextSubscription: any;
  promotionCalculationSequence = 0;
  isfirstTimeOpen = true;
  soldItems: any[] = [];
  allowSkipPromotionIndividually: boolean = false;
  selectedPromotionList: any[] = [];
  isSelectAll: boolean = false;
  limitItemsToMainWarehouseStock: boolean = false;
  limitOrdersToWarehouseStockMessageType: string;
  limitBOSalesToWarehouseStock: boolean = false;
  affectMainWarehouseUponOrderBOInvoicing: boolean = false;
  boInvoiceBODelivery: boolean = false;
  benefitValue: number;
  prevoiusTakenItems: any[] = [];
  benefitItemData: any[] = [];
  isOrderSkipPromotion: boolean = false;
  isSalesSkipPromotion: boolean = false;
  invalidPromotionList: any[] = [];
  promotionItemDetails: any[] = [];
  blockMsg: string = '';
  addedPromotionsList: any[] = [];
  dialogRef: NgbModalRef;
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  tableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    isOnline: false,
    showSearch: false,
    showSearchBtn: false,
    showNewBtn: false,
    isMultiSelection: true,
    rowOperations: [],
    multiSelectionOperations: [],
    specificActionWhenCheckAll: true,
    specificActionWhenCheckRow: true,
    columns: [
      { title: 'Desc_Promotion', key: 'promotionName', isSortable: false, width: '50%' },
      { title: 'Desc_Message', key: 'message', isSortable: false, width: '50%' },
    ]
  };
  constructor(
    public coreSession: CoreSession,
    private translateService: TranslateService,
    private sessionData: SessionDataProvider,
    private calculationService: CalculationService,
    private packGroupService: PackGroupService,
    private config: NgbModalConfig,
    private modalService: NgbModal,
  private tourService : TourService,
private shepherdService : ShepherdService) { }


    private tourStartTimeout: any;

    startTour(forceTour?){
      this.tourStartTimeout =  setTimeout((data=>{
        if(this.tourService.isFirstTour() || forceTour){
          const elementSelectors = ['#avaliable-promo-def','#select-promo-def','#item-promo-def',
            '#select-item-promo','#select-all-item-promo-def','#back-btn','#next-btn'
        ]; // Target each column by its unique ID
        const titles = [];
        const texts = [];

        for (let index = 0; index < elementSelectors.length; index++) {
          const { title, text } = this.getTitleAndText(index);
          titles.push(title);
          texts.push(text);
        }
        const steps = this.tourService.generateSteps(elementSelectors,titles,texts);
        this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
        this.shepherdService.modal = true;
        this.shepherdService.addSteps(steps);
        this.shepherdService.start();
      }
      }),1000)
    }
  ngAfterViewInit() {
this.startTour()
  }

  getTitleAndText(index: number): { title: string, text: string } {
    let title = '';
    let text = '';
    switch (index) {
      case 0:
        title = "Desc_Available_Promotions";
        text = 'Desc_Select_Available_Promotion';
        break;
      case 1:
        title = "Desc_Selected_Promotions";
        text = "Desc_Selected_Promotion";
        break;
      case 2:
        title = "Desc_Promotion";
        text = "Desc_Promotion";
        break;
      case 3:
        title = "Desc_Take_Promotions";
        text = "Desc_Select";
        break;
      case 4:
        title = "Desc_Select_All";
        text = "Desc_Select_All";
        break;
      case 5:
        title = "Desc_back";
        text = "Desc_back";
        break;
        case 6:
          title = "Desc_Next";
          text = "Desc_Next";
          break;
      default:
        title = `Step ${index + 1}`;
        text = `Content in defult at bottom.`;
    }

    return { title, text };
  }
  ngOnInit() {
    this.subscribeNextClick();
    this.allowSkipPromotionIndividually = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowSkipPromotionIndividually).toLowerCase() === "true";
    this.limitItemsToMainWarehouseStock = this.sessionData.getConfigurationValue(ConstantConfigurations.LimitItemsToMainWarehouseStock).toLowerCase().includes("1");
    this.limitOrdersToWarehouseStockMessageType = this.sessionData.getConfigurationValue(ConstantConfigurations.LimitOrdersToWarehouseStockMessageType).toLowerCase();
    this.limitBOSalesToWarehouseStock = this.sessionData.getConfigurationValue(ConstantConfigurations.LimitBOSalesToWarehouseStock).toLowerCase() === "true";
    this.affectMainWarehouseUponOrderBOInvoicing = this.sessionData.getConfigurationValue(ConstantConfigurations.AffectMainWarehouseUponOrderBOInvoicing).toLowerCase() === "true";
    this.boInvoiceBODelivery = this.sessionData.getConfigurationValue(ConstantConfigurations.DeliveryMode).toLowerCase().includes(DeliveryModes.BOInvoicingAndDelivery.valueOf() + "");
    if (this.transaction.soldItems != null && this.transaction.soldItems.length > 0) {
      this.soldItems = this.transaction.soldItems.filter(x => x.salesTransactionTypeId != SalesTransactionTypes.Promotion.valueOf() && x.salesTransactionTypeId != SalesTransactionTypes.FOC.valueOf())
    }
    if (this.allowSkipPromotionIndividually) {
      if (this.limitItemsToMainWarehouseStock && this.itemProcessMode == FormProcessMode.Orders.valueOf() && this.orderTypeId == OrderTypes.Sales.valueOf()) {
        this.isOrderSkipPromotion = true;
      }

      if (this.limitBOSalesToWarehouseStock && (this.itemProcessMode == FormProcessMode.Sales.valueOf() || this.itemProcessMode == FormProcessMode.ExchangeReturn.valueOf())) {
        this.isSalesSkipPromotion = true;
      }
      if (this.affectMainWarehouseUponOrderBOInvoicing && this.boInvoiceBODelivery && this.itemProcessMode == FormProcessMode.Delivery.valueOf()) {
        this.isSalesSkipPromotion = true;
      }
      this.blockMsg = this.translateService.instant(ConstantMessages.MsgExceedAvailableQtyBlock) + "\n";
    }
    this.numberOfStockDigitsFormat = +this.sessionData.getConfigurationValue(ConstantConfigurations.NumberOfStockDigits);
    this.promotionCalculationSequence = +this.sessionData.getConfigurationValue(ConstantConfigurations.PromotionCalculationSequence);
    this.availablePromotions.forEach(promotion => {
      promotion.isAvailableQty = true;
      if (promotion.promotionType == PromotionTypes.StepsValues && promotion.allowOring) {
        // user should choose repeat count .
        promotion.promotionOutputs.forEach(output => {
          output.promotionOptionDetails[0].repeatCount = 0;
          output.relatedToTargetOption.originalRepeatCount = output.relatedToTargetOption.repeatCount;
        });
        promotion.totalAdded = 0;
        promotion.totalAchieved = 0;
        promotion.lastInputvalue = 0;
        promotion.lastOutputRepeatCount = 0;
      }
    });
    if (this.isfirstTimeOpen) {
      this.isfirstTimeOpen = false;
    }
  }

  ngOnChanges() {
    this.availablePromotions.forEach(promotion => {
      this.preparePromotionToView(promotion);
    });
  }

  ngOnDestroy() {
    this.nextSubscription.unsubscribe();
  }
  subscribeNextClick() {
    this.nextSubscription = this.nextEvent.subscribe(() => {
      this.onNextClicked();
    });
  }
  preparePromotionToView(promotion: any) {
    var isAnyOptionSelected = false;
    if (promotion.promotionOutputs && promotion.promotionOutputs.length > 0) {
      if (promotion.promotionOutputs.findIndex(x => x.isSelected) >= 0) {
        isAnyOptionSelected = true;
      };
    }
    switch (promotion.promotionType) {
      case PromotionTypes.FixedValues:
        if (promotion.promotionOutputs.length > 1) {
          promotion.showSelection = true;
        }
        if (this.isfirstTimeOpen || !isAnyOptionSelected) {
          promotion.promotionOutputs[0].isSelected = true;
        }
        break;
      case PromotionTypes.RangeValues:
        promotion.promotionOutputs.forEach(output => {
          output.isSelected = true;
        });
        break;
      case PromotionTypes.StepsValues:
        promotion.showStepsRepeat = true;
        promotion.promotionOutputs.forEach(output => {
          output.isSelected = true;
        });
        break;
      case PromotionTypes.TargetPromotion:
        if (this.isfirstTimeOpen || !isAnyOptionSelected) {
          promotion.promotionOutputs[0].isSelected = true;
        }
        break;
      case PromotionTypes.DynamicTargetPromotion:
        if (this.isfirstTimeOpen || !isAnyOptionSelected) {
          promotion.promotionOutputs[0].isSelected = true;
        }
        break;

    }

    if (promotion.isRepeated) {
      promotion.showRepeatCount = true;
    }

    if (promotion.promotionType === PromotionTypes.StepsValues) {
      promotion.andORGet = this.translateService.instant("Desc_And_Get");
    } else {
      promotion.andORGet = this.translateService.instant("Desc_Or_Get");
    }
  }

  onOptionSelected(promoOutput: any, promotion: any) {
    if (promoOutput.isSelected) {
      return false;
    }
    promotion.promotionOutputs.forEach(output => {
      if (output.promotionOptionId !== promoOutput.promotionOptionId) {
        output.isSelected = false;
      }
    });
    promoOutput.isSelected = !promoOutput.isSelected;
  }
  onTypeSelected(type: any, promotion: any) {

    // if (type == 'Percentage') {
    promotion.isPercentageChecked = !promotion.isPercentageChecked;
    // promotion.isAmountChecked = !promotion.isAmountChecked;


    if (promotion.isPercentageChecked) {
      promotion.promotionOutputs.forEach(output => {
        output.takeMode = 0;
      }); // takePercentage =0 , takeAmount =1
    }
    else {
      promotion.promotionOutputs.forEach(output => {
        output.takeMode = 1;
      });
    }
  }
  getNumberOnStockDigitFormat(numToRound: number) {
    return parseFloat(this.calculationService.formatNumeric(numToRound, this.numberOfStockDigitsFormat));
  }
  validatePromotions(): boolean {
    // Check Selection in Fixed Promotion and ranges
    let isValid = true;
    this.selectedPromotionList.forEach(promotion => {
      if (promotion.promotionType !== PromotionTypes.StepsValues) {
        if (
          promotion.promotionOutputs.filter(a => a.isSelected === true)
            .length === 0
        ) {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.SetPromotionOption)
          );
          isValid = false;
        }
      }
      else if (promotion.allowOring) {
        if (this.isOringvalid) {
          if (!promotion.totalAdded || promotion.totalAdded == 0) {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              this.translateService.instant(ConstantMessages.CompleteTheBenefit) + ' ' + this.translateService.instant(ConstantMessages.Promotion) + ' (' + promotion.promotionName + ')'
            );
            isValid = false;
          }
          else if (promotion.totalAdded > promotion.totalAchieved) {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              this.translateService.instant(ConstantMessages.AddedMoreThanSatisfication) + ' ' + this.translateService.instant(ConstantMessages.Promotion) + ' (' + promotion.promotionName + ')'
            );
            isValid = false;
          }
          else {
            if ((promotion.totalAchieved - promotion.totalAdded) >= promotion.lastInputvalue) {
              if (promotion.maxLimit > 0) {

                promotion.promotionOutputs.forEach(output => {
                  if (output.promotionOptionDetails[0].repeatCount < (promotion.maxLimit - output.relatedToTargetOption.originalRepeatCount) &&
                    ((promotion.totalAchieved - promotion.totalAdded) >= output.relatedToTargetOption.optionTargetValue)) {
                    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.CompleteTheBenefit) + ' ' + this.translateService.instant(ConstantMessages.Promotion) + ' (' + promotion.promotionName + ')');
                    isValid = false;
                  }
                });
              }
              else {
                this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.CompleteTheBenefit) + ' ' + this.translateService.instant(ConstantMessages.Promotion) + ' (' + promotion.promotionName + ')');
                isValid = false;
              }
            }
          }
          if (isValid) {
            promotion.promotionOutputs.forEach(output => {
              if (output.promotionOptionDetails[0].repeatCount == 0) {
                output.isSelected = false;
              } else {
                output.relatedToTargetOption.repeatCount = output.promotionOptionDetails[0].repeatCount;
              }
            });
          }
        }
        else {
          isValid = false;
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.AddedMoreThanSatisfication) + ' ' + this.translateService.instant(ConstantMessages.Promotion) + ' (' + promotion.promotionName + ')'
          );
        }
      }
    });
    return isValid;
  }

  onTakePromotionClicked() {
    if (!this.promotions || this.promotions.length === 0) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgSaveWithNoPromotionConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.onTakePromotion(true);
          }
          else if (res === DialogResult.No) {
            return;
          }
        });
    } else {
      this.promotionLevels(true);
    }
  }
  promotionLevels(isFromTakePromotion) {
    if (this.pageIndex < (this.promotionsLevels.length - 1)) {
      this.lastPromotion = false;
      if (isFromTakePromotion) {
        this.nextLevelId = this.promotionsLevels[this.pageIndex + 1] != null ? this.promotionsLevels[this.pageIndex + 1].levelId : 1;
      } else {
        this.nextLevelId = ((this.promotionsLevels.filter((x, index) => index == this.pageIndex + 1)) != null && (this.promotionsLevels.filter((x, index) => index == this.pageIndex + 1))[0] != null) ? (this.promotionsLevels.filter((x, index) => index == this.pageIndex + 1))[0].levelId : 1;
      }
    }
    else if (this.transaction.onlyProductDiscount && this.transaction.isThereAnyProductDiscountDefined) {
      this.lastPromotion = false;
      this.promoWithItemSelection = [];
    }
    else {
      this.lastPromotion = true;
      this.nextLevelId = 1;
    }
    this.onTakePromotion(isFromTakePromotion);
  }
  onTakePromotion(isFromTakePromotion) {
    let promotions = this.promotions;
    let lastPromotion = this.lastPromotion;
    let currentLevelId = this.currentLevelId;
    let nextLevelId = this.nextLevelId;
    if (isFromTakePromotion) {
      this.takePromotion.emit({ promotions, lastPromotion, currentLevelId, nextLevelId });
    } else {
      let showItemSelection = false;
      this.takePromotion.emit({ promotions, lastPromotion, showItemSelection, currentLevelId, nextLevelId });
    }

    this.promotions = [];
  }
  onCancelPromotionClicked() {
    this.promotions = [];
    this.prevoiusTakenItems = [];
    this.invalidPromotionList = [];
    this.promotionItemDetails = [];
    this.cancelPromotion.emit();
  }

  addPromoWithItemSelection(data) {
    let index = this.promoWithItemSelection.findIndex(
      i =>
        i.promotionId === data.promotionId &&
        i.promotionOptionDetailId === data.promotionOptionDetailId &&
        i.outputOptionDetailTypeId === data.outputOptionDetailTypeId
    );
    if (index < 0) {
      this.promoWithItemSelection.push(data);
    }
  }

  removePromoWithItemSelection(data, closeDialog) {
    let index = this.promoWithItemSelection.findIndex(
      i =>
        i.promotionId === data.promotionId &&
        i.promotionOptionDetailId === data.promotionOptionDetailId &&
        i.outputOptionDetailTypeId === data.outputOptionDetailTypeId
    );
    if (index >= 0) {
      this.promoWithItemSelection.splice(index, 1);
    }
    if (closeDialog)
      this.selectPackGroupItems.Close();
  }
  fillPromotionNeedItemSelection() {
    this.required = 0;
    if (this.transaction.outlet.taxable && this.sessionData.getConfigurationValue(ConstantConfigurations.AllowTax).toLowerCase() === "true"
      && this.sessionData.getConfigurationValue(ConstantConfigurations.AllowTaxOverFreeItems).toLowerCase() === "true") {
      this.includeTax = true;
    }
    for (var promo of this.selectedPromotionList) {
      let selectedPromotions = promo.promotionOutputs.filter(
        a => a.isSelected === true
      );
      for (var output of selectedPromotions) {
        for (var detail of output.promotionOptionDetails) {
          if (detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.SummationOverGroup) {
            let benefitValue = detail.value;
            let sumOfOptionsValues = 0;
            if (promo.relatedToTarget) {

              if (promo.allowOring) {
                benefitValue = output.relatedToTargetOption.benefit * output.promotionOptionDetails[0].repeatCount;
                sumOfOptionsValues = output.relatedToTargetOption.benefit * output.promotionOptionDetails[0].repeatCount;
              }
              else {
                benefitValue = output.relatedToTargetOption.benefit;
                sumOfOptionsValues = output.relatedToTargetOption.benefit;
              }
            }
            // This case for steps promotion in pack group selection
            let data = {
              promotionId: promo.promotionId,
              promotionType: promo.promotionType,
              promotonRepeatCount: promo.newRepeatCount,
              isRepeated: promo.isRepeated,
              promotionOptionId: output.promotionOptionId,
              promotionOptionDetailId: detail.promotionOptionDetailId,
              value: benefitValue,
              required: benefitValue,
              packGroupId: detail.packGroupId,
              sumOfOptionsValues: sumOfOptionsValues,
              outputOptionDetailTypeId: detail.outputOptionDetailTypeId,
              packGroupQuantity: detail.packGroupQuantity,
              defindPackGroupQuantities: detail.defindPackGroupQuantities,
              customerId: -1,
              outletId: -1,
              levelId: promo.sequence
            };

            if (promo.promotionType === PromotionTypes.StepsValues && !promo.relatedToTarget) {
              data.sumOfOptionsValues = detail.value * detail.repeatCount;

              let index = this.promoWithItemSelection.findIndex(
                i =>
                  i.promotionId === promo.promotionId &&
                  i.packGroupId === detail.packGroupId
              );

              if (index === -1) {
                this.addPromoWithItemSelection(data);
              } else {
                this.promoWithItemSelection[index].sumOfOptionsValues +=
                  data.sumOfOptionsValues;
                output.isSelected = false;
              }
            } else {
              this.addPromoWithItemSelection(data);
            }
          } else if (detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldPackGroupItems) {
            let soldItemsTotalQuantityInPcs = 0, value = 0;
            if (this.sessionData.getConfigurationValue(ConstantConfigurations.AllowConversionInPromotion).toLowerCase() === "true") {
              var soldItemsFromPackGroups = this.soldItems.filter(pack => detail.packGroupDetails.find(o => o.itemId == pack.itemId));
            }
            else {
              var soldItemsFromPackGroups = this.soldItems.filter(pack => detail.packGroupDetails.find(o => o.itemId == pack.itemId && o.packId == pack.packId));
            }
            soldItemsFromPackGroups.forEach(pack => {
              let qtyInPcs = pack.requiredQty * pack.piecesInPack / detail.packGroupDetails.find(x => x.itemId == pack.itemId).packQuantity;
              soldItemsTotalQuantityInPcs += qtyInPcs;
            });
            value = Math.round(soldItemsTotalQuantityInPcs * detail.value / 100); //normal rounding
            let benefitValue = value;
            let sumOfOptionsValues = 0;

            // This case for steps promotion in pack group selection
            let data = {
              promotionId: promo.promotionId,
              promotionType: promo.promotionType,
              promotonRepeatCount: promo.newRepeatCount,
              isRepeated: promo.isRepeated,
              promotionOptionId: output.promotionOptionId,
              promotionOptionDetailId: detail.promotionOptionDetailId,
              value: benefitValue,
              required: benefitValue,
              packGroupId: detail.packGroupId,
              sumOfOptionsValues: sumOfOptionsValues,
              outputOptionDetailTypeId: detail.outputOptionDetailTypeId,
              packGroupQuantity: detail.packGroupQuantity,
              defindPackGroupQuantities: detail.defindPackGroupQuantities,
              customerId: -1,
              outletId: -1,
              levelId: promo.sequence
            };


            this.addPromoWithItemSelection(data);

          }
          else if (detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage
            || detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.FreeItemsWithCertainValue) {
            // This case for steps promotion in pack group selection
            if (this.sessionData.getConfigurationValue(ConstantConfigurations.InvoiceValueConsideredInPromotionBenefits).toLowerCase() == '0'
              && detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage) {
              this.required = ((this.transaction.netTotal - this.transaction.tax) * detail.value) / 100;
            } else if (this.sessionData.getConfigurationValue(ConstantConfigurations.InvoiceValueConsideredInPromotionBenefits).toLowerCase() == '1'
              && detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage) {
              this.required = (this.transaction.grossTotal * detail.value) / 100;
            } else if (detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.FreeItemsWithCertainValue) {
              this.required = detail.value;
            }

            let data = {
              promotionId: promo.promotionId,
              promotionType: promo.promotionType,
              promotonRepeatCount: promo.newRepeatCount,
              isRepeated: promo.isRepeated,
              promotionOptionId: output.promotionOptionId,
              promotionOptionDetailId: detail.promotionOptionDetailId,
              value: detail.value,
              required: this.required,
              packGroupId: detail.packGroupId,
              sumOfOptionsValues: 0,
              outputOptionDetailTypeId: detail.outputOptionDetailTypeId,
              packGroupQuantity: detail.packGroupQuantity,
              defindPackGroupQuantities: detail.defindPackGroupQuantities,
              customerId: this.transaction.customerId ? this.transaction.customerId : -1,
              outletId: this.transaction.outletId ? this.transaction.outletId : -1,
              includeTax: this.includeTax,
              levelId: promo.sequence
            };

            if (promo.promotionType === PromotionTypes.StepsValues) {
              data.sumOfOptionsValues = this.required * detail.repeatCount;

              let index = this.promoWithItemSelection.findIndex(
                i =>
                  i.promotionId === promo.promotionId &&
                  i.packGroupId === detail.packGroupId
              );

              if (index === -1) {
                this.addPromoWithItemSelection(data);
              } else {
                this.promoWithItemSelection[index].sumOfOptionsValues +=
                  data.sumOfOptionsValues;
                output.isSelected = false;
              }
            } else {
              this.addPromoWithItemSelection(data);
            }
          } else if (detail.outputOptionDetailTypeId == 10) {

          }
          // the following type is for related to target promotions , so we should read the detail value from benefit value which coming from the procedure calculations .
          else if (detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount) {
            let BenefitPackGroupTotal = 0;
            if (this.sessionData.getConfigurationValue(ConstantConfigurations.InvoiceValueConsideredInPromotionBenefits).toLowerCase() == '1') {
              if (this.sessionData.getConfigurationValue(ConstantConfigurations.AllowConversionInPromotion).toLowerCase() === "true") {
                this.soldItems.forEach(element => {
                  if (detail.packGroupDetails.filter(x => x.itemId == element.itemId).length > 0) {
                    BenefitPackGroupTotal += element.grossTotal;
                  }
                });
              } else {
                this.soldItems.forEach(element => {
                  if (detail.packGroupDetails.filter(x => x.packId == element.packId).length > 0) {
                    BenefitPackGroupTotal += element.grossTotal;
                  }
                });
              }
            } else {
              if (this.sessionData.getConfigurationValue(ConstantConfigurations.AllowConversionInPromotion).toLowerCase() === "true") {
                this.soldItems.forEach(element => {
                  if (detail.packGroupDetails.filter(x => x.itemId == element.itemId)) {
                    BenefitPackGroupTotal += element.netTotal - element.tax;
                  }
                });
              } else {
                this.soldItems.forEach(element => {
                  if (detail.packGroupDetails.filter(x => x.packId == element.packId)) {
                    BenefitPackGroupTotal += element.netTotal - element.tax;
                  }
                });
              }
            }
            let benefitValue = promo.allowOring ? (output.relatedToTargetOption.benefit * output.promotionOptionDetails[0].repeatCount) : output.relatedToTargetOption.benefit;
            // if (this.sessionData.getConfigurationValue(ConstantConfigurations.InvoiceValueConsideredInPromotionBenefits).toLowerCase() == '0') {
            this.required = (BenefitPackGroupTotal * benefitValue) / 100;
            // }
            // else if (this.sessionData.getConfigurationValue(ConstantConfigurations.InvoiceValueConsideredInPromotionBenefits).toLowerCase() == '1') {
            //   this.required = (this.transaction.grossTotal * benefitValue) / 100;// should be gross for benefit pack group
            // }
            let data = {
              promotionId: promo.promotionId,
              promotionType: promo.promotionType,
              promotonRepeatCount: promo.newRepeatCount,
              isRepeated: promo.isRepeated,
              promotionOptionId: output.promotionOptionId,
              promotionOptionDetailId: detail.promotionOptionDetailId,
              value: benefitValue,
              required: this.required,
              packGroupId: detail.packGroupId,
              sumOfOptionsValues: this.required,
              outputOptionDetailTypeId: detail.outputOptionDetailTypeId,
              packGroupQuantity: detail.packGroupQuantity,
              defindPackGroupQuantities: detail.defindPackGroupQuantities,
              customerId: this.transaction.customerId ? this.transaction.customerId : -1,
              outletId: this.transaction.outletId ? this.transaction.outletId : -1,
              includeTax: this.includeTax,
              levelId: promo.sequence
            };
            if (output.takeMode == 1) {
              this.addPromoWithItemSelection(data);
            }
            else {
              this.removePromoWithItemSelection(data, false);
            }
          }
          if (detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.OpenSteps) {
            let data = {
              promotionId: promo.promotionId,
              promotionType: promo.promotionType,
              promotonRepeatCount: promo.newRepeatCount,
              isRepeated: promo.isRepeated,
              promotionOptionId: output.promotionOptionId,
              promotionOptionDetailId: detail.promotionOptionDetailId,
              value: detail.value,
              // required:this.getNumberOnStockDigitFormat((promo.totalQuantityfromPackGroup / promo.targetBenefitQuantity) * detail.value),
              required: parseFloat(this.calculationService.formatNumeric(((promo.totalQuantityfromPackGroup / promo.targetBenefitQuantity) * detail.value), 3)),
              packGroupId: detail.packGroupId,
              sumOfOptionsValues: 0,
              outputOptionDetailTypeId: detail.outputOptionDetailTypeId,
              packGroupQuantity: detail.packGroupQuantity,
              defindPackGroupQuantities: detail.defindPackGroupQuantities,
              customerId: -1,
              outletId: -1,
              levelId: promo.sequence
            };
            this.addPromoWithItemSelection(data);
          }
          if (detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.DynamicTargetSummationOverGroup) {
            let data = {
              promotionId: promo.promotionId,
              promotionType: promo.promotionType,
              promotonRepeatCount: promo.newRepeatCount,
              isRepeated: promo.isRepeated,
              promotionOptionId: output.promotionOptionId,
              promotionOptionDetailId: detail.promotionOptionDetailId,
              value: detail.value,
              // required:this.getNumberOnStockDigitFormat((promo.totalQuantityfromPackGroup / promo.targetBenefitQuantity) * detail.value),
              required: (parseFloat(this.calculationService.formatNumeric(((promo.totalQuantityfromPackGroup / promo.targetBenefitQuantity) * detail.value), 3)) - promo.benefitValue),
              packGroupId: detail.packGroupId,
              sumOfOptionsValues: 0,
              outputOptionDetailTypeId: detail.outputOptionDetailTypeId,
              packGroupQuantity: detail.packGroupQuantity,
              defindPackGroupQuantities: detail.defindPackGroupQuantities,
              customerId: -1,
              outletId: -1,
              levelId: promo.sequence
            };
            let originalBenefitValue = this.getNumberOnStockDigitFormat(((promo.totalQuantityfromPackGroup / promo.targetBenefitQuantity) * detail.value));
            //if (detail.packGroupQuantity == 1) {
            //  originalBenefitValue = parseFloat(this.calculationService.formatNumeric(originalBenefitValue, 0));
            //}
            this.addPromoWithItemSelection(data);
          }
        }
      }
    }
    if (this.promoWithItemSelection != null && this.promoWithItemSelection.length > 0)
      this.promoWithItemSelection = this.promoWithItemSelection.sort((a, b) => (a.promotionId > b.promotionId) ? 1 : -1);
    (this.promoWithItemSelection);
  }

  openSelection(promotion: any) {
    if (promotion) {
      this.currentPromoInSelection = cloneDeep(promotion[0]);
    } else if (this.currentLevelPromoWithItemSelection && this.currentLevelPromoWithItemSelection.length > 0) {
      this.currentPromoInSelection = cloneDeep(this.currentLevelPromoWithItemSelection[0]);
    }
    if (this.transaction.isThereAnyProductDiscountDefined && this.currentPromoInSelection.outputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount)
      this.currentPromoInSelection.includeTax = true;
    if (this.currentPromoInSelection.outputOptionDetailTypeId == PromotionOutputDetailTypes.SummationOverGroup
      || this.currentPromoInSelection.outputOptionDetailTypeId == PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage
      || this.currentPromoInSelection.outputOptionDetailTypeId == PromotionOutputDetailTypes.FreeItemsWithCertainValue
      || this.currentPromoInSelection.outputOptionDetailTypeId == PromotionOutputDetailTypes.OpenSteps
      || this.currentPromoInSelection.outputOptionDetailTypeId == PromotionOutputDetailTypes.DynamicTargetSummationOverGroup
      || (this.currentPromoInSelection.outputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount)
      || this.currentPromoInSelection.outputOptionDetailTypeId == PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldPackGroupItems
    ) {
      this.openSelectPackGroupItems();
    }
  }

  openSelectPackGroupItems() {
    this.selectPackGroupItems.Show().then(result => {
      if (result !== 0) {
      }
    });
  }

  onItemsSelected(selectedItems) {
    this.selectedPromotionList
      .filter(
        promotion =>
          promotion.promotionId ===
          this.currentPromoInSelection.promotionId
      )[0]
      .promotionOutputs.filter(
        output =>
          output.promotionOptionId ===
          this.currentPromoInSelection.promotionOptionId
      )[0]
      .promotionOptionDetails.filter(
        detail =>
          detail.promotionOptionDetailId ===
          this.currentPromoInSelection.promotionOptionDetailId
      )[0].selectedPromotedItems = selectedItems;
    selectedItems.forEach(selectedItem => {
      var index = this.prevoiusTakenItems.findIndex(x => x.itemId == selectedItem.itemId && x.packId == selectedItem.packId && x.salesOrderTypeId == selectedItem.salesOrderTypeId);
      if (index >= 0) {
        this.prevoiusTakenItems[index].requiredQty += selectedItem.requiredQty;
      } else {
        let itemTemp = cloneDeep(selectedItem);
        this.prevoiusTakenItems.push(itemTemp);
      }
    });
    var filteredSelectedPromotions = [];
    this.currentLevelPromoWithItemSelection.shift();
    if (this.currentLevelPromoWithItemSelection != null && this.currentLevelPromoWithItemSelection.length > 0) {
      filteredSelectedPromotions = this.currentLevelPromoWithItemSelection.filter(promo => {
        return this.selectedPromotionList.some(selectedPromo =>
          selectedPromo.promotionId === promo.promotionId && selectedPromo.isAvailableQty && this.currentPromoInSelection.promotionId != selectedPromo.promotionId
        );
      });
    }
    if (this.isSelectAll) {
      let promotions = this.selectedPromotionList.filter(x => this.currentPromoInSelection.promotionId == x.promotionId);
      if (promotions != null && promotions.length > 0) {
        promotions.forEach(x => {
          this.addedToSelectedPromotions(x);
        });
      }
    }
    if (filteredSelectedPromotions != null && filteredSelectedPromotions.length > 0 && this.isSelectAll) {
      this.openSelection(filteredSelectedPromotions);
    }
    else if (this.currentLevelPromoWithItemSelection.length > 0 && !this.isSelectAll) {
      this.openSelection(null);
    }
    else {
      this.currentLevelId = ((this.promotionsLevels.filter((x, index) => index == this.pageIndex)) != null && (this.promotionsLevels.filter((x, index) => index == this.pageIndex))[0] != null) ? (this.promotionsLevels.filter((x, index) => index == this.pageIndex))[0].levelId : 1;
      if (!this.allowSkipPromotionIndividually) {
        this.promotions = this.selectedPromotionList;
        this.promotionLevels(false);
      } else {
        if (this.isSelectAll) { // To know the promotions that have item selection
        } else {
          let promotions = this.selectedPromotionList[0];
          this.addedToSelectedPromotions(promotions);
        }
      }
      this.selectPackGroupItems.Close();
    }
  }
  onNextClicked() {
    this.pageIndex = this.pageIndex + 1;
    this.pageNumber = this.pageNumber + 1;
  }

  onItemsRemoved(selectedItems) {
    this.removePromoWithItemSelection(selectedItems, true);
  }
  onChangeRepeatCount(repeatCount, promotion, promotionOutput: any) {
    this.isOringvalid = true;
    var lastInput: any = -1;
    var lastOutput: any = -1;
    var maxValue = parseInt(((promotionOutput.relatedToTargetOption.remainingValue) / promotionOutput.relatedToTargetOption.optionTargetValue).toString());
    if (promotion.maxLimit > 0 && maxValue > (promotion.maxLimit - promotionOutput.relatedToTargetOption.originalRepeatCount)) {
      maxValue = promotion.maxLimit - promotionOutput.relatedToTargetOption.originalRepeatCount;
      promotion.totalAchieved = promotionOutput.relatedToTargetOption.remainingValue;
    }
    else {
      promotion.totalAchieved = promotionOutput.relatedToTargetOption.remainingValue;
    }
    lastInput = promotion.promotionInputs[promotion.promotionInputs.length - 1];// last input
    promotion.lastInputvalue = lastInput.promotionOptionDetails[0].value;

    lastOutput = promotion.promotionOutputs[promotion.promotionOutputs.length - 1];// last output
    promotion.lastOutputRepeatCount = lastOutput.relatedToTargetOption.originalRepeatCount;

    promotion.totalAdded = 0;

    if ((promotion.maxLimit > 0 && repeatCount.target.value > maxValue) || ((promotionOutput.relatedToTargetOption.optionTargetValue * repeatCount.target.value) > (promotionOutput.relatedToTargetOption.remainingValue))) {
      this.isOringvalid = false;
      this.coreSession.showError(
        this.translateService.instant(ConstantMessages.ErrorCaption),
        this.translateService.instant(ConstantMessages.YouCanAdd) + ' ' + maxValue + ' ' + this.translateService.instant(ConstantMessages.FromThisOption)
      );
    } else {
      promotionOutput.promotionOptionDetails[0].repeatCount = (repeatCount.target.value && repeatCount.target.value.toString() != "") ? parseInt(repeatCount.target.value.toString()) : 0;
    }
    promotion.promotionOutputs.forEach(Output => {
      promotion.totalAdded += Output.promotionOptionDetails[0].repeatCount * Output.relatedToTargetOption.optionTargetValue;
      if (lastOutput.promotionOptionDetails[0].promotionOptionDetailId == Output.promotionOptionDetails[0].promotionOptionDetailId
        && lastOutput.promotionOptionDetails[0].promotionOptionDetailTypeId == Output.promotionOptionDetails[0].promotionOptionDetailTypeId
        && lastOutput.promotionOptionDetails[0].referenceOptionId == Output.promotionOptionDetails[0].referenceOptionId) {
        promotion.lastOutputRepeatCount += Output.promotionOptionDetails[0].repeatCount;
      }
    });
  }
  removeFromSelectedPromotions(selectedPromotion) {
    this.removeFromBenefitList(selectedPromotion);
    this.availablePromotions.push(selectedPromotion);
    var index = this.promotions.findIndex(x => x.promotionId === selectedPromotion.promotionId);
    if (index >= 0) {
      this.promotions.splice(index, 1);
    }
  }
  removeFromBenefitList(selectedPromotion) {
    selectedPromotion.isChecked = false;
    selectedPromotion.promotionOutputs.filter(x => x.isSelected == true).forEach(x => {
      x.promotionOptionDetails.forEach(detail => {
        detail.selectedPromotedItems.forEach(promotionItem => {
          var index = this.prevoiusTakenItems.findIndex(x => x.itemId === promotionItem.itemId && x.packId == promotionItem.packId);
          if (index >= 0) {
            var repeatCount = 1;
            if (selectedPromotion.newRepeatCount > 0) {
              repeatCount = selectedPromotion.newRepeatCount;
            }
            else if (detail.repeatCount > 0) {
              repeatCount = detail.repeatCount;
            }
            this.prevoiusTakenItems[index].requiredQty *= this.prevoiusTakenItems[index].piecesInPack;
            this.prevoiusTakenItems[index].requiredQty -= (detail.value * promotionItem.piecesInPack * repeatCount);
            if (this.prevoiusTakenItems[index].requiredQty <= 0) {
              this.prevoiusTakenItems.splice(index, 1);
            }
          }
        });
      });
    });
  }
  removeAllSelectedPromotions() {
    this.prevoiusTakenItems = [];
    this.invalidPromotionList = [];
    this.promotionItemDetails = [];
    if (this.promotions && this.promotions.length > 0) {
      this.promotions.forEach(selectedProm => {
        selectedProm.isChecked = false;
        this.availablePromotions.push(selectedProm);
      });
    }
    this.promotions = [];
  }
  setAllPromotionsAsSelected() {
    if (this.availablePromotions && this.availablePromotions.length > 0) {
      this.isSelectAll = true;
      this.addPromotion();
    }
  }
  addToSelectdPromotions(selectedPromotion) {
    this.isSelectAll = false;
    this.addPromotion(selectedPromotion);
  }
  async addPromotion(selectedPromotion: any = []) {
    this.invalidPromotionList = [];
    this.promotionItemDetails = [];
    this.blockMsg = this.translateService.instant(ConstantMessages.MsgExceedAvailableQtyBlock) + "\n";
    this.selectedPromotionList = [];
    if (this.allowSkipPromotionIndividually) {
      if (this.isSelectAll) {
        this.selectedPromotionList = this.availablePromotions.slice();
      } else {
        this.selectedPromotionList.push(selectedPromotion);
      }
    } else {
      this.selectedPromotionList = this.availablePromotions.slice();
    }
    if (this.promotionCalculationSequence != 3) {
      this.promoWithItemSelection = [];
    }
    this.currentLevelPromoWithItemSelection = [];
    if (this.validatePromotions() === true) {
      this.fillPromotionNeedItemSelection();
      this.currentLevelId = this.promotionsLevels[this.pageIndex] != null ? this.promotionsLevels[this.pageIndex].levelId : 1;
      if (!this.allowSkipPromotionIndividually || (this.allowSkipPromotionIndividually && this.isSelectAll)) {
        this.currentLevelPromoWithItemSelection = this.promoWithItemSelection.filter(x => x.levelId == this.currentLevelId);
      } else {
        this.currentLevelPromoWithItemSelection = this.promoWithItemSelection.filter(x => x.levelId == this.currentLevelId && x.promotionId == selectedPromotion.promotionId);
      }
      if (this.currentLevelPromoWithItemSelection && this.currentLevelPromoWithItemSelection.length > 0 && !this.allowSkipPromotionIndividually) {
        this.openSelection(null);
      } else {
        if (!this.allowSkipPromotionIndividually) {
          this.promotions = this.selectedPromotionList;
          this.promotionLevels(true);
        }
        for (const promotion of this.selectedPromotionList) {
          let promise: Promise<any>;
          if (this.isSalesSkipPromotion || this.isOrderSkipPromotion) {
            // Wait for the response before moving to the next promotion
            await this.checkAvailabilityQty(promotion);
          } else if (this.allowSkipPromotionIndividually) {
            // No need to wait for this operation as it can be skipped individually
            promise = Promise.resolve(this.addedToSelectedPromotions(promotion));
          }
        }
        // After all promotions are processed, execute showPromotionValidationResult
        this.showPromotionValidationResult(selectedPromotion);
      }
    }
  }

  showPromotionValidationResult(selectedPromotion) {
    if (this.invalidPromotionList != null && this.invalidPromotionList.length > 0) {
      if (this.isOrderSkipPromotion) {
        if (this.limitOrdersToWarehouseStockMessageType.includes("1")) {
          if (this.isSelectAll) {
            this.addedPromotionsList = [];
            this.invalidPromotionList.forEach(invPromo => {
              invPromo.message = this.promotionItemDetails.find(x => x.promotionId == invPromo.promotionId).itemName;
            });
            this.showDialog();
          } else {
            var itemName = this.promotionItemDetails.find(x => x.promotionId == this.invalidPromotionList[0].promotionId).itemName;
            this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgExceedAvailableQtyConfirmation) + "\n" + this.invalidPromotionList[0].promotionName + "\n" + itemName, DialogMode.YesNo).then(
              (res: DialogResult) => {
                if (res === DialogResult.Yes) {
                  if (this.currentLevelPromoWithItemSelection != null && this.currentLevelPromoWithItemSelection.length > 0) {
                    this.openSelection(this.currentLevelPromoWithItemSelection);
                  } else
                    this.addedToSelectedPromotions(selectedPromotion);
                } else {
                  this.removeFromBenefitList(selectedPromotion);
                }
              });
          }
        } else if (this.limitOrdersToWarehouseStockMessageType.includes("2")) {

          this.coreSession.ModalDialog.ShowMessage(
            this.blockMsg, DialogMode.Ok,
            this.translateService.instant(ConstantMessages.ErrorCaption)).then(
              (result: DialogResult) => {
                if (result === DialogResult.Ok) {
                  this.invalidPromotionList.forEach(x => {
                    this.removeFromBenefitList(x);
                  })
                }
              });
        }
      } else if (this.isSalesSkipPromotion) {

        this.coreSession.ModalDialog.ShowMessage(
          this.blockMsg, DialogMode.Ok,
          this.translateService.instant(ConstantMessages.ErrorCaption)).then(
            (result: DialogResult) => {
              if (result === DialogResult.Ok) {
                this.invalidPromotionList.forEach(x => {
                  this.removeFromBenefitList(x);
                })
              }
            });
      }
    } else {
      if (this.currentLevelPromoWithItemSelection != null && this.currentLevelPromoWithItemSelection.length > 0) {
        this.openSelection(this.currentLevelPromoWithItemSelection);
      }
    }
  }
  addedToSelectedPromotions(selectedPromotion) {
    if (this.promotions.findIndex(x => x.promotionId == selectedPromotion.promotionId) < 0) {
      this.promotions.push(selectedPromotion);
      var index = this.availablePromotions.findIndex(x => x.promotionId === selectedPromotion.promotionId);
      if (index >= 0) {
        this.availablePromotions.splice(index, 1);
      }
    }
  }
  async checkAvailabilityQty(selectedPromotion) {
    let selectedOutputs = selectedPromotion.promotionOutputs.filter(
      a => a.isSelected === true
    );
    let packGroupItems = [];
    let benefitItemList = []
    var detailsCount = 0;
    var counter = 0
    let totalTakenQty = 0;
    let benefitSoldItems = [];
    var totalAvailabePackGroup = 0;
    for (var output of selectedOutputs) {
      if (selectedPromotion.promotionType == PromotionTypes.StepsValues) {
        detailsCount = selectedOutputs.length;
      } else {
        detailsCount = output.promotionOptionDetails.length;
      }
      for (var detail of output.promotionOptionDetails) {
        if (detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.ItemQuantity || detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.GroupEqualQuantity
          || detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.FreeItemsWithCertainValue || detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage
          || detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.SummationOverGroup || detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.SummationOverGroupOnTypeLevel
          || detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldItems || detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldPackGroupItems) {
          counter++;
          if (selectedPromotion.newRepeatCount > 0 && (detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.ItemQuantity || detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.GroupEqualQuantity || detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.SummationOverGroupOnTypeLevel)) {
            detail.repeatCount = selectedPromotion.newRepeatCount;
          }
          if (detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.FreeQuantityBasedOnPercentageOfCertainSoldItems) {
            let soldItemsTotalQuantityInPcs = 0, value = 0;
            var soldItems = this.soldItems.filter(x => x.ItemId == detail.ItemId);
            soldItems.forEach(item => {
              let qtyInPcs = item.requiredQty * item.piecesInPack;
              soldItemsTotalQuantityInPcs += qtyInPcs;
            });
            soldItemsTotalQuantityInPcs = soldItemsTotalQuantityInPcs / detail.piecesInPack;
            value = soldItemsTotalQuantityInPcs * detail.value / 100;
            if (selectedPromotion.newRepeatCount > 0) {
              value *= selectedPromotion.newRepeatCount;
            }
            this.benefitValue = Math.round(value); //normal rounding
            this.benefitValue *= detail.piecesInPack;
          } else {
            this.benefitValue = detail.value * detail.piecesInPack;
            if (detail.repeatCount > 0) {
              this.benefitValue *= detail.repeatCount;
            }
          }
          this.benefitItemData = []
          detail.selectedPromotedItems = [];
          //all item list filter on detail of the promotion
          let data = this.itemsList.filter(x => x.itemId == detail.itemId && x.packId == detail.packId);
          if (data != null && data.length > 0)
            this.benefitItemData = cloneDeep(data);

          if (this.benefitItemData != null && this.benefitItemData.length > 0) {
            benefitItemList = cloneDeep(this.benefitItemData);
            // benefitItemList.sort((a, b) => a.stockQty < b.stockQty ? 1 : -1);
            benefitItemList.forEach((item) => {
              if (this.prevoiusTakenItems != null && this.prevoiusTakenItems.length > 0) {
                let bItem = this.prevoiusTakenItems.filter(x => x.itemId == item.itemId);
                totalTakenQty = 0;
                if (bItem != null && bItem.length > 0) {
                  totalTakenQty = 0;
                  bItem.forEach(b => {
                    totalTakenQty += b.requiredQty * b.piecesInPack;
                  });
                }
              }
              item.stockQty -= totalTakenQty
              if ((this.isSalesSkipPromotion || this.isOrderSkipPromotion) && this.benefitValue > 0) {
                this.checkAvailabilityItem(item, detail, selectedPromotion);
              }
            });
            this.benefitItemData = benefitItemList;
            benefitSoldItems.push(...this.benefitItemData);
            if (detailsCount == counter) // when have only one detail
              this.checkValidationAvailability(benefitSoldItems, packGroupItems, selectedPromotion);
          }
          else {
            const response = await this.packGroupService.getPackGroupItems(detail.packGroupId, false, true, detail.itemId).toPromise();
            if (response.status != null && response.status >= 0) {
              packGroupItems = response.data.packGroupItems;
              if (packGroupItems != null && packGroupItems.length > 0) {
                packGroupItems.forEach((item) => {
                  if (this.prevoiusTakenItems != null && this.prevoiusTakenItems.length > 0) {
                    let bItem = this.prevoiusTakenItems.filter(x => x.itemId == item.itemId);
                    totalTakenQty = 0;
                    if (bItem != null && bItem.length > 0) {
                      totalTakenQty = 0;
                      bItem.forEach(b => {
                        totalTakenQty += b.requiredQty * b.piecesInPack;
                      });
                    } else {
                      totalTakenQty = 0;
                    }
                  }
                  var avlSoldItem = 0;
                  let soldItemList = this.soldItems.filter(x => x.itemId == item.itemId);
                  if (soldItemList != null && soldItemList.length > 0) {
                    var avlSoldItem = 0;
                    soldItemList.forEach(soldItem => {
                      avlSoldItem += soldItem.requiredQty * soldItem.piecesInPack;
                    })
                  }
                  item.stockQty -= (avlSoldItem + totalTakenQty);
                  totalAvailabePackGroup += item.stockQty;
                  if (detail.packGroupDetails != null && detail.packGroupDetails.length > 0) {
                    detail.piecesInPack = detail.packGroupDetails.find(pack => pack.itemId == item.itemId && pack.packId == item.packId).packQuantity;
                    this.benefitValue = detail.value * detail.piecesInPack;
                    if (detail.repeatCount > 0) {
                      this.benefitValue *= detail.repeatCount;
                    }
                    else if (selectedPromotion.newRepeatCount > 0) {
                      this.benefitValue *= selectedPromotion.newRepeatCount;
                    }
                  }
                  if ((this.isOrderSkipPromotion || this.isSalesSkipPromotion) && this.benefitValue > 0 && detail.outputOptionDetailTypeId == PromotionOutputDetailTypes.GroupEqualQuantity) {
                    this.checkAvailabilityItem(item, detail, selectedPromotion);
                  }
                });
                if (detail.outputOptionDetailTypeId != PromotionOutputDetailTypes.GroupEqualQuantity) {
                  if (totalAvailabePackGroup < this.benefitValue) {
                    selectedPromotion.isAvailableQty = false;
                    packGroupItems.forEach(item => {
                      item.isExceedAvailableQty = true;
                    });
                  } else {
                    selectedPromotion.isAvailableQty = true;
                  }
                }
                if (detailsCount == counter) // when have only one detail
                  this.checkValidationAvailability(benefitItemList, packGroupItems, selectedPromotion);
              } else {
                var promotionNames = selectedPromotion.promotionName;
                this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgItemDetailsNotProvided) + "\n" + promotionNames);
              }
            } else {
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
            }
          }
        } else {
          await this.checkValidationAvailability(this.benefitItemData, packGroupItems, selectedPromotion);
        }
      }
    }
    if (detailsCount == counter - 1) // when have multiple details the validation for the last one
      this.checkValidationAvailability(this.benefitItemData, packGroupItems, selectedPromotion);
  }
  checkAvailabilityItem(item, detail, selectedPromotion) {
    if (item.stockQty >= this.benefitValue) {
      var index = detail.selectedPromotedItems.findIndex(x => x.promotionId === selectedPromotion.promotionId && x.itemId == selectedPromotion.itemId && x.packId == detail.packId);
      if (index < 0) {
        item.requiredQty = this.benefitValue;
        item.stockQty -= item.requiredQty;
        this.benefitValue = 0;
        item.salesTransactionTypeId = SalesTransactionTypes.Promotion.valueOf();
        item.requiredQty /= detail.piecesInPack;
        item.salesOrderTypeId = -1;
        item.isMultiplyRepeatCount = true;
        let itemTempList = cloneDeep(item);
        detail.selectedPromotedItems.push(itemTempList);
        var indexTakenItems = this.prevoiusTakenItems.findIndex(x => x.itemId == item.itemId && x.packId == item.packId);
        if (indexTakenItems >= 0) {
          this.prevoiusTakenItems[indexTakenItems].requiredQty += item.requiredQty;
        } else {
          let itemTemp = cloneDeep(item);
          this.prevoiusTakenItems.push(itemTemp);
        }
      }
    }
    else if (this.benefitValue > 0) {
      item.stockQty -= this.benefitValue;
      item.requiredQty = this.benefitValue;
      this.benefitValue = 0;
      item.isExceedAvailableQty = true;
      item.salesTransactionTypeId = SalesTransactionTypes.Promotion.valueOf();
      item.requiredQty /= detail.piecesInPack;
      item.salesOrderTypeId = -1;
      item.isMultiplyRepeatCount = true;
      if (item.requiredQty > 0) {
        let itemTempList = cloneDeep(item);
        detail.selectedPromotedItems.push(itemTempList);
        var indexTakenItems = this.prevoiusTakenItems.findIndex(x => x.itemId == item.itemId && x.packId == item.packId);
        if (indexTakenItems >= 0) {
          this.prevoiusTakenItems[indexTakenItems].requiredQty += item.requiredQty;
        } else {
          let itemTemp = cloneDeep(item);
          this.prevoiusTakenItems.push(itemTemp);
        }
      }
    }
  }
  async checkValidationAvailability(promotedItemSameSold, packGroupItems, selectedPromotion) {
    var currentMsg = '';
    var promotionPackGroup = [];
    if (this.isOrderSkipPromotion || this.isSalesSkipPromotion) {
      if (this.currentLevelPromoWithItemSelection != null && this.currentLevelPromoWithItemSelection.length > 0) {
        promotionPackGroup = this.currentLevelPromoWithItemSelection.filter(promotion => selectedPromotion.promotionId === promotion.promotionId);
      }
      var promotionNames = selectedPromotion.promotionName;
      this.config.backdrop = "static";
      if (promotedItemSameSold != null && promotedItemSameSold.length > 0) {
        if (promotedItemSameSold.findIndex(x => x.isExceedAvailableQty == true) >= 0) {
          var itemsNames = promotedItemSameSold.filter(x => x.isExceedAvailableQty === true).map(x => x.itemName).join(',');
          if (this.invalidPromotionList.findIndex(x => x.promotionId == selectedPromotion.promotionId) < 0) {
            this.invalidPromotionList.push(selectedPromotion);
          }
          this.promotionItemDetails.push({
            promotionId: selectedPromotion.promotionId,
            promotionName: selectedPromotion.promotionName,
            itemName: promotedItemSameSold.filter(x => x.isExceedAvailableQty === true).map(x => x.itemName).join(',')
          });
          if (this.isOrderSkipPromotion) {
            if (this.limitOrdersToWarehouseStockMessageType.includes("1")) {
            } else if (this.limitOrdersToWarehouseStockMessageType.includes("2")) {
              currentMsg = promotionNames + " - " + itemsNames
              this.blockMsg += currentMsg + "\n";
            }
          } else if (this.isSalesSkipPromotion) {
            currentMsg = promotionNames + "-" + itemsNames
            this.blockMsg += currentMsg + "\n";
          }
        }
        else if (promotionPackGroup.length == 0) {
          await this.addedToSelectedPromotions(selectedPromotion);
        }
      } else if (packGroupItems.findIndex(x => x.isExceedAvailableQty == true) >= 0) {
        var itemsNames = packGroupItems.filter(x => x.isExceedAvailableQty === true).map(x => x.itemName).join(',');
        if (this.invalidPromotionList.findIndex(x => x.promotionId == selectedPromotion.promotionId) < 0) {
          this.invalidPromotionList.push(selectedPromotion);
        }
        this.promotionItemDetails.push({
          promotionId: selectedPromotion.promotionId,
          promotionName: selectedPromotion.promotionName,
          itemName: packGroupItems.filter(x => x.isExceedAvailableQty === true).map(x => x.itemName).join(',')
        });
        if (this.isOrderSkipPromotion) {
          if (this.limitOrdersToWarehouseStockMessageType.includes("1")) {
          } else if (this.limitOrdersToWarehouseStockMessageType.includes("2")) {
            currentMsg = promotionNames + "-" + itemsNames
            this.blockMsg += currentMsg + "\n";
          }
        } else if (this.isSalesSkipPromotion) {
          currentMsg = promotionNames + "-" + itemsNames
          this.blockMsg += currentMsg + "\n";
        }
      } else if (promotionPackGroup.length == 0) {
        await this.addedToSelectedPromotions(selectedPromotion);
      }
    } else {
      await this.addedToSelectedPromotions(selectedPromotion);
    }
  }
  public showDialog() {
    this.dataSource = {
      data: this.invalidPromotionList,
      totalItems: this.invalidPromotionList.length
    }
    this.dialogRef = this.modalService.open(this.invalidPromotionDialog, { centered: true, size: 'lg', backdrop: 'static' });

    // Return the result of the dialog
    return this.dialogRef.result.then(
      (result) => {
        return result;
      }
    );
  }
  closeDialog() {
    var promoList = [];
    if (this.invalidPromotionList != null && this.invalidPromotionList.length > 0) {
      this.invalidPromotionList.forEach(promo => {
        this.removeFromBenefitList(promo);
      })
      this.invalidPromotionList = [];
      this.promotionItemDetails = [];
      // this.modalService.dismissAll();
      if (this.currentLevelPromoWithItemSelection != null && this.currentLevelPromoWithItemSelection.length > 0) {
        for (const promotion of this.selectedPromotionList) {
          var promo = this.currentLevelPromoWithItemSelection.find(x => promotion.promotionId == x.promotionId && promotion.isAvailableQty);
          if (promo) {
            promoList.push(promo);
          }
        }
      }
      if (promoList != null && promoList.length > 0) {
        this.openSelection(promoList);
      }
      if (this.dialogRef) {
        this.dialogRef.close();
      }
    }
  }
  onCheckRowOperation(promotion) {
    var index = this.addedPromotionsList.findIndex(x => x.promotionId === promotion.promotionId);
    if (promotion.isChecked) {
      if (index < 0) {
        this.addedPromotionsList.push(promotion);
      }
    } else {
      if (index >= 0) {
        this.addedPromotionsList.splice(index, 1);
      }
    }
  }
  onCheckAllOperation(checkAll: boolean) {
    this.dataSource.data.forEach(promotion => {
      var index = this.addedPromotionsList.findIndex(x => x.promotionId === promotion.promotionId);
      if (index >= 0 && !checkAll) {
        this.addedPromotionsList.splice(index, 1);
      } else if (index < 0 && checkAll) {
        this.addedPromotionsList.push(promotion);
      }
    })
  }
  onSaveInvalidPromotionClick() {
    var promoList = [];
    // not valid promotion when selected from invalid dialog
    if (this.addedPromotionsList != null && this.addedPromotionsList.length > 0) {
      for (const promotion of this.addedPromotionsList) {
        if (this.currentLevelPromoWithItemSelection != null && this.currentLevelPromoWithItemSelection.length > 0) {
          var promo = this.currentLevelPromoWithItemSelection.find(x => x.promotionId == promotion.promotionId);
          if (promo) {
            promotion.isAvailableQty = true;
            promoList.push(promo);
          } else {
            this.addedToSelectedPromotions(promotion)
          }
        } else {
          this.addedToSelectedPromotions(promotion)
        }
      }
      if (promoList != null && promoList.length > 0) {
        this.openSelection(promoList);
      }
      let invalidList = this.invalidPromotionList.filter(invalidPromo => {
        return !this.addedPromotionsList.some(addedPromo => addedPromo.promotionId === invalidPromo.promotionId);
      });
      if (invalidList != null && invalidList.length > 0) {
        invalidList.forEach(x => {
          this.removeFromBenefitList(x);
        });
      }
      if (this.dialogRef) {
        this.dialogRef.close();
      }
      // this.modalService.dismissAll();
    }
  }
}

