import { Component, OnInit, Input, TemplateRef, Output, EventEmitter } from '@angular/core';
import { TourService } from '../../shepherd-config/shepherd-config';
import { ConstantStorage } from '../../models/constants/constant-stroage';

@Component({
  selector: 'app-slider',
  templateUrl: './slider.component.html',
  styleUrls: ['./slider.component.css']
})
export class SliderComponent implements OnInit {

  @Input('bodyTemplet') bodyTemplet: TemplateRef<any>;
  @Input('width') width: string;
  @Input('showFooter') showFooter: boolean = true;
  @Input('saveString') saveString: string = 'Desc_Save';
  @Input('saveButtonIcon') saveButtonIcon:string='fa fa-floppy-o';
  @Input('showHeader') showHeader: boolean = false;
  @Input('showTourButton') showTourButton: boolean = true;

  @Input('headerString') headerString: string = '';
  @Input ('hasInternalFooter') hasInternalFooter=false;
  @Input('isModelEntry') isModelEntry: boolean=false;

  @Output('closeSlider') closeSlider = new EventEmitter();
  @Output('saveClicked') saveClicked = new EventEmitter();

  constructor(
    private tourService: TourService,
  ) { }

  ngOnInit() {
    var language = +localStorage.getItem(ConstantStorage.LanguageId);
  if(language != 1)
    this.showTourButton = false;
  }

  onCloseSlider() {
    this.closeSlider.emit();
  }

  onSaveClicked() {
    this.saveClicked.emit();
  }

  startTourForCurrentComponent(isModelEntry:boolean) {

    if(isModelEntry){
      this.tourService.startTourEntryModel();
    }else{
      this.tourService.startTourEntry();
    }
  }

}
