import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { PricesAndOffersService } from '../../../content/master-data-definition/prices-and-offers-management/prices-and-offers.service';
import { CoreSession } from '../../../core/core.session';
import { ConstantMessages } from '../../models/constants/constant-message';
import { EmailFileModel } from '../../models/email/email.model';
import { ConstantConfigurations } from '../../models/constants/constant-configuration';
import { SessionDataProvider } from '../../../core/session-data-provider.service';

@Component({
  selector: 'app-take-contracted-foc',
  templateUrl: './take-contracted-foc.component.html',
  styleUrls: ['./take-contracted-foc.component.css']
})

export class TakeContractedFocComponent implements OnInit {
  @Input() contractedFOCs: any[];
  @Input() contractedFOCsTest : any = {
    focs : [],
    attachments :  []
  };
  @Input() transactionTotal: number = 0;
  @Output() applyContractedFOCs: EventEmitter<any> = new EventEmitter();

  maxIndex: number = 0;
  attachedFiles: EmailFileModel[] = [];
  deletedFiles: string[] = [];
  direction: any;
  ShelfIncentiveImagesMin: number = 0;
  ShelfIncentiveImagesMax: number = 0;
  showButton = true;
  
  constructor(  
    private sessionData: SessionDataProvider,
      public coreSession: CoreSession,
      private translateService: TranslateService,
    ) { }

  ngOnInit(): void {
    this.ShelfIncentiveImagesMin = +this.sessionData.getConfigurationValue(ConstantConfigurations.ShelfIncentiveImagesMin);
    this.ShelfIncentiveImagesMax = +this.sessionData.getConfigurationValue(ConstantConfigurations.ShelfIncentiveImagesMax);
    this.direction = this.coreSession.isRTL;

    if(this.ShelfIncentiveImagesMax === 0){
      this.showButton = false;
    }
  }

onUploadFiles(file , FOC) {
    if (file) {
      let files = file.srcElement.files;
      if (files.length > 0) {
          const attachedFilesCount = this.attachedFiles.filter(file => file.fOCId == FOC.contractId).length;
          if (attachedFilesCount + files.length > this.ShelfIncentiveImagesMax) {
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
              this.translateService.instant(ConstantMessages.MsgShelfIncentiveImagesMax)
              .replace('{0}', FOC.contractName)
              .replace('{1}', this.ShelfIncentiveImagesMax)
            );
            return; 
          }
        for (let index = 0; index < files.length; index++) {
          if (files[index].size > 10000000) //10 MB
          {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorLargeSize));
          }
          else {
            let fileObject = new EmailFileModel();
            let reader = new FileReader();
            fileObject.file = files[index];
            fileObject.name = files[index].name;
            let dotes = files[index].name && (files[index].name.length > 20) ? '..' : '';
            fileObject.shortName = files[index].name.substring(0, 20) + dotes;
            fileObject.index = this.maxIndex;
            fileObject.fOCId = FOC.contractId;            ;
            fileObject.isImage = files[index].type.includes('image') ? true : false;
            reader.onload = (event: ProgressEvent) => {
              if (fileObject.isImage) {
                fileObject.path = (<FileReader>event.target).result;
              } else {
                fileObject.path = this.coreSession.getDefaultPathAttachments();
              }
              fileObject.pathFile = fileObject.name;
            };
            reader.readAsDataURL(file.target.files[index]);
            this.maxIndex++;
            this.attachedFiles.push(fileObject);
          }
        }
      }
    }
  }

  getContractFiles(contractId: number) {
    return this.attachedFiles.filter((item) => item.fOCId === contractId)
  }

  onDeleteFile(file, fileInput) {
    this.deletedFiles.push(file.name);
    this.attachedFiles.splice(this.attachedFiles.indexOf(file), 1);
    fileInput.value = ""
  }

  onApplyFOCClicked(FOC) {
    for (let i = 0; i < FOC.length; i++) {
      const FocObj = FOC[i];
      const attachedFilesCount = this.attachedFiles.filter(file => file.fOCId === parseInt(FocObj.contractId)).length;
      if (attachedFilesCount < this.ShelfIncentiveImagesMin) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.MsgShelfIncentiveImagesMin)
          .replace('{0}', FocObj.contractName)
          .replace('{1}', this.ShelfIncentiveImagesMin)
        );
        return false; 
      } else if (attachedFilesCount > this.ShelfIncentiveImagesMax) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.MsgShelfIncentiveImagesMax)
          .replace('{0}', FocObj.contractName)
          .replace('{1}', this.ShelfIncentiveImagesMax)
        );
        return false; 
      }
    }
    this.contractedFOCsTest.focs =this.contractedFOCs;
    this.contractedFOCsTest.attachedFiles =this.attachedFiles;
    this.applyContractedFOCs.emit(this.contractedFOCsTest);
  }
}
