import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { ResponseModel } from '../../models/api-models/api-models';
import { CoreSession } from '../../../core/core.session';
import { Observable } from 'rxjs-compat';


@Injectable({
  providedIn: 'root'
})
export class WebFormService {
  httpOptions;
  private url = '';
  constructor(private http: HttpClient,
    @Inject('BASE_URL') baseUrl: string,
    private coreSession: CoreSession) {
    this.url = baseUrl + 'WebForm';
    this.httpOptions = {
      headers: new HttpHeaders({
        'Content-Type': 'application/json'
      })
    };
  }

  initializeWebFormList(filter) {
    const urlValue: string = this.url + '/InitializeWebFormList';
    return this.http.post(urlValue, JSON.stringify(filter), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      });
  }
  getWebFormListData(filter) {
    const urlValue: string = this.url + '/GetWebFormListData';
    return this.http.post(urlValue, JSON.stringify(filter), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      });
  }
  initializeWebFormEntry(filter) {
    const urlValue: string = this.url + '/InitializeWebFormEntry';
    return this.http.post(urlValue, JSON.stringify(filter), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      });
  }
  saveEntryForm(formData, isEditMode: boolean) {
    const urlValue: string = this.url + (isEditMode ? '/UpdateEntryForm' : '/InsertEntryForm');
    return this.http.post(urlValue, formData).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  fillControlsDataSourceBasedOnParentControlValue(childsControls) {
    const urlValue: string = this.url + '/FillControlsDataSourceBasedOnParentControlValue';
    return this.http.post(urlValue, childsControls, this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  checkForUniqueValidation(form) {
    const urlValue: string = this.url + '/CheckForUniqueValidation';
    return this.http.post(urlValue, JSON.stringify(form), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  performActionProcedure(filter) {
    const urlValue: string = this.url + '/PerformActionProcedure';
    return this.http.post(urlValue, JSON.stringify(filter), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }

  getOrganizationDetailsForParent(organizationId: number) {
    const urlValue = this.url + '/getOrganizationDetailsForParent';
    return this.http
      .post<ResponseModel>(urlValue, organizationId)
      .map(response => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }

  downloadFile(primaryKey: string, webMenuURL: string, fileName: string, fileType: string): Observable<any> {
        let fileExtension = fileType;
        const urlValue =
            this.url +
            "/DownloadFile?primaryKey=" + primaryKey + "&webMenuURL=" + webMenuURL + "&fileName=" + fileName;

        return this.http.post(urlValue, "", { responseType: "blob" }).map(res => {
            var blob = new Blob([res], { type: fileExtension });
            return blob;
        });
    }

  printWebForm(webform: any) {
    const urlValue = this.url + "/PrintWebForm";
    this.coreSession.ModalLoading.Show();
    this.http.post(urlValue, webform, { responseType: "blob" }).map(res => {
      var blob = new Blob([res], { type: "application/pdf" });
      return blob;
    }).subscribe(
      success => {
        const fileURL = URL.createObjectURL(success);
        const newFileURL = fileURL;
        window.open(newFileURL, "_blank");
        this.coreSession.ModalLoading.Hide();
      },
      err => {
        this.coreSession.ModalLoading.Hide();
      }
    );
  }
}
