import { DateTimeModel } from "../dateTimeModel/date-time.model";
import { ChattingMediaTypes } from "../enums/chatting/chatting-media-types.enum";
import { ChattingUser } from "./chatting-user.model";
export  class ChattingHistoryModel {
    messageId: string;
    senderId: number;
    receiverId: number;
    senderName: string;
    receiverName: string;
    messageBody: string;
    isRead: boolean;
    isMessageReceived: boolean;
    messageDateTimeModel: DateTimeModel;
    readingDateTimeModel: DateTimeModel;
    receiverDeviceToken: string;
    receiverDeviceSerial: string;
    isBOReceiver: boolean;
    senderDeviceToken: string;
    senderDeviceSerial: string;
    isBOSender: boolean;
    customerId: number;
    outletId: number;
    messageDate?: Date;
    customerCode: string;
    outletName:string;
    receiversList:BroadcastReceiverModel[];
    customerOutletDescriptions:CustomerOutletDescriptions[];
    customerName:string;
    outletCode:string;
    imagePath:string;
    mediaList:any[];
    hasText: boolean;
    hasMedia:boolean;
    mediaExpiryDateModel: DateTimeModel;
    messageDateTime;
    constructor() {
        this.messageId = '';
        this.senderId = -1;
        this.receiverId = -1;
        this.isRead =  false;
        this.isMessageReceived = false;
        this.isBOReceiver = false;
        this.isBOSender = false;
        this.customerId = -1;
        this.outletId = -1;
        this.senderDeviceSerial = "";
        this.senderDeviceToken = "";
        this.receiverDeviceToken = "";
        this.receiverDeviceSerial = "";
        this.customerName = '';
        this.outletCode = '';
        this.imagePath = '';
        this.mediaList = [];
        this.hasText = false;
        this.hasMedia = false;
    }
}

export class BroadcastReceiverModel {
    messageId: string;
    receiverId: number;
    receiverName: string;
    isBOReceiver: boolean;
  receiverDeviceToken: string;

    constructor() {
        this.messageId = '';
        this.receiverId = -1;
        this.receiverName = '';
        this.isBOReceiver = false;
        this.receiverDeviceToken = "";
    }
}

export class CustomerOutletDescriptions {
    outletDescription: string;
    customerDescription: string;
    languageId: number;
    customerId: number;
    outletId: number;

    constructor() {
        this.outletDescription = '';
        this.customerDescription = '';
        this.languageId = -1;
        this.customerId = -1;
        this.outletId = -1;
    }
}

export class ChattingHistoryMediaModel {
    messageId: string
    fileName: string
    mediaType: ChattingMediaTypes
    isDownloaded: boolean
    imagePath: string
    webIcon: string;
    downloadDate?: Date;

    constructor() {
        this.messageId = '';
        this.fileName = '';
        this.mediaType = ChattingMediaTypes.None;
        this.isDownloaded = false;
        this.imagePath = '';
        this.webIcon = '';
    }
}
